<?php
// 1. Cargar dependencias y configuración
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/Campania.php';
require_once __DIR__ . '/../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class CampanasExcelController {

    private $model;

    public function __construct() {
        $database = new Database();

        $db = $database->getConnection(); 

        $this->model = new Campania($db);
    }

    public function exportar() {
        // Obtener solo las campañas PADRE (Nivel 1)
        $campanasPadre = $this->model->listarPrincipales();

        $excel = new Spreadsheet();


        $sheetCampanas = $excel->getActiveSheet();
        $sheetCampanas->setTitle('Campañas Principales');

        $headersCampanas = [
            'A1' => 'ID',
            'B1' => 'Título',
            'C1' => 'Asunto',
            'D1' => 'Inicio',
            'E1' => 'Fin',
            'F1' => 'Fecha Creación'
        ];

        foreach ($headersCampanas as $cell => $text) {
            $sheetCampanas->setCellValue($cell, $text);
            // Estilo negrita básico
            $sheetCampanas->getStyle($cell)->getFont()->setBold(true);
        }

        $row = 2;
        foreach ($campanasPadre as $c) {
            $sheetCampanas->setCellValue("A$row", $c['id_campania']);
            $sheetCampanas->setCellValue("B$row", $c['titulo']);
            $sheetCampanas->setCellValue("C$row", $c['asunto']);
            $sheetCampanas->setCellValue("D$row", $c['fecha_inicio']);
            $sheetCampanas->setCellValue("E$row", $c['fecha_fin']);
            $sheetCampanas->setCellValue("F$row", $c['created_at']);
            $row++;
        }
        
        // Auto-ajustar columnas Hoja 1
        foreach(range('A','F') as $col) {
            $sheetCampanas->getColumnDimension($col)->setAutoSize(true);
        }

 
        $sheetSub = $excel->createSheet();
        $sheetSub->setTitle('Subcampañas');

        $headersSub = [
            'A1' => 'ID Sub',
            'B1' => 'ID Padre',
            'C1' => 'Título Padre (Referencia)',
            'D1' => 'Título Subcampaña',
            'E1' => 'Asunto',
            'F1' => 'Inicio',
            'G1' => 'Fin'
        ];

        foreach ($headersSub as $cell => $text) {
            $sheetSub->setCellValue($cell, $text);
            $sheetSub->getStyle($cell)->getFont()->setBold(true);
        }

        $row = 2;
        foreach ($campanasPadre as $padre) {
    
            $hijas = $this->model->listarHijas($padre['id_campania']);

            foreach ($hijas as $hija) {
                $sheetSub->setCellValue("A$row", $hija['id_campania']);
                $sheetSub->setCellValue("B$row", $hija['parent_id']);
                $sheetSub->setCellValue("C$row", $padre['titulo']); // Para saber visualmente de quién es
                $sheetSub->setCellValue("D$row", $hija['titulo']);
                $sheetSub->setCellValue("E$row", $hija['asunto']);
                $sheetSub->setCellValue("F$row", $hija['fecha_inicio']);
                $sheetSub->setCellValue("G$row", $hija['fecha_fin']);
                $row++;
            }
        }

        // Auto-ajustar columnas Hoja 2
        foreach(range('A','G') as $col) {
            $sheetSub->getColumnDimension($col)->setAutoSize(true);
        }

        $filename = 'reporte_campanias_' . date('Y-m-d_H-i-s') . '.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header('Cache-Control: max-age=0');

        $writer = new Xlsx($excel);
        $writer->save('php://output');
        exit;
    }
}

// ROUTER SIMPLE PARA ESTE CONTROLADOR
if (isset($_GET['action']) && $_GET['action'] === 'exportar') {
    $exportador = new CampanasExcelController();
    $exportador->exportar();
}