<?php
require_once __DIR__.'/session.php';
require_once __DIR__.'/remember.php';
require_once __DIR__.'/database.php';
$base = defined('APP_BASE_PATH') ? APP_BASE_PATH : '/';

function getUserTipoEmpleado() {
    return isset($_SESSION['tipoempleado']) ? trim($_SESSION['tipoempleado']) : null;
}

function moduleAccessMatrix(): array {
    // Ajustar segun negocio. '*' significa todos los modulos.
    return [
        'comercial' => [
            'operario' => [
                'clientes',
                'empresas',
                'contactos_empresa',
                'requerimientos_v2',
                'leads',
                'proveedores',
                'proveedor_contactos',
                'requerimientos','cumples',
                'catalogos',
                'lista_precios',
                'ferias_eventos',
                'campanas',
            ],
            'lider'    => ['clientes',
                'empresas',
                'contactos_empresa',
                'requerimientos_v2',
                'leads',
                'proveedores',
                'proveedor_contactos',
                'requerimientos','cumples',
                'catalogos',
                'lista_precios',
                'ferias_eventos',
                'campanas',],
        ],
        'sistemas' => [
            'operario' => ['clientes', 'empresas', 'contactos_empresa', 'requerimientos_v2', 'leads', 'proveedores', 'proveedor_contactos', 'productos', 'categorias', 'requerimientos', 'logistica'],
            'lider'    => ['*'],
        ],
        'logistica' => [
            'operario' => ['clientes','logistica'],
            'lider'    => ['clientes','logistica'],
        ],
        'programacion' => [
            'operario' => ['logistica'],
            'lider'    => ['logistica'],
        ],
        'soporte' => [
            'operario' => ['logistica'],
            'lider'    => ['logistica'],
        ],
    ];
}

function hasModuleAccess(string $moduleKey): bool {
    $moduleKey = strtolower($moduleKey);
    $tipo = strtolower(trim(getUserTipoEmpleado() ?? ''));
    $area = strtolower(trim(getUserArea() ?? ''));

    // Lider (tipoempleado=lider) tiene acceso total
    if ($tipo === 'lider') {
        return true;
    }

    $map = moduleAccessMatrix();
    $areaMap = $map[$area] ?? null;
    if (!$areaMap) {
        // Sin regla definida para el area => bloquear por defecto
        return false;
    }

    $perms = $areaMap[$tipo] ?? [];
    if (in_array('*', $perms, true)) {
        return true;
    }

    return in_array($moduleKey, $perms, true);
}


function denyAccess(string $moduleKey = ''): void {
    global $base;
    $isJson = isset($_SERVER['HTTP_ACCEPT']) && str_contains(strtolower($_SERVER['HTTP_ACCEPT']), 'json');
    $isAjax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
    if ($isJson || $isAjax) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Acceso denegado', 'module' => $moduleKey]);
    } else {
        header("Location: ".$base."unauthorized.php");
    }
    exit();
}

function requireModuleAccess(string $moduleKey): void {
    requireLogin();
    if (!hasModuleAccess($moduleKey)) {
        denyAccess($moduleKey);
    }
}

// Completa/refresca datos de sesion (area/tipoempleado) para que cambios en BD apliquen sin re-login.
function ensureUserSessionHydrated(): void {
    if (!isset($_SESSION['idusuario'])) {
        return;
    }
    $now = time();
    $lastSync = $_SESSION['last_permission_sync'] ?? 0;
    $needsRefresh = !isset($_SESSION['tipoempleado']) || ($now - (int)$lastSync) >= 60;
    if (!$needsRefresh) {
        return;
    }
    try {
        $db = (new Database())->getConnection();
        $stmt = $db->prepare("SELECT area, tipoempleado FROM usuarios WHERE idusuario = :id LIMIT 1");
        $stmt->execute([':id' => $_SESSION['idusuario']]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) {
            $_SESSION['area'] = $row['area'] ?? $_SESSION['area'] ?? null;
            $_SESSION['tipoempleado'] = $row['tipoempleado'] ?? null;
            $_SESSION['last_permission_sync'] = $now;
        }
    } catch (Throwable $e) {
        // Si falla, continuar con la sesion existente.
    }
}

function getUserRole() {
    // return isset($_SESSION['user_role']) ? $_SESSION['user_role'] : null;
    return 0;
}

function getUserArea() {
    return isset($_SESSION['area']) ? $_SESSION['area'] : null;
}

function isRegularUser() {
    return getUserRole() == 3; // 3 = usuario
}
function isLoggedIn() {
    return isset($_SESSION['idusuario']);
}
function requireLogin() {
    global $base;
    if (!isLoggedIn()) {
        if (rememberTryLogin()) {
            return;
        }
        header("Location:".$base."login.php");
        exit();
    }
    ensureUserSessionHydrated();
}
function isTIArea() {
    return getUserArea() === 'Programacion' || getUserArea() === 'Soporte'; // 1 = admin_dios
}

function isWebsocketArea(){
    return in_array(getUserArea(), ['Administracion', 'Logistica', 'Comercial', 'Programacion', 'Soporte', 'Sistemas', 'Telemarketing'], true );
}
function requireTIArea() { 
    global $base;   
    requireLogin();
    if (!isTIArea()) {
        header("Location: ".$base."unauthorized.php");
        exit();
    }else{
        $currentUser = json_encode(["user" => $_SESSION['usuario'], "area" => $_SESSION['area']]);
        echo "<script>var base = '$base'; var currentUser = $currentUser</script>";
    }
}
function requireRegularArea() { 
    global $base;   
    if (!isLoggedIn()) {
        header("Location:".$base."login.php");
        exit();
    }else{
        $currentUser = json_encode(["user" => $_SESSION['usuario'], "area" => $_SESSION['area']]);
        echo "<script>var base = '$base'; var currentUser = $currentUser</script>";
    }
}
function isAdminDios() {
    return getUserRole() == 1; // 1 = admin_dios
}
function isAdminArea() {
    return getUserRole() == 2; // 2 = admin_area
}
