-- CHARACTER SET 'utf8' COLLATE 'utf8_spanish_ci' NULL DEFAULT NULL ;

ALTER TABLE `clientes`
ADD COLUMN `notion_page_id` VARCHAR(36) NULL AFTER `accionescliente`,
ADD COLUMN `last_sync_time` DATETIME NULL AFTER `notion_page_id`,
ADD COLUMN `sync_source` VARCHAR(10) NULL AFTER `last_sync_time`,
ADD COLUMN `creadopor` INT(11) NOT NULL AFTER `sync_source`,
ADD COLUMN `fecha_de_actualizacion` DATETIME NULL AFTER `creadopor`,
ADD COLUMN `account` TEXT NULL AFTER `fecha_de_actualizacion`,
;

ALTER TABLE `usuarios`
 ADD COLUMN `notion_page_id` VARCHAR(36) NULL AFTER `correo`,
 ADD COLUMN `last_sync_time` DATETIME NULL AFTER `notion_page_id`,
 ADD COLUMN `sync_source` VARCHAR(10) NULL AFTER `last_sync_time`,
 ADD COLUMN `fecha_creacion` DATETIME NULL AFTER `sync_source`,
 ADD COLUMN `puesto` VARCHAR(45) NOT NULL AFTER `area`
;


INSERT INTO acciones (id_tabla, valor, categoria, accion)
VALUES (0, 8, 'detalle_origen', 'CAMPAÑA');

-- delete from `usuarios`  where idusuario > 513;
-- delete from `clientes`  where idcliente > 15196;
-- delete from `groupemail` where tabla = "clientes" and idtabla > 15196;

-- CREATE TABLE sync_metadata (
--     id INT AUTO_INCREMENT PRIMARY KEY,
--     entity_type VARCHAR(50) NOT NULL,  -- 'clientes', 'usuarios', etc.
--     entity_id INT NOT NULL,            -- ID del registro en la tabla original
--     sync_source VARCHAR(50),
--     notion_page_id VARCHAR(100),
--     last_sync_time DATETIME,
--     UNIQUE (entity_type, entity_id)
-- );



-- tablas usadas en el modulo de campanas
CREATE TABLE campanias (
    id_campania INT AUTO_INCREMENT PRIMARY KEY,
    parent_id INT NULL,
    mautic_instancia_id INT NULL,
    titulo VARCHAR(150) NOT NULL,
    asunto VARCHAR(200) NULL,
    fecha_inicio DATE NULL,
    fecha_fin DATE NULL,
    registro INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    CONSTRAINT fk_campanias_parent
        FOREIGN KEY (parent_id)
        REFERENCES campanias(id_campania)
        ON DELETE CASCADE
        ON UPDATE CASCADE
);

CREATE TABLE campania_contacto (
    campania_id INT NOT NULL,
    contacto_id bigint(20) UNSIGNED NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (campania_id, contacto_id),
    CONSTRAINT fk_cc_campania
        FOREIGN KEY (campania_id)
        REFERENCES campanias(id_campania)
        ON DELETE CASCADE
        ON UPDATE CASCADE,
    CONSTRAINT fk_cc_contacto
        FOREIGN KEY (contacto_id)
        REFERENCES contacto(id)
        ON DELETE CASCADE
        ON UPDATE CASCADE
);

-- tablas de integracion con Mautic
CREATE TABLE mautic_instancias (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NULL,
    base_url VARCHAR(255) NOT NULL,
    min_campaign_id INT NULL DEFAULT NULL,
    auth_type VARCHAR(20) NOT NULL DEFAULT 'basic',
    api_user VARCHAR(150) NULL,
    api_pass VARCHAR(255) NULL,
    oauth_client_id VARCHAR(255) NULL,
    oauth_client_secret VARCHAR(255) NULL,
    oauth_redirect_uri VARCHAR(255) NULL,
    oauth_access_token TEXT NULL,
    oauth_refresh_token TEXT NULL,
    oauth_expires_at DATETIME NULL,
    activo TINYINT(1) NOT NULL DEFAULT 1,
    last_sync_at DATETIME NULL,
    last_report_sync_at DATETIME NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE mautic_segmentos_map (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    segmento_clave VARCHAR(80) NOT NULL,
    mautic_segment_id INT NOT NULL,
    descripcion VARCHAR(200) NULL,
    UNIQUE KEY uq_segmento_instancia (mautic_instancia_id, segmento_clave),
    KEY idx_segmento_instancia (mautic_instancia_id)
);

CREATE TABLE mautic_reportes_map (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    report_key VARCHAR(80) NOT NULL,
    report_id INT NOT NULL,
    campo_campania VARCHAR(80) NOT NULL DEFAULT 'id',
    campo_lead_id VARCHAR(80) NULL,
    campo_email VARCHAR(80) NOT NULL DEFAULT 'email_address',
    campo_subject VARCHAR(80) NULL DEFAULT NULL,
    campo_clicks VARCHAR(80) NOT NULL DEFAULT 'clicks',
    campo_date_sent VARCHAR(80) NOT NULL DEFAULT 'date_sent',
    campo_date_read VARCHAR(80) NOT NULL DEFAULT 'date_read',
    activo TINYINT(1) NOT NULL DEFAULT 1,
    UNIQUE KEY uq_reporte_instancia (mautic_instancia_id, report_key),
    KEY idx_reporte_instancia (mautic_instancia_id)
);

CREATE TABLE mautic_contacto_map (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    contacto_id BIGINT UNSIGNED NOT NULL,
    mautic_lead_id BIGINT UNSIGNED NOT NULL,
    last_sync_at DATETIME NULL,
    UNIQUE KEY uq_contacto_instancia (mautic_instancia_id, contacto_id),
    UNIQUE KEY uq_lead_instancia (mautic_instancia_id, mautic_lead_id),
    KEY idx_contacto_instancia (mautic_instancia_id)
);

CREATE TABLE mautic_contacto_email_map (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    contacto_email_id BIGINT UNSIGNED NOT NULL,
    mautic_lead_id BIGINT UNSIGNED NOT NULL,
    last_sync_at DATETIME NULL,
    UNIQUE KEY uq_email_instancia (mautic_instancia_id, contacto_email_id),
    UNIQUE KEY uq_lead_email_instancia (mautic_instancia_id, mautic_lead_id),
    KEY idx_email_instancia (mautic_instancia_id)
);

CREATE TABLE mautic_email_pendiente (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    email VARCHAR(255) NOT NULL,
    mautic_campaign_id INT NULL,
    campania_id INT NULL,
    mautic_lead_id BIGINT UNSIGNED NULL,
    source VARCHAR(50) NOT NULL DEFAULT 'report',
    first_seen_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_seen_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uq_email_instancia_campaign (mautic_instancia_id, email, mautic_campaign_id),
    KEY idx_email_instancia (mautic_instancia_id),
    KEY idx_email (email)
);

CREATE TABLE mautic_lista_map (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    contacto_email_id BIGINT UNSIGNED NOT NULL,
    mautic_list_id INT NOT NULL,
    last_sync_at DATETIME NULL,
    UNIQUE KEY uq_lista_instancia (mautic_instancia_id, contacto_email_id),
    KEY idx_lista_instancia (mautic_instancia_id)
);

CREATE TABLE mautic_campania_map (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mautic_instancia_id INT NOT NULL,
    campania_id INT NOT NULL,
    mautic_campaign_id INT NOT NULL,
    last_sync_at DATETIME NULL,
    UNIQUE KEY uq_campania_instancia (mautic_instancia_id, mautic_campaign_id),
    KEY idx_campania_instancia (mautic_instancia_id)
);

CREATE TABLE campania_contacto_eventos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    campania_id INT NOT NULL,
    contacto_id BIGINT UNSIGNED NOT NULL,
    mautic_instancia_id INT NOT NULL,
    contacto_email_id BIGINT UNSIGNED NULL,
    open VARCHAR(3) NOT NULL DEFAULT 'No',
    clicks INT NOT NULL DEFAULT 0,
    email_subject VARCHAR(255) NULL,
    last_event_at DATETIME NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uq_evento_contacto (mautic_instancia_id, campania_id, contacto_id, contacto_email_id),
    KEY idx_evento_campania (campania_id),
    KEY idx_evento_contacto (contacto_id),
    KEY idx_evento_contacto_email (contacto_email_id)
);
