(function () {
  function $(id) { return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function () {
    var p = location.pathname.split('/');
    return p[1] ? ('/' + p[1] + '/') : '/';
  })();
  var ctrl = baseGuess + 'controller/provider_product/provider_product.php';
  var ctrlProducto = baseGuess + 'controller/producto/producto.php';
  var ctrlCategoria = baseGuess + 'controller/categoria/categoria.php';

  var modal = $('modalProviderProduct');
  var modalNuevoProd = $('modalNuevoProductoPP');

  // Estado del modal/oferta actual
  var ppMode = 'create'; // 'create' | 'edit'
  var currentProdmodelId = '';
  var providerDetailInitialValue = '';
  var providerDetailDirty = false;

  function openModal() { if (modal) { modal.classList.remove('hidden'); modal.classList.add('flex'); } }
  function closeModal() {
    if (modal) { modal.classList.add('hidden'); modal.classList.remove('flex'); }
    clearModal();
  }

  function openModalNuevoProd() {
    if (modalNuevoProd) { modalNuevoProd.classList.remove('hidden'); modalNuevoProd.classList.add('flex'); }
    clearNuevoProdModal();
    loadCategoriasNuevoProd();
  }
  function closeModalNuevoProd() {
    if (modalNuevoProd) { modalNuevoProd.classList.add('hidden'); modalNuevoProd.classList.remove('flex'); }
    clearNuevoProdModal();
  }

  function clearModal() {
    var ids = [
      'm_pp_idprovprod','m_pp_provider_id','m_pp_provider_sku','m_pp_status',
      'm_pp_lead_time_days','m_pp_provider_detail','m_pp_provider_specs',
      'm_pp_quote_date','m_pp_validity_days'
    ];
    ids.forEach(function (id) {
      var el = $(id);
      if (!el) return;
      if (el.type === 'checkbox') {
        el.checked = false;
      } else {
        el.value = '';
      }
    });
    if ($('m_pp_status')) $('m_pp_status').value = '1';
    resetPuRows();
    resetPtRows();
    var title = $('modalPpTitle'); if (title) title.textContent = 'Nueva producto de proveedor';

    // Reset de estado de control
    ppMode = 'create';
    currentProdmodelId = '';
    providerDetailInitialValue = '';
    providerDetailDirty = false;

    var searchInput = $('m_pp_prod_search');
    if (searchInput) searchInput.value = '';
    var suggBox = $('m_pp_prod_suggestions');
    if (suggBox) {
      suggBox.innerHTML = '';
      suggBox.classList.add('hidden');
    }
  }

  function clearNuevoProdModal() {
    ['pp_np_name_prod', 'pp_np_catg_id', 'pp_np_variant_name'].forEach(function (id) {
      var el = $(id); if (el) el.value = '';
    });
  }

  function fetchJson(url, options) {
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function (res) { return res.text(); })
      .then(function (text) {
        var t = text.replace(/^\uFEFF/, '');
        try { return JSON.parse(t); }
        catch (e) {
          var iObj = t.indexOf('{');
          var iArr = t.indexOf('[');
          var start = -1;
          if (iObj === -1 && iArr === -1) throw e;
          if (iObj === -1) start = iArr; else if (iArr === -1) start = iObj; else start = Math.min(iObj, iArr);
          var end = Math.max(t.lastIndexOf('}'), t.lastIndexOf(']'));
          if (start === -1 || end === -1 || end <= start) throw e;
          var sub = t.slice(start, end + 1);
          return JSON.parse(sub);
        }
      });
  }

  function parsePriceForList(json) {
    if (!json) return '';
    try {
      var o = JSON.parse(json);
      if (!o) return '';
      var items = Array.isArray(o) ? o : [o];
      var parts = items.map(function (p) {
        var seg = [];
        if (p.cantidad) seg.push('Cant: ' + p.cantidad);
        if (p.amount !== undefined && p.amount !== null && p.amount !== '') seg.push('Monto: ' + p.amount);
        if (p.igv_included) seg.push('c/IGV');
        return seg.join(' ');
      });
      return parts.join(' | ');
    } catch (e) { return ''; }
  }

  function formatDateFriendly(dateStr) {
    if (!dateStr) return '';
    var s = String(dateStr).trim();
    if (!s) return '';
    // Tomar solo la parte de fecha si viene con hora
    var onlyDate = s.split(' ')[0];
    var parts = onlyDate.split('-');
    if (parts.length !== 3) return s;
    var year = parts[0];
    var monthNum = parseInt(parts[1], 10);
    var dayNum = parseInt(parts[2], 10);
    if (!year || !monthNum || !dayNum) return s;
    var months = ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'];
    var monthLabel = months[monthNum - 1] || parts[1];
    return (dayNum < 10 ? '0' + dayNum : '' + dayNum) + ' ' + monthLabel + ' ' + year;
  }

  function buildProductoSuggestions(data) {
    var box = $('m_pp_prod_suggestions');
    var input = $('m_pp_prod_search');
    if (!box) return;
    box.innerHTML = '';
    var searchText = input ? (input.value || '').trim().toLowerCase() : '';
    if (!data || !data.length) {
      box.classList.add('hidden');
      return;
    }
    var filtered = data.filter(function (p) {
      var label = p.name_prod || '';
      if (p.variant_name) {
        label += ' - ' + p.variant_name;
      }
      if (!searchText) return true;
      return label.toLowerCase().indexOf(searchText) !== -1;
    });
    if (!filtered.length) {
      box.classList.add('hidden');
      return;
    }
    filtered.forEach(function (p) {
      var label = p.name_prod || '';
      if (p.variant_name) {
        label += ' - ' + p.variant_name;
      }
      var item = document.createElement('div');
      item.className = 'px-2 py-1 cursor-pointer hover:bg-gray-100';
      item.textContent = label;
      item.dataset.id = p.idprodmodel;
      item.addEventListener('click', function () {
        var sel = $('m_pp_prodmodel_id');
        if (!sel) return;
        var newVal = String(this.dataset.id || '');
        if (!newVal) return;
        sel.value = newVal;
        handleProductoSelectChange();
        if (input) {
          var opt = sel.options[sel.selectedIndex] || null;
          input.value = opt ? (opt.textContent || '') : '';
        }
        box.classList.add('hidden');
      });
      box.appendChild(item);
    });
    box.classList.remove('hidden');
  }

  function renderRows(rows) {
    var tbody = $('tbodyProviderProduct');
    if (!tbody) return;
    tbody.innerHTML = '';
    if (!rows || !rows.length) {
      var tr = document.createElement('tr');
      tr.innerHTML = '<td class="px-2 py-1 text-gray-500 text-xs" colspan="10">Sin datos</td>';
      tbody.appendChild(tr);
      return;
    }
    rows.forEach(function (r) {
      var fecha = formatDateFriendly(r.dateupdate || r.datecreate || '');
      var factulizacion = formatDateFriendly(r.quote_date || '');
      var validezText = (r.validity_days !== null && r.validity_days !== undefined && String(r.validity_days).trim() !== '')
        ? (String(r.validity_days).trim() + ' dias')
        : '';
      var pu = parsePriceForList(r.price_unit);
      var pt = parsePriceForList(r.price_total);

      var tr = document.createElement('tr');
      tr.innerHTML =
        '<td class="px-2 py-1 text-xs">' + (r.idprovprod || '') + '</td>' +
        '<td class="px-2 py-1 text-xs">' + (r.name_prod || '') + '</td>' +
        '<td class="px-2 py-1 text-xs">' + (r.variant_name || '') + '</td>' +
        '<td class="px-2 py-1 text-xs">' + (r.razon_social || r.razon_comercial || '') + '</td>' +
        '<td class="px-2 py-1 text-xs">' + pu + '</td>' +
        '<td class="px-2 py-1 text-xs">' + pt + '</td>' +
        '<td class="px-2 py-1 text-xs">' + (r.lead_time_days || '') + '</td>' +
        '<td class="px-2 py-1 text-xs">' + validezText + '</td>' +
        '<td class="px-2 py-1 text-xs">' + factulizacion + '</td>' +
        '<td class="px-2 py-1 text-xs">' + fecha + '</td>' +
        '<td class="px-2 py-1 text-xs">' +
          '<button class="btn-pp-edit text-xs text-blue-600 mr-2" data-id="' + (r.idprovprod || '') + '">Editar</button>' +
          '<button class="btn-pp-del text-xs text-red-600" data-id="' + (r.idprovprod || '') + '">Eliminar</button>' +
        '</td>';
      tbody.appendChild(tr);
    });
    bindRowActions();
  }

  function fetchList() {
    var q = ($('pp_q') && $('pp_q').value || '').trim();
    var params = new URLSearchParams({ action: 'list', q: q });
    fetchJson(ctrl + '?' + params.toString())
      .then(function (js) {
        if (!js || !js.success) { renderRows([]); return; }
        renderRows(js.data || []);
      })
      .catch(function (err) {
        console.error('Error cargando ofertas:', err);
        renderRows([]);
      });
  }

  function loadProveedores(selectedId) {
    var params = new URLSearchParams({ action: 'list_proveedores', q: '' });
    fetchJson(ctrl + '?' + params.toString())
      .then(function (js) {
        var sel = $('m_pp_provider_id');
        if (!sel) return;
        sel.innerHTML = '<option value="">Seleccione proveedor</option>';
        if (js && js.success && js.data) {
          js.data.forEach(function (p) {
            var opt = document.createElement('option');
            opt.value = p.idprovee;
            opt.textContent = (p.razon_social || p.razon_comercial || '') + ' (' + (p.ruc || '') + ')';
            sel.appendChild(opt);
          });
          if (selectedId) {
            sel.value = String(selectedId);
          }
        }
      })
      .catch(function (e) { console.error('Error cargando proveedores:', e); });
  }

  var productosCache = [];

  function loadProductos(selectedId, searchTerm) {
    var params = new URLSearchParams({ action: 'list_productos', q: (searchTerm || '') });
    fetchJson(ctrl + '?' + params.toString())
      .then(function (js) {
        var sel = $('m_pp_prodmodel_id');
        if (!sel) return;
        // Opción vacía solo para representar "sin producto seleccionado" a nivel interno.
        // El texto guía se muestra en el input (placeholder), no aquí.
        sel.innerHTML = '<option value=""></option>';
        if (js && js.success && js.data) {
          productosCache = js.data || [];
          productosCache.forEach(function (p) {
            var opt = document.createElement('option');
            opt.value = p.idprodmodel;
            var label = p.name_prod || '';
            if (p.variant_name) {
              label += ' - ' + p.variant_name;
            }
            opt.textContent = label;
            if (p.img) opt.dataset.img = p.img;
            if (p.detail) opt.dataset.detail = p.detail;
            if (p.categoria_nombre) opt.dataset.cat = p.categoria_nombre;
            sel.appendChild(opt);
          });
          if (selectedId) {
            sel.value = String(selectedId);
            currentProdmodelId = String(selectedId);
          } else {
            currentProdmodelId = sel.value || '';
          }
          // Al cargar productos solo queremos actualizar el preview,
          // sin sobreescribir el detalle del proveedor existente.
          updateProductoPreviewFromSelect(false);

          // Si la carga no viene desde el buscador, sincronizar texto del combobox,
          // pero sin desplegar la lista todavía.
          var searchInput = $('m_pp_prod_search');
          if (searchInput && typeof searchTerm === 'undefined' && sel.selectedIndex >= 0) {
            var optSel = sel.options[sel.selectedIndex];
            searchInput.value = optSel ? (optSel.textContent || '') : '';
          }

          // Solo mostrar sugerencias cuando la carga se origina desde una búsqueda
          if (typeof searchTerm !== 'undefined') {
            buildProductoSuggestions(productosCache);
          }
        }
      })
      .catch(function (e) { console.error('Error cargando productos:', e); });
  }

  function parseProductDetailPreview(raw) {
    if (!raw) return '';
    var text = '';
    var parsed = null;
    try { parsed = JSON.parse(raw); } catch (e) { parsed = null; }
    if (typeof parsed === 'string') {
      text = parsed;
    } else if (parsed && typeof parsed === 'object' && parsed.rows && Array.isArray(parsed.rows)) {
      var lines = [];
      if (parsed.title) lines.push(parsed.title);
      parsed.rows.forEach(function (r) {
        var line = '';
        if (r.label) {
          line += r.label;
          if (!r.label.endsWith(':')) {
            line += ':';
          }
        }
        if (r.value) {
          line += (line ? ' ' : '') + r.value;
        }
        if (line) {
          lines.push(line);
        }
      });
      text = lines.join(' | ');
    } else if (typeof raw === 'string') {
      text = raw;
    }
    return text.replace(/\s+/g, ' ').trim();
  }

  function parseProductDetailFull(raw) {
    if (!raw) return '';
    var text = '';
    var parsed = null;
    try { parsed = JSON.parse(raw); } catch (e) { parsed = null; }
    if (typeof parsed === 'string') {
      text = parsed;
    } else if (parsed && typeof parsed === 'object' && parsed.rows && Array.isArray(parsed.rows)) {
      var lines = [];
      if (parsed.title) lines.push(parsed.title);
      parsed.rows.forEach(function (r) {
        var line = '';
        if (r.label) {
          line += r.label;
          if (!r.label.endsWith(':')) {
            line += ':';
          }
        }
        if (r.value) {
          line += (line ? ' ' : '') + r.value;
        }
        if (line) {
          lines.push(line);
        }
      });
      text = lines.join('\n');
    } else if (typeof raw === 'string') {
      text = raw;
    }
    return (text || '').trim();
  }

  function updateProductoPreviewFromSelect(fillDetail) {
    if (typeof fillDetail === 'undefined') fillDetail = true;
    var sel = $('m_pp_prodmodel_id');
    var box = $('pp_prod_preview');
    if (!sel || !box) return;
    var opt = sel.options[sel.selectedIndex] || null;
    if (!opt || !opt.value) {
      box.classList.add('hidden');
      return;
    }
    var titleEl = $('pp_prod_preview_title');
    var catEl = $('pp_prod_preview_cat');
    var detailEl = $('pp_prod_preview_detail');
    var imgEl = $('pp_prod_preview_img');
    var noImgEl = $('pp_prod_preview_noimg');

    var nameText = opt.textContent || '';
    var catText = opt.dataset.cat || '';
    var detailRaw = opt.dataset.detail || '';
    var imgUrl = opt.dataset.img || '';

    var detailText = parseProductDetailPreview(detailRaw);
    if (detailText.length > 30) {
      detailText = detailText.slice(0, 37) + '...';
    }

    if (titleEl) titleEl.textContent = nameText;
    if (catEl) catEl.textContent = catText ? ('Categoría: ' + catText) : '';
    if (detailEl) detailEl.textContent = detailText;

    var detailField = $('m_pp_provider_detail');
    if (detailField && fillDetail) {
      var fullText = parseProductDetailFull(detailRaw);
      detailField.value = fullText;
      providerDetailInitialValue = fullText;
      providerDetailDirty = false;
    }

    if (imgEl) {
      if (imgUrl) {
        imgEl.src = imgUrl;
        imgEl.classList.remove('hidden');
        if (noImgEl) noImgEl.classList.add('hidden');
      } else {
        imgEl.src = '';
        imgEl.classList.add('hidden');
        if (noImgEl) noImgEl.classList.remove('hidden');
      }
    }
    box.classList.remove('hidden');
  }

  function handleProductoSelectChange() {
    var sel = $('m_pp_prodmodel_id');
    if (!sel) return;
    var newValue = sel.value || '';
    var oldValue = currentProdmodelId || '';
    if (newValue === oldValue) {
      updateProductoPreviewFromSelect(false);
      return;
    }

    var detailField = $('m_pp_provider_detail');
    var currentDetail = detailField ? (detailField.value || '').trim() : '';
    var needConfirm = false;

    if (ppMode === 'edit' && (providerDetailInitialValue || '').trim() !== '') {
      needConfirm = true;
    }
    if (providerDetailDirty && currentDetail !== '') {
      needConfirm = true;
    }

    var msg = '¿Estás seguro de cambiar la selección de producto? Se borrarán los datos anteriores del Detalle específico del proveedor.';

    if (needConfirm) {
      if (window.Swal) {
        Swal.fire({
          icon: 'warning',
          text: msg,
          showCancelButton: true,
          confirmButtonText: 'Sí, cambiar',
          cancelButtonText: 'Cancelar'
        }).then(function (r) {
          if (!r.isConfirmed) {
            sel.value = oldValue;
            updateProductoPreviewFromSelect(false);
            return;
          }
          currentProdmodelId = newValue;
          updateProductoPreviewFromSelect(true);
        });
      } else {
        if (!confirm(msg)) {
          sel.value = oldValue;
          updateProductoPreviewFromSelect(false);
          return;
        }
        currentProdmodelId = newValue;
        updateProductoPreviewFromSelect(true);
      }
    } else {
      currentProdmodelId = newValue;
      updateProductoPreviewFromSelect(true);
    }
  }

  function loadCategoriasNuevoProd() {
    var url = ctrlCategoria + '?action=list';
    fetchJson(url)
      .then(function (js) {
        var sel = $('pp_np_catg_id');
        if (!sel) return;
        sel.innerHTML = '<option value="">Seleccione categoria</option>';
        if (js && js.success && js.data) {
          js.data.forEach(function (c) {
            var opt = document.createElement('option');
            opt.value = c.idcat;
            opt.textContent = c.name_cat;
            sel.appendChild(opt);
          });
        }
      })
      .catch(function (e) { console.error('Error cargando categorias:', e); });
  }

  function tryParseJson(text) {
    if (!text) return null;
    try { return JSON.parse(text); }
    catch (e) { return null; }
  }

  function addPuRow(data) {
    var container = $('pu_rows');
    if (!container) return;
    var row = document.createElement('div');
    row.className = 'pu-row grid grid-cols-6 gap-2';
    row.innerHTML =
      '<div class="col-span-2">' +
        '<label class="text-[10px]">Cantidad</label>' +
        '<input class="pu-qty border px-2 py-1 w-full" placeholder="Ej. 20">' +
      '</div>' +
      '<div class="col-span-2">' +
        '<label class="text-[10px]">Monto</label>' +
        '<div class="flex items-center">' +
          '<span class="inline-flex items-center justify-center px-2 py-1 text-gray-500 bg-gray-100 border border-r-0 border-gray-300 select-none">S/</span>' +
          '<input class="pu-amount w-full px-2 py-1 text-gray-700 border border-gray-300 border-l-0 focus:outline-none focus:border-blue-500" placeholder="150.00">' +
        '</div>' +
      '</div>' +
      '<div class="col-span-1">' +
        '<div>' +
          '<label class="text-[10px] block">IGV incluido</label>' +
          '<input type="checkbox" class="pu-igv mt-2 w-4 h-4">' +
        '</div>' +
      '</div>'+
      '<button type="button" class="pu-remove text-[10px] text-red-600 ml-1 mb-1">✕</button>';
    container.appendChild(row);
    if (data) {
      var q = row.querySelector('.pu-qty');
      var a = row.querySelector('.pu-amount');
      var igv = row.querySelector('.pu-igv');
      if (q) q.value = data.cantidad || '';
      if (a) a.value = (data.amount != null ? data.amount : '');
      if (igv) igv.checked = !!data.igv_included;
    }
    var btn = row.querySelector('.pu-remove');
    if (btn) {
      btn.textContent = 'Eliminar';
      btn.className = 'pu-remove inline-flex items-center justify-center px-3 py-1 ml-1 mt-4 mb-2 rounded text-xs border border-red-300 bg-red-50 text-red-700 hover:bg-red-100';
      btn.addEventListener('click', function () {
        var container = $('pu_rows');
        if (container && container.children.length > 1) {
          container.removeChild(row);
        } else {
          var q = row.querySelector('.pu-qty'); if (q) q.value = '';
          var a = row.querySelector('.pu-amount'); if (a) a.value = '';
          var igv = row.querySelector('.pu-igv'); if (igv) igv.checked = false;
        }
      });
    }
  }

  function resetPuRows() {
    var container = $('pu_rows');
    if (!container) return;
    container.innerHTML = '';
    addPuRow();
  }

  function addPtRow(data) {
    var container = $('pt_rows');
    if (!container) return;
    var row = document.createElement('div');
    row.className = 'pt-row grid grid-cols-6 gap-2';
    row.innerHTML =
      '<div class="col-span-2">' +
        '<label class="text-[10px]">Cantidad</label>' +
        '<input class="pt-qty border px-2 py-1 w-full" placeholder="Ej. 100">' +
      '</div>' +
      '<div class="col-span-2">' +
        '<label class="text-[10px]">Monto</label>' +
        '<div class="flex items-center">' +
          '<span class="inline-flex items-center justify-center px-2 py-1 text-gray-500 bg-gray-100 border border-r-0 border-gray-300 select-none">S/</span>' +
          '<input class="pt-amount w-full px-2 py-1 text-gray-700 border border-gray-300 border-l-0 focus:outline-none focus:border-blue-500" placeholder="14000.00">' +
        '</div>' +
      '</div>' +
      '<div class="col-span-1">' +
        '<div>' +
          '<label class="text-[10px] block">IGV incluido</label>' +
          '<input type="checkbox" class="pt-igv mt-2 w-4 h-4">' +
        '</div>' +
      '</div>'+
      '<button type="button" class="pt-remove text-[10px] text-red-600 ml-1 mb-1">✕</button>';
    container.appendChild(row);
    if (data) {
      var q = row.querySelector('.pt-qty');
      var a = row.querySelector('.pt-amount');
      var igv = row.querySelector('.pt-igv');
      if (q) q.value = data.cantidad || '';
      if (a) a.value = (data.amount != null ? data.amount : '');
      if (igv) igv.checked = !!data.igv_included;
    }
    var btn = row.querySelector('.pt-remove');
    if (btn) {
      btn.textContent = 'Eliminar';
      btn.className = 'pt-remove inline-flex items-center justify-center px-3 py-1 ml-1 mt-4 mb-2 rounded text-xs border border-red-300 bg-red-50 text-red-700 hover:bg-red-100';
      btn.addEventListener('click', function () {
        var container = $('pt_rows');
        if (container && container.children.length > 1) {
          container.removeChild(row);
        } else {
          var q = row.querySelector('.pt-qty'); if (q) q.value = '';
          var a = row.querySelector('.pt-amount'); if (a) a.value = '';
          var igv = row.querySelector('.pt-igv'); if (igv) igv.checked = false;
        }
      });
    }
  }

  function resetPtRows() {
    var container = $('pt_rows');
    if (!container) return;
    container.innerHTML = '';
    addPtRow();
  }

  function openEdit(id) {
    if (!id) return;
    ppMode = 'edit';
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function (js) {
        if (!js || !js.success || !js.data) { return; }
        var d = js.data;
        clearModal();
        ppMode = 'edit';
        if ($('m_pp_idprovprod')) $('m_pp_idprovprod').value = d.idprovprod || '';
        if ($('m_pp_provider_sku')) $('m_pp_provider_sku').value = d.provider_sku || '';
        if ($('m_pp_status')) $('m_pp_status').value = String(d.status || '1');
        if ($('m_pp_lead_time_days')) $('m_pp_lead_time_days').value = d.lead_time_days || '';
        if ($('m_pp_quote_date')) $('m_pp_quote_date').value = d.quote_date || '';
        if ($('m_pp_validity_days')) $('m_pp_validity_days').value = d.validity_days || '';
        if ($('m_pp_provider_detail')) $('m_pp_provider_detail').value = d.provider_detail || '';
        if ($('m_pp_provider_specs')) $('m_pp_provider_specs').value = d.provider_specs || '';
        providerDetailInitialValue = d.provider_detail || '';
        providerDetailDirty = false;

        // Precio unitario
        var puData = [];
        var parsedPu = tryParseJson(d.price_unit);
        if (parsedPu) {
          if (Array.isArray(parsedPu)) puData = parsedPu;
          else puData = [parsedPu];
        }
        resetPuRows();
        if (puData.length) {
          var c1 = $('pu_rows');
          if (c1) c1.innerHTML = '';
          puData.forEach(function (p) { addPuRow(p || {}); });
        }

        // Precio total
        var ptData = [];
        var parsedPt = tryParseJson(d.price_total);
        if (parsedPt) {
          if (Array.isArray(parsedPt)) ptData = parsedPt;
          else ptData = [parsedPt];
        }
        resetPtRows();
        if (ptData.length) {
          var c2 = $('pt_rows');
          if (c2) c2.innerHTML = '';
          ptData.forEach(function (p) { addPtRow(p || {}); });
        }

        var title = $('modalPpTitle'); if (title) title.textContent = 'Editar oferta de proveedor';
        currentProdmodelId = String(d.prodmodel_id || '');
        loadProductos(d.prodmodel_id || '');
        loadProveedores(d.provider_id || '');
        openModal();
      });
  }

  function confirmDelete(id) {
    if (!id) return;
    if (!window.Swal) {
      if (!confirm('¿Desea eliminar esta oferta?')) return;
      doDelete(id);
      return;
    }
    Swal.fire({ icon: 'warning', title: 'Eliminar oferta', text: '¿Desea eliminar este registro?', showCancelButton: true, confirmButtonText: 'Sí, eliminar' })
      .then(function (r) { if (!r.isConfirmed) return; doDelete(id); });
  }

  function doDelete(id) {
    var fd = new FormData(); fd.append('id', id);
    fetchJson(ctrl + '?action=delete', { method: 'POST', body: fd })
      .then(function (js) {
        if (js && js.success) {
          if (window.Swal) {
            Swal.fire({ icon: 'success', title: 'Eliminado', timer: 1200, showConfirmButton: false });
          }
          fetchList();
        } else {
          var msg = (js && js.message) || 'No se pudo eliminar';
          if (window.Swal) { Swal.fire({ icon: 'error', text: msg }); } else { alert(msg); }
        }
      })
      .catch(function () {
        if (window.Swal) { Swal.fire({ icon: 'error', text: 'Error de red al eliminar' }); } else { alert('Error de red al eliminar'); }
      });
  }

  function buildOfferPayload() {
    var id = $('m_pp_idprovprod') ? $('m_pp_idprovprod').value : '';
    var prodId = $('m_pp_prodmodel_id') ? $('m_pp_prodmodel_id').value : '';
    var provId = $('m_pp_provider_id') ? $('m_pp_provider_id').value : '';
    if (!prodId) {
      if (window.Swal) { Swal.fire({ icon: 'warning', text: 'Debe seleccionar un producto.' }); } else { alert('Debe seleccionar un producto.'); }
      return null;
    }
    if (!provId) {
      if (window.Swal) { Swal.fire({ icon: 'warning', text: 'Debe seleccionar un proveedor.' }); } else { alert('Debe seleccionar un proveedor.'); }
      return null;
    }

    var payload = {
      prodmodel_id: parseInt(prodId, 10),
      provider_id: parseInt(provId, 10),
      provider_sku: ($('m_pp_provider_sku') && $('m_pp_provider_sku').value || '').trim(),
      status: $('m_pp_status') ? parseInt($('m_pp_status').value || '1', 10) : 1
    };

    // Precio unitario: array
    var puRows = document.querySelectorAll('#pu_rows .pu-row');
    var puArray = [];
    puRows.forEach(function (row) {
      var q = row.querySelector('.pu-qty');
      var a = row.querySelector('.pu-amount');
      var igv = row.querySelector('.pu-igv');
      var cantidad = q ? q.value.trim() : '';
      var amountText = a ? a.value.trim() : '';
      if (!cantidad && !amountText) return;
      puArray.push({
        cantidad: cantidad || null,
        amount: amountText ? parseFloat(amountText) : null,
        igv_included: igv ? !!igv.checked : false
      });
    });
    if (puArray.length) {
      payload.price_unit = puArray;
    }

    // Precio total: array
    var ptRows = document.querySelectorAll('#pt_rows .pt-row');
    var ptArray = [];
    ptRows.forEach(function (row) {
      var q = row.querySelector('.pt-qty');
      var a = row.querySelector('.pt-amount');
      var igv = row.querySelector('.pt-igv');
      var cantidad = q ? q.value.trim() : '';
      var amountText = a ? a.value.trim() : '';
      if (!cantidad && !amountText) return;
      ptArray.push({
        cantidad: cantidad || null,
        amount: amountText ? parseFloat(amountText) : null,
        igv_included: igv ? !!igv.checked : false
      });
    });
    if (ptArray.length) {
      payload.price_total = ptArray;
    }

    var lead = ($('m_pp_lead_time_days') && $('m_pp_lead_time_days').value || '').trim();
    if (lead) payload.lead_time_days = lead;

    var pdText = ($('m_pp_provider_detail') && $('m_pp_provider_detail').value || '').trim();
    if (pdText) payload.provider_detail = pdText;

    var psText = ($('m_pp_provider_specs') && $('m_pp_provider_specs').value || '').trim();
    if (psText) payload.provider_specs = psText;

    var qd = ($('m_pp_quote_date') && $('m_pp_quote_date').value || '').trim();
    if (qd) {
      var todayStr = (new Date()).toISOString().slice(0, 10);
      if (qd > todayStr) {
        var msgDate = 'La fecha de cotizacion no puede ser posterior a hoy.';
        if (window.Swal) { Swal.fire({ icon: 'warning', text: msgDate }); } else { alert(msgDate); }
        return null;
      }
      payload.quote_date = qd;
    }

    var vd = ($('m_pp_validity_days') && $('m_pp_validity_days').value || '').trim();
    if (vd) payload.validity_days = parseInt(vd, 10);

    if (id) {
      payload.id = parseInt(id, 10);
    }
    return payload;
  }

  function bindRowActions() {
    var edits = document.querySelectorAll('.btn-pp-edit');
    for (var i = 0; i < edits.length; i++) {
      edits[i].addEventListener('click', function () { openEdit(this.getAttribute('data-id')); });
    }
    var dels = document.querySelectorAll('.btn-pp-del');
    for (var j = 0; j < dels.length; j++) {
      dels[j].addEventListener('click', function () { confirmDelete(this.getAttribute('data-id')); });
    }
  }

  function bindEvents() {
    var bBuscar = $('btnPpBuscar'); if (bBuscar) { bBuscar.addEventListener('click', fetchList); }
    var inputQ = $('pp_q'); if (inputQ) {
      inputQ.addEventListener('keyup', function (e) { if (e.key === 'Enter') { fetchList(); } });
    }
    var bNuevo = $('btnPpNuevo'); if (bNuevo) {
      bNuevo.addEventListener('click', function () {
        clearModal();
        loadProductos();
        loadProveedores();
        openModal();
      });
    }
    var bClose = $('btnCloseModalPp'); if (bClose) { bClose.addEventListener('click', closeModal); }
    var bCancel = $('m_pp_cancelar'); if (bCancel) { bCancel.addEventListener('click', closeModal); }

    var btnNP = $('btnPpNuevoProducto'); if (btnNP) {
      btnNP.addEventListener('click', function () { openModalNuevoProd(); });
    }
    var btnNpc = $('pp_np_cancelar'); if (btnNpc) { btnNpc.addEventListener('click', closeModalNuevoProd); }
    var btnNpc2 = $('btnCloseModalNuevoProductoPP'); if (btnNpc2) { btnNpc2.addEventListener('click', closeModalNuevoProd); }

    var btnNps = $('pp_np_guardar'); if (btnNps) {
      btnNps.addEventListener('click', function () {
        var name = ($('pp_np_name_prod') && $('pp_np_name_prod').value || '').trim();
        var catg = $('pp_np_catg_id') ? $('pp_np_catg_id').value : '';
        var variant = ($('pp_np_variant_name') && $('pp_np_variant_name').value || '').trim();
        if (!name) {
          if (window.Swal) { Swal.fire({ icon: 'warning', text: 'El nombre del producto es obligatorio.' }); } else { alert('El nombre del producto es obligatorio.'); }
          return;
        }
        if (!catg) {
          if (window.Swal) { Swal.fire({ icon: 'warning', text: 'La categoria es obligatoria.' }); } else { alert('La categoria es obligatoria.'); }
          return;
        }
        var body = {
          name_prod: name,
          catg_id: parseInt(catg, 10),
          variant_name: variant,
          status: 1
        };
        fetchJson(ctrlProducto + '?action=create', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(body)
        })
          .then(function (js) {
            if (!js || !js.success) {
              var msg = (js && js.message) || 'No se pudo crear el producto';
              if (window.Swal) { Swal.fire({ icon: 'error', text: msg }); } else { alert(msg); }
              return;
            }
            var nuevoId = js.id;
            loadProductos(nuevoId);
            closeModalNuevoProd();
          })
          .catch(function (err) {
            console.error('Error al crear producto desde oferta:', err);
            if (window.Swal) { Swal.fire({ icon: 'error', text: 'Error de red al crear producto: ' + err.message }); } else { alert('Error de red al crear producto'); }
          });
      });
    }

    var btnAddPuRow = $('btnAddPuRow');
    if (btnAddPuRow) {
      btnAddPuRow.addEventListener('click', function () { addPuRow(); });
    }
    var btnAddPtRow = $('btnAddPtRow');
    if (btnAddPtRow) {
      btnAddPtRow.addEventListener('click', function () { addPtRow(); });
    }

    var selProd = $('m_pp_prodmodel_id');
    if (selProd) {
      currentProdmodelId = selProd.value || '';
      selProd.addEventListener('change', handleProductoSelectChange);
    }

    var prodSearch = $('m_pp_prod_search');
    if (prodSearch) {
      prodSearch.addEventListener('input', function () {
        var term = (this.value || '').trim();
        var currentSelected = $('m_pp_prodmodel_id') ? $('m_pp_prodmodel_id').value : '';
        loadProductos(currentSelected, term);
      });
      prodSearch.addEventListener('blur', function () {
        setTimeout(function () {
          var box = $('m_pp_prod_suggestions');
          if (box) box.classList.add('hidden');
        }, 200);
      });
      prodSearch.addEventListener('focus', function () {
        // Al enfocar, si no hay sugerencias construidas, construirlas
        // con el catálogo actual (productosCache) y el texto que haya.
        buildProductoSuggestions(productosCache);
        var box = $('m_pp_prod_suggestions');
        if (box && box.innerHTML.trim() !== '') {
          box.classList.remove('hidden');
        }
      });
    }

    var detailField = $('m_pp_provider_detail');
    if (detailField) {
      providerDetailInitialValue = detailField.value || '';
      providerDetailDirty = false;
      detailField.addEventListener('input', function () {
        var val = this.value || '';
        providerDetailDirty = (val !== providerDetailInitialValue);
      });
    }

    var bSave = $('m_pp_guardar'); if (bSave) {
      bSave.addEventListener('click', function () {
        var body = buildOfferPayload();
        if (!body) return;
        var isUpdate = !!body.id;
        var url = ctrl + '?action=' + (isUpdate ? 'update' : 'create');
        fetchJson(url, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(body)
        })
          .then(function (js) {
            if (!js || !js.success) {
              var msg = (js && js.message) || 'No se pudo guardar';
              if (window.Swal) { Swal.fire({ icon: 'error', text: msg }); } else { alert(msg); }
              return;
            }
            if (window.Swal) {
              Swal.fire({ icon: 'success', title: (isUpdate ? 'Actualizada' : 'Creada') + ' con exito', timer: 1500, showConfirmButton: false });
            }
            closeModal();
            fetchList();
          })
          .catch(function (err) {
            console.error('Error al guardar oferta:', err);
            if (window.Swal) { Swal.fire({ icon: 'error', text: 'Error de red al guardar: ' + err.message }); } else { alert('Error de red al guardar'); }
          });
      });
    }
  }

  document.addEventListener('DOMContentLoaded', function () {
    bindEvents();
    resetPuRows();
    resetPtRows();
    fetchList();
  });
})();
