// Observa cambios en la tabla de proveedores y aplica truncado con tooltip
(function(){
  var MAX_CHARS = 30;
  function apply(table){
    if(!table) return;
    var rows = table.querySelectorAll('tbody tr');
    rows.forEach(function(tr){
      // No truncar la fila de contactos expandida
      if (tr.classList && tr.classList.contains('contactos-row')) return;
      var cells = tr.querySelectorAll('td');
      if(!cells.length) return;
      var last = cells.length - 1; // omitir acciones
      cells.forEach(function(td, idx){
        if (td.classList && td.classList.contains('contactos-cell')) return;
        if(idx === last) return;
        if(td.dataset.truncated === '1') return;
        var full = (td.textContent||'').trim();
        if(full.length <= MAX_CHARS || full === '-') { td.dataset.truncated='1'; return; }
        var short = full.slice(0, MAX_CHARS) + '…';
        var span = document.createElement('span');
        span.className = 'cell-trunc';
        span.textContent = short;
        span.setAttribute('data-full', full);
        td.textContent = '';
        td.appendChild(span);
        td.dataset.truncated = '1';
      });
    });
  }

  function attachTooltip(root){
    root = root || document;
    var tooltip;
    function showTip(e){
      var t = e.target.closest('.cell-trunc');
      if(!t) return;
      var txt = t.getAttribute('data-full');
      if(!txt) return;
      tooltip = document.createElement('div');
      tooltip.className = 'tooltip-floating';
      tooltip.textContent = txt;
      document.body.appendChild(tooltip);
      var rect = t.getBoundingClientRect();
      var top = rect.bottom + 8;
      var left = rect.left + 6;
      var vw = window.innerWidth;
      var tw = tooltip.offsetWidth;
      // si se sale por la derecha, mover a la izquierda
      if (left + tw + 12 > vw) {
        left = Math.max(12, vw - tw - 12);
      }
      // posicionar flecha apuntando al centro del elemento
      var anchor = rect.left + rect.width / 2; // punto objetivo
      var arrowLeft = anchor - left; // relativo al tooltip
      // clamp para no salir de los bordes del tooltip
      arrowLeft = Math.max(8, Math.min(tw - 8, arrowLeft));
      tooltip.style.setProperty('--tip-left', arrowLeft + 'px');
      tooltip.style.top = top + 'px';
      tooltip.style.left = left + 'px';
    }
    function hideTip(){ if(tooltip && tooltip.parentNode){ tooltip.parentNode.removeChild(tooltip); tooltip=null; } }
    root.addEventListener('mouseenter', showTip, true);
    root.addEventListener('mouseleave', hideTip, true);
    window.addEventListener('scroll', hideTip, true);
    window.addEventListener('resize', hideTip, true);
  }

  function init(){
    var table = document.getElementById('tablaProveedores');
    if(!table) return;
    attachTooltip(table);
    // Primera aplicación
    apply(table);
    // Observar cambios en el tbody
    var tbody = table.tBodies && table.tBodies[0];
    if(!tbody) return;
    var obs = new MutationObserver(function(){ apply(table); });
    obs.observe(tbody, { childList: true, subtree: true });
  }

  if(document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();
