(function(){
  function $(id){ return document.getElementById(id); }
  function getPais(){
    var p = $('m_pais') && $('m_pais').value || '';
    return (p||'').toString().trim().toLowerCase();
  }
  function onlyDigits(str){ return (str||'').replace(/\D+/g,''); }
  function ensureHelper(afterEl, id){
    var el = document.getElementById(id);
    if(!el){
      el = document.createElement('div');
      el.id = id;
      el.className = 'helper-text hidden';
      afterEl.parentNode && afterEl.parentNode.appendChild(el);
    }
    return el;
  }
  function setError(input, helper, msg){
    if(!input) return false;
    if(msg){ input.classList.add('input-error'); helper && (helper.textContent = msg, helper.classList.remove('hidden')); }
    else { input.classList.remove('input-error'); helper && helper.classList.add('hidden'); }
    return !msg;
  }
  // Reglas
  function validateTelefono(val, pais){
    if(!val) return { ok:true };
    var digits = onlyDigits(val);
    var hasPlus = /\+/.test(val);
    // Rango general: 6 a 15 dígitos
    if(pais==='peru' || pais==='perú' || pais==='pe'){
      if(hasPlus) return { ok:false, msg:'Para Perú use solo números sin + (fijo 6 a 15 dígitos).' };
      if(digits.length < 6 || digits.length > 15) return { ok:false, msg:'El teléfono debe tener entre 6 y 15 dígitos.' };
      return { ok:true };
    }
    if(digits.length < 6 || digits.length > 15) return { ok:false, msg:'El teléfono debe tener entre 6 y 15 dígitos.' };
    return { ok:true };
  }
  function validateCelular(val, pais){
    if(!val) return { ok:true };
    var digits = onlyDigits(val);
    var hasPlus = /\+/.test(val);
    if(pais==='peru' || pais==='perú' || pais==='pe'){
      if(hasPlus) return { ok:false, msg:'Para Perú el celular no lleva +.' };
      if(digits.length!==9 || !/^9\d{8}$/.test(digits)) return { ok:false, msg:'Para Perú el celular debe tener 9 dígitos y empezar con 9.' };
      return { ok:true };
    }
    if(digits.length < 9 || digits.length > 15) return { ok:false, msg:'El celular debe tener entre 9 y 15 dígitos' };
    return { ok:true };
  }
  function sanitizeInput(input, allowPlus, allowPunct){
    if(!input) return;
    var val = input.value || '';
    var allowed = allowPunct ? /[\d\s\-()]/g : /[\d\s+]/g;
    var parts = val.match(allowed) || [];
    var s = parts.join('');
    if(!allowPlus){ s = s.replace(/\+/g,''); }
    else {
      // Solo permitir + al inicio
      s = s.replace(/\+/g,'');
      if(/^\s*\+/.test(val)) s = '+' + s;
    }
    if(s !== val) input.value = s;
  }

  function bindField(inputId, type){
    var input = $(inputId); if(!input) return;
    var helper = ensureHelper(input, inputId + '_msg');
    var ctrlKeys = ['Backspace','Delete','Tab','Escape','Enter','ArrowLeft','ArrowRight','Home','End'];
    input.addEventListener('keydown', function(e){
      if(ctrlKeys.indexOf(e.key) !== -1 || (e.ctrlKey||e.metaKey)) return; // permitir edición y atajos
      var pais = getPais();
      var allowPlus = (pais!=='peru' && pais!=='perú' && pais!=='pe');
      var allowPunct = (type==='telefono'); // guiones/() para fijo
      var pattern = allowPunct ? /[0-9\-()\s]/ : (allowPlus ? /[0-9\+\s]/ : /[0-9\s]/);
      // Si ya alcanzó el máximo de dígitos, bloquear más dígitos (los espacios no cuentan)
      var digitsNow = onlyDigits(input.value||'').length;
      var maxDigits = (type==='telefono') ? 15 : ( (pais==='peru'||pais==='perú'||pais==='pe') ? 9 : 15 );
      if(/\d/.test(e.key) && digitsNow >= maxDigits){
        e.preventDefault();
        setError(input, helper, 'Máximo ' + maxDigits + ' dígitos');
        return;
      }
      if(!pattern.test(e.key)){
        e.preventDefault();
        setError(input, helper, 'Solo se admiten números' + (allowPlus? ' y "+" al inicio' : '') + (allowPunct? ', guiones y paréntesis' : ''));
        return;
      }
    }, true);
    input.addEventListener('input', function(){
      var pais = getPais();
      var allowPlus = (pais!=='peru' && pais!=='perú' && pais!=='pe');
      var allowPunct = (type==='telefono');
      sanitizeInput(input, allowPlus, allowPunct);
      // Limitar por número de dígitos (no contar espacios ni signos)
      var maxDigits = (type==='telefono') ? 15 : ( (pais==='peru'||pais==='perú'||pais==='pe') ? 9 : 15 );
      var raw = input.value || '';
      var out = '';
      var count = 0;
      for (var i=0;i<raw.length;i++){
        var ch = raw.charAt(i);
        if(/\d/.test(ch)){
          if(count < maxDigits){ out += ch; count++; }
          // si excede, ignorar dígitos adicionales
        } else {
          // mantener espacios/paréntesis/guiones o "+" al inicio si está permitido
          if(allowPunct && /[\-()\s]/.test(ch)) out += ch;
          else if(allowPlus && ch==='+' && out.indexOf('+')===-1 && out.trim().length===0) out += ch;
          else if(/\s/.test(ch)) out += ch; // mantener espacios para legibilidad
          // ignorar otros caracteres
        }
      }
      if(out !== raw) input.value = out;
      var v = input.value || '';
      var res = (type==='telefono') ? validateTelefono(v, pais) : validateCelular(v, pais);
      setError(input, helper, res.ok? '' : res.msg);
    });
    input.addEventListener('blur', function(){
      var pais = getPais();
      var v = input.value || '';
      var res = (type==='telefono') ? validateTelefono(v, pais) : validateCelular(v, pais);
      setError(input, helper, res.ok? '' : res.msg);
    });
  }

  function blockSaveOnInvalid(){
    var saveBtn = $('m_guardar'); if(!saveBtn) return;
    saveBtn.addEventListener('click', function(e){
      var tel = $('m_telefono'), cel = $('m_celular');
      var pais = getPais();
      var ok = true, msg='';
      if(tel){ var r1 = validateTelefono(tel.value||'', pais); if(!r1.ok){ ok=false; msg=r1.msg; setError(tel, $(tel.id+'_msg')||ensureHelper(tel,tel.id+'_msg'), r1.msg); } }
      if(ok && cel){ var r2 = validateCelular(cel.value||'', pais); if(!r2.ok){ ok=false; msg=r2.msg; setError(cel, $(cel.id+'_msg')||ensureHelper(cel,cel.id+'_msg'), r2.msg); } }
      if(!ok){ e.stopImmediatePropagation(); e.preventDefault();
        if(window.Swal){ Swal.fire({icon:'error', title:'Dato inválido', text: msg}); }
        return false; }
    }, true);
  }

  function init(){
    bindField('m_telefono','telefono');
    bindField('m_celular','celular');
    // Email en vivo
    (function(){
      var input = $('m_email'); if(!input) return;
      var helper = ensureHelper(input, 'm_email_msg');
      function validateEmail(v){
        if(!v) return {ok:true};
        var s = (v||'').trim();
        var re = /^[^\s@]+@[^\s@]+\.[^\s@]{2,}$/i;
        return re.test(s) ? {ok:true} : {ok:false, msg:'El correo ingresado no es válido.'};
      }
      input.addEventListener('input', function(){
        var res = validateEmail(input.value||'');
        setError(input, helper, res.ok? '' : res.msg);
      });
      input.addEventListener('blur', function(){
        var res = validateEmail(input.value||'');
        setError(input, helper, res.ok? '' : res.msg);
      });
    })();
    // Reset de ayudas al cerrar modal
    var closeBtn = document.getElementById('btnCloseModal');
    var cancelBtn = document.getElementById('m_cancelar');
    function resetHelpers(){
      ['m_telefono','m_celular','m_email'].forEach(function(id){
        var el = $(id); var h = $(id+'_msg');
        if(el) el.classList.remove('input-error');
        if(h) h.classList.add('hidden');
      });
    }
    if(closeBtn) closeBtn.addEventListener('click', resetHelpers, true);
    if(cancelBtn) cancelBtn.addEventListener('click', resetHelpers, true);
    blockSaveOnInvalid();
  }
  if(document.readyState === 'loading') document.addEventListener('DOMContentLoaded', init); else init();
})();
