(function(){
  function $(id){ return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function(){ var p=location.pathname.split('/'); return p[1] ? ('/'+p[1]+'/') : '/'; })();
  var ctrl = baseGuess + 'controller/proveedor/proveedor.php';
  var contactoCtrl = baseGuess + 'controller/provee_contacto/contacto.php';
  var TAX_ID_TYPES = ['RUC','CUIT','VAT','TIN','NIT','NIF','OTRO'];
  var providersIndex = {};
  var expandedRow = null;
  var expandedProviderId = null;
  var contactsCache = {};

  function normalizeTaxIdType(value){
    var upper = (value || 'RUC').toString().trim().toUpperCase();
    return TAX_ID_TYPES.indexOf(upper) !== -1 ? upper : 'RUC';
  }
  function parseTaxId(raw){
    var stored = (raw || '').toString().trim();
    if(!stored){ return { type:'RUC', value:'' }; }
    var upperStored = stored.toUpperCase();
    for(var i=0;i<TAX_ID_TYPES.length;i++){
      var type = TAX_ID_TYPES[i];
      if(type === 'RUC') continue;
      var prefix = type + ' ';
      if(upperStored.indexOf(prefix) === 0){
        return { type:type, value: stored.slice(prefix.length) };
      }
    }
    return { type:'RUC', value: stored };
  }
  function composeTaxId(type, value){
    var cleanValue = (value || '').trim();
    if(!cleanValue){ return ''; }
    var normalizedType = normalizeTaxIdType(type);
    return normalizedType === 'RUC' ? cleanValue : (normalizedType + ' ' + cleanValue);
  }
  function formatTaxId(raw){
    var info = parseTaxId(raw);
    if(!info.value){ return ''; }
    return info.type && info.type !== 'RUC' ? (info.type + ' ' + info.value) : info.value;
  }
  function applyTaxIdTypeUI(type){
    var normalized = normalizeTaxIdType(type);
    var input = $('m_ruc');
    if(input){
      if(normalized === 'RUC'){
        input.placeholder = 'Ingresa el RUC (11 dígitos)';
      } else if (normalized === 'OTRO') {
        input.placeholder = 'Ingresa el identificador';
      } else {
        input.placeholder = 'Ingresa el identificador ' + normalized;
      }
    }
    var btn = $('m_buscar_ruc');
    if(btn){
      if(normalized === 'RUC'){
        btn.classList.remove('hidden');
      } else {
        btn.classList.add('hidden');
      }
    }
  }

  function escapeHtml(s){
    return String(s || '').replace(/[&<>"]/g, function(c){ return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'})[c] || c; });
  }
  function joinValues(val){
    if(Array.isArray(val)) return val.join(', ');
    if(typeof val === 'string'){
      try {
        var parsed = JSON.parse(val);
        if(Array.isArray(parsed)) return parsed.join(', ');
      } catch(_){}
      return val;
    }
    return '';
  }

  var currentPage = 1;
  var limit = 25;
  var totalPages = 1;
  var pageSizeEl = document.getElementById('pageSize');
  if (pageSizeEl) {
    var v = parseInt(pageSizeEl.value, 10);
    if (!isNaN(v) && v > 0) { limit = v; }
  }

  var totalEl = $('totalProveedores');
  var tbody = $('tbodyProveedores');
  var modal = $('modalNuevo');

  function openModal(){ if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); } }
  function closeModal(){
    // Al cerrar el modal, ocultarlo y resetear el formulario por completo
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
    try { clearModal(); } catch (e) { /* no bloquear si algo falla */ }
  }

  function clearModal(){
    var ids = [
      'm_ruc','m_razon_social','m_razon_comercial','m_email','m_telefono','m_celular',
      'm_rubro_sector','m_tipo_provee','m_calificacion','m_aniversario','m_pais','m_distrito','m_ciudad',
      'm_direccion','m_referencia','m_paginaweb','m_origen','m_condicion','m_estado',
      'perfil_resumen','perfil_respuesta','perfil_pago_tipo','perfil_pago_desc','perfil_cuenta','perfil_servicio','perfil_comentarios'
    ];
    for (var i=0;i<ids.length;i++){ var el=$(ids[i]); if(el) el.value=''; }
    var taxSelect = $('m_ruc_tipo'); if (taxSelect) taxSelect.value = 'RUC';
    applyTaxIdTypeUI('RUC');
  var save = $('m_guardar'); if (save) { save.removeAttribute('data-id'); save.classList.remove('hidden'); save.textContent = 'Guardar'; }
      // Limpiar contenedores dinamicos (catalogos, redes y perfil de productos)
      var c1 = $('catalogosContainer'); if (c1) c1.innerHTML = '';
      var c2 = $('redesContainer'); if (c2) c2.innerHTML = '';
      var c3 = $('perfilProductosContainer'); if (c3) c3.innerHTML = '';
      // Restaurar visibilidad de botones de agregar
      var btnAddCatalogo = $('btnAddCatalogo'); if (btnAddCatalogo) btnAddCatalogo.style.display = '';
      var btnAddRed = $('btnAddRed'); if (btnAddRed) btnAddRed.style.display = '';
      var btnAddPerfilProd = $('btnAddPerfilProd'); if (btnAddPerfilProd) btnAddPerfilProd.style.display = '';
      // Asegurar que todos los controles del modal queden habilitados nuevamente
      if (modal) {
        var controls = modal.querySelectorAll('input, textarea, select, button');
        Array.prototype.forEach.call(controls, function(ctrl){
          try { ctrl.disabled = false; } catch(e){}
          try { ctrl.readOnly = false; } catch(e){}
        });
        modal.classList.remove('modal-readonly');
      }
  }

  function fetchJson(url, options){
    // Permite pasar opciones (p.ej. method: 'POST', body: FormData)
    // y mantiene credentials: 'same-origin' por defecto
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function(res){ return res.text(); })
      .then(function(text){
        // El servidor en ocasiones puede inyectar texto/advertencias antes o despues
        // del JSON (warnings, espacios en blanco, cierres PHP, etc.). Intentamos
        // parsear directamente y, si falla, extraer la primera subcadena que parezca
        // JSON (desde el primer '{' o '[' hasta el ultimo '}' o ']').
        var t = text.replace(/^\uFEFF/, '');
        try {
          return JSON.parse(t);
        } catch (e) {
          console.warn('Respuesta no es JSON valido. Intentando extraer JSON de la respuesta...', e, t);
          // Buscar inicio de JSON
          var idxObj = t.indexOf('{');
          var idxArr = t.indexOf('[');
          var start = -1;
          if (idxObj === -1 && idxArr === -1) throw e;
          if (idxObj === -1) start = idxArr; else if (idxArr === -1) start = idxObj; else start = Math.min(idxObj, idxArr);
          var endBrace = t.lastIndexOf('}');
          var endBracket = t.lastIndexOf(']');
          var end = Math.max(endBrace, endBracket);
          if (start === -1 || end === -1 || end <= start) {
            console.error('No se pudo localizar una subcadena JSON valida en la respuesta.');
            throw e;
          }
          var sub = t.slice(start, end + 1);
          try {
            return JSON.parse(sub);
          } catch (e2) {
            console.error('Falla al parsear la subcadena JSON extraida:', e2, sub);
            throw e2;
          }
        }
      });
  }

  function activateTab(name){
    var g=$('tabGeneral'), p=$('tabPerfil'), bg=$('tabGeneralBtn'), bp=$('tabPerfilBtn');
    if(!g||!p||!bg||!bp) return;
    if(name==='perfil'){
      p.classList.remove('hidden'); g.classList.add('hidden');
      bp.classList.add('bg-primary','text-white'); bg.classList.remove('bg-primary','text-white'); bg.classList.add('bg-gray-200');
    } else {
      g.classList.remove('hidden'); p.classList.add('hidden');
      bg.classList.add('bg-primary','text-white'); bp.classList.remove('bg-primary','text-white'); bp.classList.add('bg-gray-200');
    }
  }

  function addCatalogoInput(val, readonly){
  var c = $("catalogosContainer"); if(!c) return;
  // Contenedor flex que simula un solo control compuesto (url + eliminar)
  var row = document.createElement('div'); row.className = 'flex items-stretch';
  // Input URL (crece)
  var inp = document.createElement('input');
  inp.type = 'text';
  inp.className = 'border border-gray-300 px-2 py-1 w-full rounded-l-md focus:outline-none';
  inp.placeholder = 'https://...';
  if(val) inp.value = val;
  inp.classList.add('-mr-px');
  if (readonly) { inp.readOnly = true; inp.disabled = true; }
  // Boton eliminar
  var del = document.createElement('button');
  del.type = 'button';
  del.className = 'px-3 bg-red-500 text-white hover:bg-red-600 rounded-r-md';
  del.innerHTML = '<i class="fas fa-times"></i>';
  del.className = 'inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0';
  del.title = 'Quitar';
  del.addEventListener('click', function(){ row.remove(); });
  // Aplicar modo readonly
  if (readonly) { del.style.display = 'none'; }
  row.appendChild(inp);
  if (!readonly) row.appendChild(del);
  c.appendChild(row);
}
  // Validacion de redes sociales antes de guardar
  function validarRedesSociales(){
    var c = $('redesContainer'); if(!c) return true;
    var rows = c.children;
    for(var i=0; i<rows.length; i++){
      var row = rows[i];
      if (row.getKeyValue) {
        var k = row.getKeyValue();
        var urlInputs = row.querySelectorAll('input[type="text"]');
        var v = (urlInputs && urlInputs.length > 0 ? (urlInputs[urlInputs.length-1].value||'').trim() : '');
        var select = row.querySelector('select');
        var selectValue = select ? select.value : '';
        // URL presente pero no se selecciona red
        if (selectValue === '' && v) {
          Swal.fire({icon:'error', title:'Error de validacion', text:'Debe seleccionar una red social para cada URL.'});
          return false;
        }
        // Otra red seleccionada pero sin nombre
        if (selectValue === '__otra__' && (!k || k==='')){
          Swal.fire({icon:'error', title:'Error de validacion', text:'Debe especificar el nombre de la red social en "Otra red".'});
          return false;
        }
        // Red seleccionada pero URL vacia
        if (selectValue !== '' && selectValue !== '__otra__' && (!v || v==='')){
          Swal.fire({icon:'error', title:'Error de validacion', text:'Debe ingresar la URL para la red social seleccionada.'});
          return false;
        }
        // Otra red con nombre pero sin URL
        if (selectValue === '__otra__' && k && (!v || v==='')){
          Swal.fire({icon:'error', title:'Error de validacion', text:'Debe ingresar la URL para la red social personalizada.'});
          return false;
        }
      } else {
        var a = row.querySelectorAll('input');
        if(a.length >= 2){ var kk=(a[0].value||'').trim(); var vv=(a[1].value||'').trim(); if((kk && !vv) || (!kk && vv)){ Swal.fire({icon:'error', title:'Error de validacion', text:'Cada red social debe tener clave y URL completas.'}); return false; } }
      }
    }
    return true;
  }
  // Redes sociales predefinidas para el select
  var redesSocialesPredefinidas = ['Facebook', 'Instagram', 'LinkedIn', 'Twitter/X', 'TikTok', 'YouTube', 'Telegram', 'WhatsApp', 'Snapchat', 'Pinterest', 'Twitch'];

  function addRedInput(k, v, readonly){
    var c = $('redesContainer'); if(!c) return;
    // Contenedor flex que simula un solo control compuesto (select/input clave + url + eliminar)
    var row = document.createElement('div'); row.className = 'flex items-stretch gap-0';
    
    // Contenedor para select o input clave
    var keyWrap = document.createElement('div'); keyWrap.className = 'flex-shrink-0 flex items-stretch';
    
    // Detectar si la clave es predefinida o personalizada
    var esOtra = k && redesSocialesPredefinidas.indexOf(k) === -1;
    
    // Select de redes predefinidas
    var select = document.createElement('select'); 
    select.className = 'border border-gray-300 px-2 py-1 rounded-l-md text-sm focus:outline-none';
    
    // Opcion por defecto (placeholder visual)
    var optDefault = document.createElement('option');
    optDefault.textContent = '- Elige -';
    optDefault.value = '';
    select.appendChild(optDefault);
    
    for (var i = 0; i < redesSocialesPredefinidas.length; i++) {
      var opt = document.createElement('option');
      opt.textContent = redesSocialesPredefinidas[i];
      opt.value = redesSocialesPredefinidas[i];
      if (k === redesSocialesPredefinidas[i]) opt.selected = true;
      select.appendChild(opt);
    }
    
    // Opcion "Otra red"
    var optOtra = document.createElement('option');
    optOtra.textContent = 'Otra red';
    optOtra.value = '__otra__';
    if (esOtra) optOtra.selected = true;
    select.appendChild(optOtra);
    
    // Input para "Otra red" (inicialmente oculto)
    var inputOtra = document.createElement('input');
    inputOtra.type = 'text';
    inputOtra.className = 'border border-l-0 border-gray-300 px-2 py-1 text-sm w-24 focus:outline-none';
    inputOtra.placeholder = 'red...';
    if (esOtra) inputOtra.value = k;
    inputOtra.style.display = esOtra ? '' : 'none';
    
    // Evento para mostrar/ocultar input personalizado
    select.addEventListener('change', function(){
      if (this.value === '__otra__') {
        inputOtra.style.display = '';
        inputOtra.focus();
      } else {
        inputOtra.style.display = 'none';
      }
    });
    
    // Funcion auxiliar: obtener la clave actual (select o input personalizado)
    row.getKeyValue = function(){
      if (select.value === '__otra__') return (inputOtra.value || '').trim();
      return select.value || '';
    };
    
    keyWrap.appendChild(select);
    keyWrap.appendChild(inputOtra);
    
    // Input URL (crece)
    var urlWrap = document.createElement('div'); 
    urlWrap.className = 'flex-1';
    var url = document.createElement('input'); 
    url.type = 'text'; 
    url.className = 'border border-l-0 border-gray-300 px-2 py-1 w-full focus:outline-none'; 
    url.placeholder = 'https://...'; 
    if(v) url.value = v;
    urlWrap.appendChild(url);
    
    // Boton eliminar
    var del = document.createElement('button'); 
    del.type = 'button'; 
    del.className = 'inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0';
    del.innerHTML = '<i class="fas fa-times"></i>';
    del.title = 'Quitar';
    del.addEventListener('click', function(){ row.remove(); });
    
    // Aplicar modo readonly
    if (readonly) {
      select.disabled = true;
      inputOtra.disabled = true;
      url.readOnly = true;
      url.disabled = true;
      del.style.display = 'none';
    }
    
    row.appendChild(keyWrap);
    row.appendChild(urlWrap);
    if (!readonly) row.appendChild(del);
    c.appendChild(row);
  }
  function readCatalogos(){
    var out=[]; var c=$('catalogosContainer'); if(!c) return out;
    var inputs=c.querySelectorAll('input[type="text"]');
    for(var i=0;i<inputs.length;i++){ var v=(inputs[i].value||'').trim(); if(v) out.push(v); }
    return out;
  }
  function readRedes(){
    var out={}; var c=$('redesContainer'); if(!c) return out;
    var rows=c.children; 
    for(var i=0;i<rows.length;i++){ 
      var row = rows[i];
      // Si la fila tiene el metodo getKeyValue, usarlo (select + input personalizado)
      if (row.getKeyValue) {
        var k = row.getKeyValue();
        var urlInputs = row.querySelectorAll('input[type="text"]');
        var v = (urlInputs && urlInputs.length > 0 ? (urlInputs[urlInputs.length-1].value||'').trim() : '');
        if(k && v){ out[k]=v; }
      } else {
        // Fallback para filas antiguas o sin getKeyValue
        var a=row.querySelectorAll('input'); 
        if(a.length>=2){ 
          var k=(a[0].value||'').trim(); 
          var v=(a[1].value||'').trim(); 
          if(k&&v){ out[k]=v; } 
        }
      }
    }
    return out;
  }
  function addPerfilProductoInput(val, readonly){
    var c=$('perfilProductosContainer'); if(!c) return;
    var row=document.createElement('div'); row.className='flex gap-2';
    var inp=document.createElement('input'); inp.type='text'; inp.className='border px-2 py-1 w-full'; if(val) inp.value=val;
    if (readonly) { inp.readOnly = true; inp.disabled = true; }
    var del=document.createElement('button'); del.type='button'; del.textContent='X'; del.className='px-2 bg-red-100 hover:bg-red-200 rounded'; del.addEventListener('click', function(){ row.remove(); });
    row.appendChild(inp);
    if (!readonly) row.appendChild(del);
    c.appendChild(row);
  }
  function readPerfilProductos(){
    var out=[]; var c=$('perfilProductosContainer'); if(!c) return out;
    var xs=c.querySelectorAll('input[type="text"]');
    for(var j=0;j<xs.length;j++){ var v=(xs[j].value||'').trim(); if(v) out.push(v); }
    return out;
  }

  function renderRows(rows){
    // Reiniciar expandido al re-renderizar
    if(expandedRow && expandedRow.parentNode){ expandedRow.parentNode.removeChild(expandedRow); }
    expandedRow = null;
    expandedProviderId = null;
    providersIndex = {};
    if(!rows || !rows.length){
      tbody.innerHTML = '<tr><td class="px-2 text-gray-500" colspan="13">Sin datos</td></tr>';
      return;
    }
    var html='';
    for(var i=0;i<rows.length;i++){
      var r=rows[i]||{};
      var provId = r.idprovee || '';
      providersIndex[provId] = r;
      var provName = r.razon_social || r.razon_comercial || formatTaxId(r.ruc) || ('Proveedor ' + provId);
   html += '<tr class="border-t hover:bg-gray-50 prov-row cursor-pointer" data-prov-id="'+provId+'" data-prov-name="'+escapeHtml(provName)+'">'
           +  '<td class="px-2 py-1 text-xs">'+(r.idprovee||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.user_fullname||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+formatTaxId(r.ruc)+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.razon_social||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.razon_comercial||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.email||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.telefono||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.celular||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.origen||'')+'</td>'
           +  '<td class="px-2 py-1 text-xs">'+(r.paginaweb||'')+'</td>'
     +  '<td class="px-2 py-1 text-xs">'+(r.direccion||'')+'</td>'
     +  '<td class="px-2 py-1 text-xs">'+(typeof r.dateupdate !== 'undefined' && r.dateupdate ? formatDateES(r.dateupdate) : (r.dateupdate||''))+'</td>'
           +  '<td class="px-2 py-1 text-xs">'
           +    '<button class="text-blue-600 hover:text-blue-800 btn-view" data-id="'+(r.idprovee||'')+'" title="Ver"><i class="fas fa-eye"></i></button> '
           +    '<button class="text-yellow-600 hover:text-yellow-800 btn-edit" data-id="'+(r.idprovee||'')+'" title="Editar"><i class="fas fa-pen"></i></button> '
           +    '<button class="text-red-600 hover:text-red-800 btn-del" data-id="'+(r.idprovee||'')+'" title="Eliminar"><i class="fas fa-trash"></i></button>'
           +  '</td>'
           + '</tr>';
    }
    tbody.innerHTML = html;
    bindRowActions();
  }
  window.renderRows = renderRows;

  // Formatea una fecha a español legible.
  // dateStr puede ser '2025-11-12 11:11:11' o ISO. short=false => '12 de noviembre de 2025'
  // short=true => '12 Nov 2025'
  function formatDateES(dateStr, short){
    if(!dateStr) return '';
    try{
      // Aceptar formatos comunes: 'YYYY-MM-DD HH:MM:SS' -> convertir espacio a 'T' para Date
      var s = (''+dateStr).trim();
      // Si termina con 'Z' o contiene 'T' assume ISO; else replace first space with 'T'
      if(s.indexOf('T') === -1 && s.indexOf('Z') === -1){ s = s.replace(' ', 'T'); }
      var d = new Date(s);
      if(isNaN(d.getTime())){
        // Intentar eliminar zonas y segundos si hay problemas
        var alt = (''+dateStr).replace(/\s+/g,' ').split(' ')[0]; // keep date part
        d = new Date(alt);
        if(isNaN(d.getTime())) return dateStr;
      }
      if(short){
        var fmtShort = new Intl.DateTimeFormat('es-ES',{ day:'2-digit', month:'short', year:'numeric' });
        return fmtShort.format(d).replace(/\./g,''); // quitar puntos de abreviatura si existen
      } else {
        // Ej: '12 de noviembre de 2025' (Intl incluye 'de' por las reglas de idioma)
        var fmt = new Intl.DateTimeFormat('es-ES',{ day:'2-digit', month:'long', year:'numeric' });
        return fmt.format(d);
      }
    }catch(e){ return dateStr; }
  }

  function updatePager(){
    var info=$('pageInfo'); var prev=$('btnPrev'); var next=$('btnNext');
    if(info){ info.textContent = 'Pagina ' + currentPage + ' de ' + Math.max(1,totalPages); }
    if(prev){ prev.disabled = currentPage<=1; }
    if(next){ next.disabled = currentPage>=totalPages; }
  }

  function fetchList(){
    var q = ($('q') && $('q').value || '').trim();
    var sel = document.getElementById('prov-search-by');    var by = (sel && sel.value || '').trim();
    var params = new URLSearchParams({ action:'list', q:q, by:by, limit: limit, page: currentPage });
    fetchJson(ctrl + '?' + params.toString())
      .then(function(js){
        try {
          if(!js || js.success !== true){ totalEl.textContent='Error'; renderRows([]); return; }
          totalPages = Math.max(1, Math.ceil((js.total||0)/limit));
          updatePager();
          totalEl.textContent = 'Total: ' + (js.total||0);
          renderRows(js.data || []);
        } catch(err){
          console.error('render error', err);
          totalEl.textContent='Error';
          renderRows([]);
        }
      })
      .catch(function(err){
        console.error('fetch error', err);
        totalEl.textContent='Error de red';
        renderRows([]);
      });
  }

  function bindRowActions(){
    var views = document.querySelectorAll('.btn-view');
    for(var i=0;i<views.length;i++) views[i].addEventListener('click', function(){ openView(this.getAttribute('data-id')); });
    var edits = document.querySelectorAll('.btn-edit');
    for(var j=0;j<edits.length;j++) edits[j].addEventListener('click', function(){ openEdit(this.getAttribute('data-id')); });
    var dels = document.querySelectorAll('.btn-del');
    for(var k=0;k<dels.length;k++) dels[k].addEventListener('click', function(){ confirmDelete(this.getAttribute('data-id')); });
    var provRows = document.querySelectorAll('tr.prov-row');
    for(var r=0;r<provRows.length;r++){
      provRows[r].addEventListener('click', onToggleContacts);
    }
  }
  window.bindRowActions = bindRowActions;

  function collapseContacts(){
    if(expandedRow && expandedRow.parentNode){ expandedRow.parentNode.removeChild(expandedRow); }
    expandedRow = null;
    expandedProviderId = null;
  }

  function ensureContactsStyles(){
    if(document.getElementById('contacts-row-style')) return;
    var style = document.createElement('style');
    style.id = 'contacts-row-style';
    style.textContent = '' +
      'tr.contactos-row td.contactos-cell{white-space: normal !important; overflow: visible !important; text-overflow: initial !important; padding:0; height:auto !important;}' +
      'tr.contactos-row td.contactos-cell *{white-space: normal !important; overflow: visible !important; text-overflow: initial !important;}' +
      'tr.contactos-row .contactos-card table td, tr.contactos-row .contactos-card table th{white-space: normal !important;}' +
      'tr.contactos-row .contactos-card{border:1px solid #e5e7eb; box-shadow:0 1px 3px rgba(0,0,0,0.08);}' +
      'tr.contactos-row .contactos-card table{width:100%; table-layout:auto; border-collapse:collapse;}' +
      'tr.contactos-row .contactos-card thead th{font-weight:600;}';
    document.head.appendChild(style);
  }

  function onToggleContacts(e){
    // No interferir con botones de accion
    if(e.target.closest('button')) return;
    var tr = e.currentTarget;
    var provId = tr.getAttribute('data-prov-id');
    if(!provId) return;
    if(expandedProviderId === provId){
      collapseContacts();
      return;
    }
    collapseContacts();
    expandedProviderId = provId;
    var prov = providersIndex[provId] || {};
    var name = prov.razon_social || prov.razon_comercial || formatTaxId(prov.ruc) || ('Proveedor ' + provId);
    var loading = document.createElement('tr');
    loading.className = 'contactos-row bg-gray-50';
    loading.innerHTML = '<td colspan="13" class="px-4 py-3 text-sm text-gray-500">Cargando contactos...</td>';
    tr.parentNode.insertBefore(loading, tr.nextSibling);
    expandedRow = loading;

    if(contactsCache[provId]){
      renderContactsBlock(name, contactsCache[provId]);
      return;
    }

    fetchJson(ctrl + '?action=list_contactos&provee_id=' + encodeURIComponent(provId))
      .then(function(js){
        if(expandedProviderId !== provId) return; // fue colapsado
        if(!js || js.success !== true){
          loading.innerHTML = '<td colspan="13" class="px-4 py-3 text-sm text-red-600">No se pudieron cargar los contactos.</td>';
          return;
        }
        var data = js.data || js.contactos || [];
        contactsCache[provId] = data;
        renderContactsBlock(name, data);
      })
      .catch(function(){
        if(expandedProviderId !== provId) return;
        loading.innerHTML = '<td colspan="13" class="px-4 py-3 text-sm text-red-600">Error al cargar contactos.</td>';
      });
  }

  function renderContactsBlock(name, rows){
    if(!expandedRow) return;
    ensureContactsStyles();
    var count = Array.isArray(rows) ? rows.length : 0;
    var html = '<td colspan="13" class="contactos-cell bg-gray-50 px-3 py-3" style="white-space: normal; overflow: visible;">';
    html += '<div class="contactos-card border border-gray-200 rounded-md bg-white" style="white-space: normal; overflow: visible;">';
    html += '<div class="flex items-center justify-between px-4 py-2 bg-gray-100 rounded-t-md">';
    html += '<div class="text-sm font-semibold text-gray-800">Contactos de ' + escapeHtml(name) + '</div>';
    html += '<span class="text-xs px-2 py-1 rounded-full bg-blue-600 text-white">'+count+'</span>';
    html += '</div>';
    if(!rows || !rows.length){
      html += '<div class="px-4 py-3 text-sm text-gray-500">Sin contactos registrados.</div>';
    } else {
      html += '<div class="overflow-x-auto">';
      html += '<table class="min-w-full text-xs" style="table-layout:auto; width:100%;">';
      html += '<thead class="bg-gray-800 text-white"><tr>'
           + '<th class="px-3 py-2 text-left" style="white-space: normal;">Nombre completo</th>'
           + '<th class="px-3 py-2 text-left" style="white-space: normal;">Cargo</th>'
           + '<th class="px-3 py-2 text-left" style="white-space: normal;">Celular</th>'
           + '<th class="px-3 py-2 text-left" style="white-space: normal;">Correo</th>'
           + '<th class="px-3 py-2 text-left" style="white-space: normal; width:120px;">Acciones</th>'
           + '</tr></thead>';
      html += '<tbody class="divide-y divide-gray-200">';
      rows.forEach(function(r){
        var nombre = (r.nombre || '') + (r.apellido ? ' ' + r.apellido : '');
        var cargo = r.cargo || '';
        var cel = joinValues(r.celular);
        var email = joinValues(r.email);
        html += '<tr>'
             + '<td class="px-3 py-2 text-sm text-blue-700" style="white-space: normal;">'+escapeHtml(nombre || '')+'</td>'
             + '<td class="px-3 py-2 text-sm text-gray-800" style="white-space: normal;">'+escapeHtml(cargo)+'</td>'
             + '<td class="px-3 py-2 text-sm text-gray-800" style="white-space: normal;">'+escapeHtml(cel)+'</td>'
             + '<td class="px-3 py-2 text-sm text-gray-800" style="white-space: normal;">'+escapeHtml(email)+'</td>'
             + '<td class="px-3 py-2 text-sm text-gray-800" style="white-space: normal;">'
             +   '<button class="text-blue-600 hover:text-blue-800 btn-contact-view" data-id="'+(r.idcont_provee||'')+'" title="Ver contacto"><i class="fas fa-eye"></i></button> '
             +   '<button class="text-yellow-600 hover:text-yellow-800 btn-contact-edit" data-id="'+(r.idcont_provee||'')+'" title="Editar contacto"><i class="fas fa-pen"></i></button>'
             + '</td>'
             + '</tr>';
      });
      html += '</tbody></table></div>';
    }
    html += '</div></td>';
    expandedRow.innerHTML = html;
    bindContactRowActions(expandedRow);
  }

  function bindContactRowActions(root){
    root = root || document;
    var views = root.querySelectorAll('.btn-contact-view');
    views.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        var id = this.getAttribute('data-id');
        if(!id) return;
        fetchJson(contactoCtrl + '?action=get&id=' + encodeURIComponent(id))
          .then(function(js){
            if(!js || !js.success){ Swal.fire({icon:'error', text:'No se pudo obtener el contacto'}); return; }
            var d = js.data || {};
            var nombre = (d.nombre||'') + (d.apellido ? ' ' + d.apellido : '');
            var cargo = d.cargo || '';
            var cel = joinValues(d.celular);
            var tel = joinValues(d.telefono);
            var email = joinValues(d.email);
            var empresa = d.empresa || '';
            var cumple = d.cumpleanios || '';
            var provName = (providersIndex[expandedProviderId] && (providersIndex[expandedProviderId].razon_social || providersIndex[expandedProviderId].razon_comercial)) || empresa || 'Proveedor';
            var html = '<div class="text-sm text-left space-y-2">'
                     + '<div><strong>Nombre:</strong> '+escapeHtml(nombre)+'</div>'
                     + '<div><strong>Empresa / Proveedor:</strong> '+escapeHtml(provName)+'</div>'
                     + '<div><strong>Cargo:</strong> '+escapeHtml(cargo)+'</div>'
                     + '<div><strong>Correo:</strong> '+escapeHtml(email)+'</div>'
                     + '<div><strong>Celular:</strong> '+escapeHtml(cel)+'</div>'
                     + '<div><strong>Teléfono:</strong> '+escapeHtml(tel)+'</div>'
                     + '<div><strong>Cumpleaños:</strong> '+escapeHtml(cumple)+'</div>'
                     + '</div>';
            Swal.fire({ title:'Ver contacto', html: html, confirmButtonText:'Cerrar' });
          })
          .catch(function(){ Swal.fire({icon:'error', text:'Error al cargar contacto'}); });
      });
    });
    var edits = root.querySelectorAll('.btn-contact-edit');
    edits.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        var id = this.getAttribute('data-id');
        if(!id) return;
        // Redirigir al módulo de contactos para editar con el ID
        window.location.href = baseGuess + 'view/provee_contacto/index.php?contacto_id=' + encodeURIComponent(id);
      });
    });
  }

  function openView(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){ if(!js || !js.success){ return; }
        setModal(js.data||{}, true);
        var titleEl = $('modalTitle'); if (titleEl) titleEl.textContent = 'Ver proveedor';
        // In view mode the save button is hidden by setModal; just open
        openModal();
      });
  }
  function openEdit(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){ if(!js || !js.success){ return; }
        setModal(js.data||{}, false);
        var titleEl = $('modalTitle'); if (titleEl) titleEl.textContent = 'Editar proveedor';
        // Ensure save button shows update label
        var saveBtn = $('m_guardar'); if (saveBtn) { saveBtn.textContent = 'Actualizar'; }
        openModal();
      });
  }
  function confirmDelete(id){
    if(!id) return;
    Swal.fire({ icon:'warning', title:'Eliminar proveedor', text:'¿Desea eliminar este registro?', showCancelButton:true, confirmButtonText:'Si, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDelete(id); });
  }
  function doDelete(id){
    var fd = new FormData(); fd.append('id', id);
    fetchJson(ctrl + '?action=delete', { method:'POST', body: fd })
      .then(function(js){
        if(js && js.success){
          Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false});
          (window.reloadProveedoresTable||fetchList)();
        } else {
          Swal.fire({icon:'error', text:(js&&js.message)||'No se pudo eliminar'});
        }
      })
      .catch(function(){ Swal.fire({icon:'error', text:'Error de red al eliminar'}); });
  }

  function setModal(data, readonly){
    var map = {
      m_razon_social:'razon_social', m_razon_comercial:'razon_comercial', m_email:'email', m_telefono:'telefono', m_celular:'celular',
      m_rubro_sector:'rubro_sector', m_tipo_provee:'tipo_provee', m_calificacion:'calificacion', m_aniversario:'aniversario', m_pais:'pais', m_distrito:'distrito', m_ciudad:'ciudad',
      m_direccion:'direccion', m_referencia:'Referencia', m_paginaweb:'paginaweb', m_origen:'origen', m_condicion:'condicion_contribuyente', m_estado:'estado_contribuyente'
    };
  for(var k in map){ if(map.hasOwnProperty(k)){ var el=$(k); if(el){ el.value = (data[map[k]]||''); el.readOnly = !!readonly; el.disabled = !!readonly; } } }
    var taxInfo = parseTaxId(data.ruc);
    var taxSelect = $('m_ruc_tipo'); if (taxSelect) { taxSelect.value = taxInfo.type || 'RUC'; taxSelect.disabled = !!readonly; }
    if($('m_ruc')) { $('m_ruc').value = taxInfo.value || ''; $('m_ruc').readOnly = !!readonly; }
    applyTaxIdTypeUI(taxInfo.type);
    var perfil = data.perfil; try{ if(typeof perfil==='string'){ perfil = JSON.parse(perfil); } }catch(e){ perfil=null; }
    if($('perfil_resumen')) $('perfil_resumen').value = (perfil&&perfil.resumen_del_perfil)||'';
    if($('perfil_respuesta')) $('perfil_respuesta').value = (perfil&&perfil.capacidad_de_respuesta)||'';
    if($('perfil_pago_tipo')) $('perfil_pago_tipo').value = (perfil&&perfil.politica_de_pago&&perfil.politica_de_pago.tipo_pago)||'';
    if($('perfil_pago_desc')) $('perfil_pago_desc').value = (perfil&&perfil.politica_de_pago&&perfil.politica_de_pago.descuentos)||'';
    if($('perfil_cuenta')) $('perfil_cuenta').value = (perfil&&perfil.numero_de_cuenta)||'';
    if($('perfil_servicio')) $('perfil_servicio').value = (perfil&&perfil.servicio)||'';
    if($('perfil_comentarios')) $('perfil_comentarios').value = (perfil&&perfil.comentarios_adicionales)||'';
    var cont=$('perfilProductosContainer'); if(cont) cont.innerHTML='';
    var prods = perfil && perfil.productos_que_maneja; if(typeof prods==='string'){ try{ prods = JSON.parse(prods);}catch(e){} }
    // Perfil - productos
    var contProd=$('perfilProductosContainer'); if(contProd) contProd.innerHTML='';
    if(Array.isArray(prods) && prods.length){ for(var i=0;i<prods.length;i++){ addPerfilProductoInput(prods[i], !!readonly); } } else { addPerfilProductoInput('', !!readonly); }
    // Catalogos
    var cat = data.catalogos;
    try{ if(typeof cat === 'string' && cat !== '') cat = JSON.parse(cat); } catch(e){ cat = []; }
    var catCont = $('catalogosContainer'); if(catCont) catCont.innerHTML='';
    if (Array.isArray(cat) && cat.length) { for (var ci=0; ci<cat.length; ci++) { addCatalogoInput(cat[ci], !!readonly); } }
    // Redes Sociales
    var redes = data.redes_sociales;
    try{ if(typeof redes === 'string' && redes !== '') redes = JSON.parse(redes); } catch(e){ redes = {}; }
    var redesCont = $('redesContainer'); if(redesCont) redesCont.innerHTML='';
    if (redes && typeof redes === 'object') { for (var rk in redes) { if (redes.hasOwnProperty(rk)) addRedInput(rk, redes[rk], !!readonly); } }
    // Mostrar / ocultar botones de agregar segen modo
    var btnAddCatalogo = $('btnAddCatalogo'); if (btnAddCatalogo) { btnAddCatalogo.style.display = !!readonly ? 'none' : ''; }
    var btnAddRed = $('btnAddRed'); if (btnAddRed) { btnAddRed.style.display = !!readonly ? 'none' : ''; }
    var btnAddPerfilProd = $('btnAddPerfilProd'); if (btnAddPerfilProd) { btnAddPerfilProd.style.display = !!readonly ? 'none' : ''; }
    var saveBtn = $('m_guardar'); if(saveBtn){ if(readonly){ saveBtn.classList.add('hidden'); } else { saveBtn.classList.remove('hidden'); saveBtn.setAttribute('data-id', data.idprovee||''); } }
    // Desactivar boton de buscar RUC en modo solo lectura
    var buscarRucEl = $('m_buscar_ruc'); if (buscarRucEl) buscarRucEl.style.display = !!readonly ? 'none' : '';

    // Si es modo lectura, forzamos que TODOS los controles del modal sean no editables
    if (modal) {
      var allowedButtons = ['btnCloseModal','m_cancelar','tabGeneralBtn','tabPerfilBtn'];
      var controls = modal.querySelectorAll('input, textarea, select, button');
      Array.prototype.forEach.call(controls, function(ctrl){
        // permitir botones de navegacion/close
        if (ctrl.id && allowedButtons.indexOf(ctrl.id) !== -1) return;
        if (readonly) {
          try { ctrl.disabled = true; } catch(e){}
          try { ctrl.readOnly = true; } catch(e){}
        } else {
          try { ctrl.disabled = false; } catch(e){}
          try { ctrl.readOnly = false; } catch(e){}
        }
      });
      if (readonly) modal.classList.add('modal-readonly'); else modal.classList.remove('modal-readonly');
    }

    activateTab('general');
  }

  function bindEvents(){
    var searchBtn = $('btnBuscar'); if(searchBtn){ searchBtn.addEventListener('click', function(){ currentPage=1; fetchList(); }); }
    var newBtn = $('btnNuevo'); if(newBtn){ newBtn.addEventListener('click', function(){
      clearModal(); activateTab('general');
      var titleEl = $('modalTitle'); if (titleEl) titleEl.textContent = 'Nuevo proveedor';
      var saveBtn = $('m_guardar'); if (saveBtn) { saveBtn.textContent = 'Guardar'; saveBtn.removeAttribute('data-id'); saveBtn.classList.remove('hidden'); }
      openModal();
    }); }
    var closeBtn = $('btnCloseModal'); if(closeBtn){ closeBtn.addEventListener('click', closeModal); }
    var cancelBtn = $('m_cancelar'); if(cancelBtn){ cancelBtn.addEventListener('click', closeModal); }
  // NO cerrar el modal al hacer clic en el backdrop. Solo cerrar mediante botones explicitos.
  if(modal){ modal.addEventListener('click', function(e){ /* no action */ }); }
    var ac=$('btnAddCatalogo'); if(ac){ ac.addEventListener('click', function(){ addCatalogoInput(''); }); }
    var ar=$('btnAddRed'); if(ar){ ar.addEventListener('click', function(){ addRedInput('',''); }); }
    var ap=$('btnAddPerfilProd'); if(ap){ ap.addEventListener('click', function(){ addPerfilProductoInput(''); }); }
    var tG=$('tabGeneralBtn'), tP=$('tabPerfilBtn'); if(tG&&tP){ tG.addEventListener('click', function(){ activateTab('general'); }); tP.addEventListener('click', function(){ activateTab('perfil'); }); }
    if(pageSizeEl){ pageSizeEl.addEventListener('change', function(){ var v=parseInt(this.value,10); if(!isNaN(v)&&v>0){ limit=v; currentPage=1; fetchList(); } }); }

    var taxTypeSelect = $('m_ruc_tipo');
    if(taxTypeSelect){
      taxTypeSelect.addEventListener('change', function(){ applyTaxIdTypeUI(this.value); });
      applyTaxIdTypeUI(taxTypeSelect.value || 'RUC');
    }

    var buscarRuc = $('m_buscar_ruc'); if(buscarRuc){
      buscarRuc.addEventListener('click', function(){
        var typeSel = $('m_ruc_tipo');
        var selectedType = normalizeTaxIdType(typeSel ? typeSel.value : 'RUC');
        if(selectedType !== 'RUC'){
          Swal.fire({icon:'info', text:'Este buscador solo esta disponible para RUC peruanos.'});
          return;
        }
        var ruc = ($('m_ruc') && $('m_ruc').value || '').trim(); if(!ruc){ Swal.fire({icon:'info', text:'Ingrese RUC'}); return; }
        var url = new URL(ctrl, window.location.origin); url.search = new URLSearchParams({ action:'search_ruc', ruc:ruc }).toString();
        fetchJson(url)
          .then(function(js){
            if(js && js.sunat){
              $('m_razon_social').value = js.sunat.razon_social || '';
              $('m_razon_comercial').value = js.sunat.razon_comercial || '';
              $('m_condicion').value = js.sunat.condicion_contribuyente || '';
              $('m_estado').value = js.sunat.estado_contribuyente || '';
            } else if(js && js.local){
              $('m_razon_social').value = js.local.razon_social || '';
              $('m_razon_comercial').value = js.local.razon_comercial || '';
            } else {
              Swal.fire({ icon:'info', text:'Integracion SUNAT no disponible en CRM. Sin resultados locales.' });
            }
          })
          .catch(function(){ Swal.fire({ icon:'error', text:'Error buscando RUC' }); });
      });
    }

    var saveBtn = $('m_guardar'); if(saveBtn){
      saveBtn.addEventListener('click', function(){
        var id = this.getAttribute('data-id');
        var taxTypeEl = $('m_ruc_tipo');
        var selectedTaxType = normalizeTaxIdType(taxTypeEl ? taxTypeEl.value : 'RUC');
        var taxValue = ($('m_ruc') && $('m_ruc').value || '').trim();
        var body = {
          ruc: composeTaxId(selectedTaxType, taxValue),
          razon_social: ($('m_razon_social').value||'').trim(),
          razon_comercial: ($('m_razon_comercial').value||'').trim(),
          rubro_sector: ($('m_rubro_sector') && $('m_rubro_sector').value || ''),
          tipo_provee: ($('m_tipo_provee') && $('m_tipo_provee').value || ''),
          calificacion: ($('m_calificacion') && $('m_calificacion').value || ''),
          telefono: ($('m_telefono').value||''),
          celular: ($('m_celular').value||''),
          email: ($('m_email').value||''),
          aniversario: ($('m_aniversario') && $('m_aniversario').value || ''),
          pais: ($('m_pais') && $('m_pais').value || ''),
          distrito: ($('m_distrito') && $('m_distrito').value || ''),
          ciudad: ($('m_ciudad') && $('m_ciudad').value || ''),
          direccion: ($('m_direccion') && $('m_direccion').value || ''),
          Referencia: ($('m_referencia') && $('m_referencia').value || ''),
          paginaweb: ($('m_paginaweb') && $('m_paginaweb').value || ''),
          origen: ($('m_origen') && $('m_origen').value || ''),
          condicion_contribuyente: ($('m_condicion') && $('m_condicion').value || ''),
          estado_contribuyente: ($('m_estado') && $('m_estado').value || '')
        };
        var perfilObj = {
          resumen_del_perfil: ($('perfil_resumen') && $('perfil_resumen').value || ''),
          capacidad_de_respuesta: ($('perfil_respuesta') && $('perfil_respuesta').value || ''),
          politica_de_pago: {
            tipo_pago: ($('perfil_pago_tipo') && $('perfil_pago_tipo').value || ''),
            descuentos: ($('perfil_pago_desc') && $('perfil_pago_desc').value || '')
          },
          numero_de_cuenta: ($('perfil_cuenta') && $('perfil_cuenta').value || ''),
          productos_que_maneja: readPerfilProductos(),
          servicio: ($('perfil_servicio') && $('perfil_servicio').value || ''),
          comentarios_adicionales: ($('perfil_comentarios') && $('perfil_comentarios').value || '')
        };
        body.perfil = JSON.stringify(perfilObj);
  body.catalogos = JSON.stringify(readCatalogos());
        body.redes_sociales = JSON.stringify(readRedes());
        body.tax_id_type = selectedTaxType;
        body.tax_id_value = taxValue;

  // Validar coherencia de redes sociales antes de continuar
  if (!validarRedesSociales()) { return; }

  if(!body.ruc){ Swal.fire({icon:'info', text:'El identificador fiscal es obligatorio'}); return; }
        if(!body.razon_social){ Swal.fire({icon:'info', text:'Razon Social es requerida'}); return; }
        var action = id ? 'update' : 'create'; if(id){ body.id = id; }
        fetch(ctrl+'?action='+action, { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(body), credentials:'same-origin' })
          .then(function(res){ 
            // Verificar si la respuesta HTTP es exitosa
            if (!res.ok) {
              console.error('HTTP error, status:', res.status, res.statusText);
              return res.text().then(function(text) {
                console.error('Response body:', text);
                throw new Error('HTTP ' + res.status + ': ' + res.statusText);
              });
            }
            return res.text();
          })
          .then(function(text){
            console.log('Response text:', text);
            // Parsear la respuesta con la logica robusta de fetchJson
            var js;
            try {
              js = JSON.parse(text);
            } catch (e) {
              console.warn('No es JSON valido. Intentando extraer JSON...', e);
              var idxObj = text.indexOf('{');
              var idxArr = text.indexOf('[');
              var start = -1;
              if (idxObj === -1 && idxArr === -1) throw e;
              if (idxObj === -1) start = idxArr; else if (idxArr === -1) start = idxObj; else start = Math.min(idxObj, idxArr);
              var endBrace = text.lastIndexOf('}');
              var endBracket = text.lastIndexOf(']');
              var end = Math.max(endBrace, endBracket);
              if (start === -1 || end === -1 || end <= start) {
                console.error('No se pudo extraer JSON valido');
                throw e;
              }
              var sub = text.slice(start, end + 1);
              js = JSON.parse(sub);
            }
            if(!js.success){ 
              Swal.fire({icon:'error', text: js.message || 'No se pudo guardar'}); 
              return; 
            } 
            Swal.fire({ icon:'success', title:(id?'Actualizado':'Creado')+' con exito', timer:1500, showConfirmButton:false }); 
            closeModal(); 
            (window.reloadProveedoresTable||fetchList)();
          })
          .catch(function(err){ 
            console.error('Error al guardar:', err);
            Swal.fire({ icon:'error', text:'Error de red al guardar: ' + err.message }); 
          });
      });
    }
  }

  document.addEventListener('DOMContentLoaded', function(){    
    var clearBtn = document.getElementById('btnClearSearch');    
    if(clearBtn){ clearBtn.addEventListener('click', 
      function(){ var qEl = document.getElementById('q'); 
        if(qEl){ qEl.value=''; qEl.focus(); } var sel = document.getElementById('prov-search-by'); if(sel){ sel.value='todos'; } 
        if(window.provPaginacion){ window.provPaginacion.setCurrentPage(1); 
          (window.reloadProveedoresTable||fetchList)(); } else { currentPage=1; fetchList(); } }); }
    bindEvents();
  });
})();
// ==== Integracion con paginacion unificada (como Clientes) ====
(function(){
  // Acceso dinámico a la paginación (puede inicializarse antes o después)
  var P = window.provPaginacion || null;
  function getP(){ return window.provPaginacion || null; }
  var pageSizeEl = document.getElementById('pageSize');
  // Helper local: fetch + parse JSON tolerante a BOM/ruido
  function fetchJsonSafe(url, options){
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function(res){ return res.text(); })
      .then(function(text){
        var t = text.replace(/^\uFEFF/, '');
        try { return JSON.parse(t); }
        catch(e){
          var iObj = t.indexOf('{');
          var iArr = t.indexOf('[');
          var start = -1;
          if (iObj === -1 && iArr === -1) throw e;
          if (iObj === -1) start = iArr; else if (iArr === -1) start = iObj; else start = Math.min(iObj, iArr);
          var end = Math.max(t.lastIndexOf('}'), t.lastIndexOf(']'));
          if (start === -1 || end === -1 || end <= start) throw e;
          var sub = t.slice(start, end + 1);
          return JSON.parse(sub);
        }
      });
  }
  // Render principal (trae y pinta la tabla)
  function renderTable(url){
    var P = getP(); if(!P) return;
    var q = (document.getElementById('q')?.value || '').trim();
    var byEl = document.getElementById('prov-search-by');    var by = (byEl && byEl.value || '').trim();
    var page = Number(P.currentPage || 1);
    var limit = Number(P.rowsPerPage || (pageSizeEl?.value || 25));
    if(pageSizeEl) pageSizeEl.value = String(limit);

    var ctrl = (typeof base !== 'undefined' ? base : '/') + 'controller/proveedor/proveedor.php';
    var params = new URLSearchParams({ action:'list', q:q, by:by, limit: String(limit), page: String(page) });
    fetchJsonSafe(ctrl + '?' + params.toString())
      .then(js => {
        var total = Number(js.total || 0);
        try { P.updatePaginationInfo(total); } catch(_){}
        try { P.renderPaginationControls(); } catch(_){}
        try { window.renderRows && window.renderRows(js.data || []); } catch(_){}
        try { var totalLbl = document.getElementById('totalProveedores'); if(totalLbl){ totalLbl.textContent = 'Total: ' + total; } } catch(_){ }
      })
      .catch(err => {
        console.error('Error cargando proveedores:', err);
        try { window.renderRows && window.renderRows([]); } catch(_){}
      });
  }
  // Exponer para otros flujos (guardar/editar)
  window.reloadProveedoresTable = function(){ renderTable(); };

  // Vincular controls
  if (pageSizeEl) {
    pageSizeEl.addEventListener('change', function(){
      var v = parseInt(this.value,10)||25;
      var P2 = getP();
      try { if(P2) P2.updateRowsPerPage(v); } catch(_){ if(P2){ P2.rowsPerPage=v; P2.currentPage=1; } renderTable(); }
    });
  }
  var btnBuscar = document.getElementById('btnBuscar');
  if(btnBuscar){ btnBuscar.addEventListener('click', function(){ var P3=getP(); if(P3){ P3.setCurrentPage(1); } renderTable(); }); }
  // Enter en campos de texto
  ['q'].forEach(function(id){ var el=document.getElementById(id); if(el){ el.addEventListener('keyup', function(e){ if(e.key==='Enter'){ var P4=getP(); if(P4){ P4.setCurrentPage(1); } renderTable(); } }); }});

  function init() {
    var P = getP(); // getP is window.provPaginacion
    if (P) {
        // The pagination object exists. Let's take over.
        P.renderFunction = renderTable;
        renderTable(); // Initial load
    } else {
        // Pagination object not ready, wait for the event.
        window.addEventListener('proveedores-paginacion-ready', function() {
            var Pnow = getP();
            if (Pnow) {
                Pnow.renderFunction = renderTable;
                renderTable();
            }
        }, { once: true }); // Use { once: true } to avoid multiple triggers
    }
  }

  init();
})();



