﻿(function(){
  function $(id){ return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function(){ var p=location.pathname.split('/'); return p[1] ? ('/'+p[1]+'/') : '/'; })();
  var ctrl = baseGuess + 'controller/provee_contacto/contacto.php';

  var currentPage = 1;
  var limit = 25;
  var totalPages = 1;
  var totalRecords = 0;
  var lastFilters = { q: '', campo: 'todos', provee_id: '' };
  var pageSizeEl = document.getElementById('pageSize');
  if (pageSizeEl) {
    var v = parseInt(pageSizeEl.value, 10);
    if (!isNaN(v) && v > 0) { limit = v; }
  }

  var totalEl = $('totalContactos');
  var tbody = $('tbodyContactos');
  var modal = $('modalNuevo');

  function openModal(){ if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); } }
  function closeModal(){
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
    try { clearModal(); } catch (e) { /* no bloquear */ }
  }

  function clearModal(){
    var ids = [
      'm_nombre','m_apellido','m_cargo','m_cumpleanios','m_origen'
    ];
    for (var i=0;i<ids.length;i++){ var el=$(ids[i]); if(el) el.value=''; }
    // Limpiar select de proveedores y combobox
    var searchInput = $('m_provee_search'); if (searchInput) searchInput.value = '';
    var cbInput = document.getElementById('__cb_input_m_provee_select'); if (cbInput) cbInput.value = '';
    var proveeIdHidden = $('m_provee_id'); if (proveeIdHidden) proveeIdHidden.value = '';
    var save = $('m_guardar'); if (save) { save.removeAttribute('data-id'); save.classList.remove('hidden'); save.textContent = 'Guardar'; }
    var c1 = $('emailContainer'); if (c1) c1.innerHTML = '';
    var c2 = $('telefonoContainer'); if (c2) c2.innerHTML = '';
    var c3 = $('celularContainer'); if (c3) c3.innerHTML = '';
    var btnAddEmail = $('btnAddEmail'); if (btnAddEmail) btnAddEmail.style.display = '';
    var btnAddTelefono = $('btnAddTelefono'); if (btnAddTelefono) btnAddTelefono.style.display = '';
    var btnAddCelular = $('btnAddCelular'); if (btnAddCelular) btnAddCelular.style.display = '';
    if (modal) {
      var controls = modal.querySelectorAll('input, textarea, select, button');
      Array.prototype.forEach.call(controls, function(ctrl){
        try { ctrl.disabled = false; } catch(e){}
        try { ctrl.readOnly = false; } catch(e){}
      });
      modal.classList.remove('modal-readonly');
    }
  }

  function fetchJson(url){
    return fetch(url, { credentials: 'same-origin' })
      .then(function(res){ return res.text(); })
      .then(function(text){
        var t = text.replace(/^\uFEFF/, '');
        try {
          return JSON.parse(t);
        } catch (e) {
          console.warn('Respuesta no es JSON valido. Intentando extraer JSON...', e, t);
          var idxObj = t.indexOf('{');
          var idxArr = t.indexOf('[');
          var start = -1;
          if (idxObj === -1 && idxArr === -1) throw e;
          if (idxObj === -1) start = idxArr; else if (idxArr === -1) start = idxObj; else start = Math.min(idxObj, idxArr);
          var endBrace = t.lastIndexOf('}');
          var endBracket = t.lastIndexOf(']');
          var end = Math.max(endBrace, endBracket);
          if (start === -1 || end === -1 || end <= start) {
            console.error('No se pudo localizar una subcadena JSON valida en la respuesta.');
            throw e;
          }
          var sub = t.slice(start, end + 1);
          try {
            return JSON.parse(sub);
          } catch (e2) {
            console.error('Fallo al parsear la subcadena JSON extraida:', e2, sub);
            throw e2;
          }
        }
      });
  }

  // Formatea una fecha a español legible
  function formatDateES(dateStr, short){
    if(!dateStr) return '';
    try{
      var s = (''+dateStr).trim();
      if(s.indexOf('T') === -1 && s.indexOf('Z') === -1){ s = s.replace(' ', 'T'); }
      var d = new Date(s);
      if(isNaN(d.getTime())){
        var alt = (''+dateStr).replace(/\s+/g,' ').split(' ')[0];
        d = new Date(alt);
        if(isNaN(d.getTime())) return dateStr;
      }
      if(short){
        var fmtShort = new Intl.DateTimeFormat('es-ES',{ day:'2-digit', month:'short', year:'numeric' });
        return fmtShort.format(d).replace(/\./g,'');
      } else {
        var fmt = new Intl.DateTimeFormat('es-ES',{ day:'2-digit', month:'long', year:'numeric' });
        return fmt.format(d);
      }
    }catch(e){ return dateStr; }
  }

  function validateEmail(email) {
    if (!email) return true; // Allow empty emails, but the save function will require at least one.
    var re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
  }

  function addEmailInput(val, readonly){
    var c = $("emailContainer"); if(!c) return;
    var row = document.createElement('div'); row.className = 'flex items-stretch';
    var inp = document.createElement('input');
    inp.type = 'email';
    inp.className = 'border border-gray-300 px-2 py-1 w-full rounded-l-md focus:outline-none';
    inp.placeholder = 'correo@ejemplo.com';
    if(val) inp.value = val;
    inp.classList.add('-mr-px');
    if (readonly) { inp.readOnly = true; inp.disabled = true; }

    inp.addEventListener('blur', function() {
      if (!validateEmail(this.value)) {
        this.classList.add('border-red-500');
      } else {
        this.classList.remove('border-red-500');
      }
    });

    var del = document.createElement('button');
    del.type = 'button';
    del.className = 'inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0';
    del.innerHTML = '<i class="fas fa-times"></i>';
    del.addEventListener('click', function(){ row.remove(); });
    if (readonly) { del.style.display = 'none'; }
    row.appendChild(inp);
    if (!readonly) row.appendChild(del);
    c.appendChild(row);
  }

  function addTelefonoInput(val, readonly){
    var c = $("telefonoContainer"); if(!c) return;
    var row = document.createElement('div'); row.className = 'flex items-stretch';
    var inp = document.createElement('input');
    inp.type = 'tel';
    inp.className = 'border border-gray-300 px-2 py-1 w-full rounded-l-md focus:outline-none';
    inp.placeholder = '+51 1 234567890';
    if(val) inp.value = val;
    inp.classList.add('-mr-px');
    if (readonly) { inp.readOnly = true; inp.disabled = true; }
    var del = document.createElement('button');
    del.type = 'button';
    //del.className = 'px-3 bg-red-500 text-white hover:bg-red-600 rounded-r-md'; original style
    del.className = 'inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0';
    del.innerHTML = '<i class="fas fa-times"></i>';
    del.addEventListener('click', function(){ row.remove(); });
    if (readonly) { 
      del.style.display = 'none'; }
    row.appendChild(inp);
    if (!readonly) row.appendChild(del);
    c.appendChild(row);
  }

  function addCelularInput(val, readonly){
    var c = $("celularContainer"); if(!c) return;
    var row = document.createElement('div'); row.className = 'flex items-stretch';
    var inp = document.createElement('input');
    inp.type = 'tel';
    inp.className = 'border border-gray-300 px-2 py-1 w-full rounded-l-md focus:outline-none';
    inp.placeholder = '+51 999999999';
    if(val) inp.value = val;
    inp.classList.add('-mr-px');
    if (readonly) { inp.readOnly = true; inp.disabled = true; }
    var del = document.createElement('button');
    del.type = 'button';
    del.className = 'inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0';
    del.innerHTML = '<i class="fas fa-times"></i>';
    del.addEventListener('click', function(){ row.remove(); });
    if (readonly) { del.style.display = 'none'; }
    row.appendChild(inp);
    if (!readonly) row.appendChild(del);
    c.appendChild(row);
  }

  function readEmails(){
    var out=[]; var c=$('emailContainer'); if(!c) return out;
    var inputs=c.querySelectorAll('input[type="email"]');
    for(var i=0;i<inputs.length;i++){ var v=(inputs[i].value||'').trim(); if(v) out.push(v); }
    return out;
  }

  function readTelefonos(){
    var out=[]; var c=$('telefonoContainer'); if(!c) return out;
    var inputs=c.querySelectorAll('input[type="tel"]');
    for(var i=0;i<inputs.length;i++){ var v=(inputs[i].value||'').trim(); if(v) out.push(v); }
    return out;
  }

  function readCelulares(){
    var out=[]; var c=$('celularContainer'); if(!c) return out;
    var inputs=c.querySelectorAll('input[type="tel"]');
    for(var i=0;i<inputs.length;i++){ var v=(inputs[i].value||'').trim(); if(v) out.push(v); }
    return out;
  }

  function renderRows(rows){
    if(!rows || !rows.length){
      var q = (lastFilters.q||'').trim();
      var campo = lastFilters.campo || 'todos';
      var proveeId = (lastFilters.provee_id||'').toString().trim();
      var msg = (q || (campo && campo !== 'todos') || (proveeId && proveeId !== '0'))
        ? 'No se encontraron coincidencias con la búsqueda'
        : 'Sin datos';
      tbody.innerHTML = '<tr><td class="px-2 py-2 text-gray-500 text-center text-xs" colspan="12">'+msg+'</td></tr>';
      return;
    }
    var html='';
    for(var i=0;i<rows.length;i++){
      var r=rows[i]||{};
      // Leer emails, telefonos, celulares como arrays
      var emails = r.email || []; if(typeof emails === 'string') { try{ emails = JSON.parse(emails); }catch(e){ emails = []; } }
      var telefonos = r.telefono || []; if(typeof telefonos === 'string') { try{ telefonos = JSON.parse(telefonos); }catch(e){ telefonos = []; } }
      var celulares = r.celular || []; if(typeof celulares === 'string') { try{ celulares = JSON.parse(celulares); }catch(e){ celulares = []; } }
      var emailStr = Array.isArray(emails) ? emails.join(', ') : (emails || '');
      var telStr = Array.isArray(telefonos) ? telefonos.join(', ') : (telefonos || '');
      var celStr = Array.isArray(celulares) ? celulares.join(', ') : (celulares || '');
      html += '<tr class="border-t">'
           +  '<td class="px-4 py-1 text-xs">'+(r.idcont_provee||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(r.user_fullname||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(r.empresa||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(r.nombre||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(r.apellido||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(r.cargo||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(emailStr||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(telStr||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(celStr||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(r.cumpleanios||'')+'</td>'
           +  '<td class="px-4 py-1 text-xs">'+(typeof r.dateupdate !== 'undefined' && r.dateupdate ? formatDateES(r.dateupdate) : (r.dateupdate||'â€”'))+'</td>'
           +  '<td class="px-4 py-1 text-xs">'
           +    '<button class="text-blue-600 hover:text-blue-800 btn-view" data-id="'+(r.idcont_provee||'')+'" title="Ver"><i class="fas fa-eye"></i></button> '
           +    '<button class="text-yellow-600 hover:text-yellow-800 btn-edit" data-id="'+(r.idcont_provee||'')+'" title="Editar"><i class="fas fa-pen"></i></button> '
           +    '<button class="text-red-600 hover:text-red-800 btn-del" data-id="'+(r.idcont_provee||'')+'" title="Eliminar"><i class="fas fa-trash"></i></button>'
           +  '</td>'
           + '</tr>';
    }
    tbody.innerHTML = html;
    bindRowActions();
  }

  function updatePager(){
    var info=$('pageInfo'); var prev=$('btnPrev'); var next=$('btnNext');
    if(info){ info.textContent = 'Pagina ' + currentPage + ' de ' + Math.max(1,totalPages); }
    if(prev){ prev.disabled = currentPage<=1; }
    if(next){ next.disabled = currentPage>=totalPages; }
  }

  function fetchList(){
    var q = ($('q') && $('q').value || '').trim();
    var provee_id = ($('provee_id') && $('provee_id').value || '').trim();
    var campo = ($('campoBusqueda') && $('campoBusqueda').value) || 'todos';
    lastFilters = { q: q, campo: campo, provee_id: provee_id };
    var params = new URLSearchParams({ action:'list', q:q, campo: campo, provee_id:provee_id, limit: limit, page: currentPage });
    fetchJson(ctrl + '?' + params.toString())
      .then(function(js){
        try {
          if(!js || js.success !== true){ totalEl.textContent='Error'; renderRows([]); return; }
          totalRecords = (js.total||0);
          totalPages = Math.max(1, Math.ceil(totalRecords/limit));
          totalEl.textContent = 'Total: ' + totalRecords;
          updatePager();
          renderRows(js.data || []);
        } catch(err){
          console.error('render error', err);
          totalEl.textContent='Error';
          renderRows([]);
        }
      })
      .catch(function(err){
        console.error('fetch error', err);
        totalEl.textContent='Error de red';
        renderRows([]);
      });
  }

  function loadContactById(cid){
    currentPage = 1;
    totalPages = 1;
    totalRecords = 0;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(cid))
      .then(function(js){
        if(!js || js.success !== true || !js.data){
          totalEl.textContent = 'Total: 0';
          renderRows([]);
          return;
        }
        totalRecords = 1;
        totalPages = 1;
        totalEl.textContent = 'Total: 1';
        lastFilters = { q: cid, campo: 'id', provee_id: '' };
        renderRows([js.data]);
        updatePager();
      })
      .catch(function(){
        totalEl.textContent = 'Error';
        renderRows([]);
      });
  }

  function bindRowActions(){
    var views = document.querySelectorAll('.btn-view');
    for(var i=0;i<views.length;i++) views[i].addEventListener('click', function(){ openView(this.getAttribute('data-id')); });
    var edits = document.querySelectorAll('.btn-edit');
    for(var j=0;j<edits.length;j++) edits[j].addEventListener('click', function(){ openEdit(this.getAttribute('data-id')); });
    var dels = document.querySelectorAll('.btn-del');
    for(var k=0;k<dels.length;k++) dels[k].addEventListener('click', function(){ confirmDelete(this.getAttribute('data-id')); });
  }

  function openView(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){ if(!js || !js.success){ return; }
        setModal(js.data||{}, true);
        var titleEl = $('modalTitle'); if (titleEl) titleEl.textContent = 'Ver Contacto';
        openModal();
      });
  }
  function openEdit(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){ if(!js || !js.success){ return; }
        setModal(js.data||{}, false);
        var titleEl = $('modalTitle'); if (titleEl) titleEl.textContent = 'Editar Contacto';
        var saveBtn = $('m_guardar'); if (saveBtn) { saveBtn.textContent = 'Actualizar'; }
        openModal();
      });
  }
  function confirmDelete(id){
    if(!id) return;
    Swal.fire({ icon:'warning', title:'Eliminar contacto', text:'Â¿Desea eliminar este registro?', showCancelButton:true, confirmButtonText:'Si, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDelete(id); });
  }
  function doDelete(id){
    var fd = new FormData(); fd.append('id', id);
    fetch(ctrl + '?action=delete', { method:'POST', body: fd, credentials:'same-origin' })
      .then(function(res){ return res.json(); })
      .then(function(js){ if(js && js.success){ Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false}); fetchList(); } else { Swal.fire({icon:'error', text:(js&&js.message)||'No se pudo eliminar'}); } })
      .catch(function(){ Swal.fire({icon:'error', text:'Error de red al eliminar'}); });
  }

  function setModal(data, readonly){
    $('m_nombre').value = (data.nombre||''); $('m_nombre').readOnly = !!readonly; $('m_nombre').disabled = !!readonly;
    $('m_apellido').value = (data.apellido||''); $('m_apellido').readOnly = !!readonly; $('m_apellido').disabled = !!readonly;
    $('m_cargo').value = (data.cargo||''); $('m_cargo').readOnly = !!readonly; $('m_cargo').disabled = !!readonly;
    $('m_cumpleanios').value = (data.cumpleanios||''); $('m_cumpleanios').readOnly = !!readonly; $('m_cumpleanios').disabled = !!readonly;
    $('m_origen').value = (data.origen||''); $('m_origen').readOnly = !!readonly; $('m_origen').disabled = !!readonly;
    // Cargar proveedor en el select inteligente
    if (data.provee_id) {
      $('m_provee_id').value = data.provee_id;
      // Intentar obtener la info del proveedor desde el <select> (poblado por initSearchableSelect)
      try {
        var sel = $('m_provee_select');
        var opt = sel ? sel.querySelector('option[value="' + data.provee_id + '"]') : null;
        if (opt) {
          var name = opt.textContent || opt.innerText || '';
          $('selectedProveerName').textContent = name;
          $('selectedProveedorId').textContent = data.provee_id;
          $('selectedProveedorRuc').textContent = opt.getAttribute('data-ruc') || '';
          // *** FIX: Asegurar que el <select> subyacente tambien tenga el valor correcto
          sel.value = data.provee_id;
          // Actualizar combobox input (no mostrar tarjeta)
          var cbInputEl = document.getElementById('__cb_input_m_provee_select'); if(cbInputEl) cbInputEl.value = name;
        } else {
          // Si no existe en el select, pedirlo al backend
          fetchJson(baseGuess + 'controller/proveedor/proveedor.php?action=get&id=' + encodeURIComponent(data.provee_id))
            .then(function(js){
              if(js && js.success && js.data){
                var p = js.data;
                var name = p.razon_social || p.razon_comercial || '';
                $('selectedProveerName').textContent = name;
                $('selectedProveedorId').textContent = p.idprovee || data.provee_id;
                $('selectedProveedorRuc').textContent = p.ruc || '';
                // No mostrar la tarjeta (el input refleja la seleccion)
                // Asegurar que el <select> tenga la opcion (solo la etiqueta, sin detalles)
                try {
                  var sel2 = $('m_provee_select');
                  if (sel2 && !sel2.querySelector('option[value="' + p.idprovee + '"]')) {
                    var opt2 = document.createElement('option');
                    opt2.value = p.idprovee;
                    opt2.textContent = name; // SOLO etiqueta
                    opt2.setAttribute('data-ruc', p.ruc || '');
                    if (sel2.options.length > 1) sel2.insertBefore(opt2, sel2.options[1]); else sel2.appendChild(opt2);
                    sel2.value = p.idprovee;
                  }
                  var cbInputEl = document.getElementById('__cb_input_m_provee_select'); if(cbInputEl) cbInputEl.value = name;
                } catch(e){ /* ignore */ }
              }
            })
            .catch(function(err){ console.warn('No se pudo obtener proveedor para mostrar en modal:', err); });
        }
      } catch(e){ console.warn('Error al intentar cargar proveedor en modal', e); }
    }
    // Deshabilitar busqueda en modo readonly
    var searchInput = $('m_provee_search');
    if (searchInput) {
      searchInput.readOnly = !!readonly;
      searchInput.disabled = !!readonly;
    }

    // Emails
    var emails = data.email; if(typeof emails === 'string'){ try{ emails = JSON.parse(emails); }catch(e){ emails = []; } }
    var emailCont = $('emailContainer'); if(emailCont) emailCont.innerHTML='';
    if(Array.isArray(emails) && emails.length){ for(var ei=0; ei<emails.length; ei++){ addEmailInput(emails[ei], !!readonly); } } else { addEmailInput('', !!readonly); }

    // Telefonos
    var telefono = data.telefono; if(typeof telefono === 'string'){ try{ telefono = JSON.parse(telefono); }catch(e){ telefono = []; } }
    var telCont = $('telefonoContainer'); if(telCont) telCont.innerHTML='';
    if(Array.isArray(telefono) && telefono.length){ for(var ti=0; ti<telefono.length; ti++){ addTelefonoInput(telefono[ti], !!readonly); } }

    // Celulares
    var celular = data.celular; if(typeof celular === 'string'){ try{ celular = JSON.parse(celular); }catch(e){ celular = []; } }
    var celCont = $('celularContainer'); if(celCont) celCont.innerHTML='';
    if(Array.isArray(celular) && celular.length){ for(var ci=0; ci<celular.length; ci++){ addCelularInput(celular[ci], !!readonly); } }

    // Mostrar / ocultar botones de agregar
    var btnAddEmail = $('btnAddEmail'); if (btnAddEmail) { btnAddEmail.style.display = !!readonly ? 'none' : ''; }
    var btnAddTelefono = $('btnAddTelefono'); if (btnAddTelefono) { btnAddTelefono.style.display = !!readonly ? 'none' : ''; }
    var btnAddCelular = $('btnAddCelular'); if (btnAddCelular) { btnAddCelular.style.display = !!readonly ? 'none' : ''; }

    var saveBtn = $('m_guardar'); if(saveBtn){ if(readonly){ saveBtn.classList.add('hidden'); } else { saveBtn.classList.remove('hidden'); saveBtn.setAttribute('data-id', data.idcont_provee||''); } }

    if (modal) {
      var allowedButtons = ['btnCloseModal','m_cancelar'];
      var controls = modal.querySelectorAll('input, textarea, select, button');
      Array.prototype.forEach.call(controls, function(ctrl){
        if (ctrl.id && allowedButtons.indexOf(ctrl.id) !== -1) return;
        if (readonly) {
          try { ctrl.disabled = true; } catch(e){}
          try { ctrl.readOnly = true; } catch(e){}
        } else {
          try { ctrl.disabled = false; } catch(e){}
          try { ctrl.readOnly = false; } catch(e){}
        }
      });
      if (readonly) modal.classList.add('modal-readonly'); else modal.classList.remove('modal-readonly');
    }
  }

  // Select inteligente para proveedores
  // Transformar un <select> en un combobox searchable (similar al ejemplo que me pasaste)
  function initSearchableSelect(selectId, containerId){
    var select = $(selectId);
    var container = $(containerId);
    var ctrlProveedor = baseGuess + 'controller/proveedor/proveedor.php';
    if(!select || !container) return;

    // Construir la UI del combobox
    container.innerHTML = `
      <div class="relative">
        <input type="text" aria-autocomplete="list" aria-expanded="false" id="__cb_input_${selectId}"
               class="w-full rounded-md border border-gray-300 px-3 py-2 pr-9 shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
               placeholder="Escribe para filtrar..." />
        <button type="button" aria-label="Abrir" class="absolute inset-y-0 right-0 flex items-center pr-2 text-gray-500">
        </button>
        <ul class="absolute z-50 mt-1 max-h-56 w-full overflow-auto rounded-md border border-gray-200 bg-white shadow-lg hidden" id="__cb_list_${selectId}"></ul>
      </div>
      <p class="mt-1 text-xs text-gray-500">Usa â†‘/â†“ para navegar y Enter para seleccionar.</p>
    `;

    var input = document.getElementById('__cb_input_' + selectId);
    var button = container.querySelector('button');
    var list = document.getElementById('__cb_list_' + selectId);

    // --- Variables para restaurar valor en blur ---
    var previousValue = '';
    var previousLabel = '';
    // ---------------------------------------------

    // Cargar opciones iniciales desde backend (hasta 100)
    var options = [];
    function loadOptions(){
      fetchJson(ctrlProveedor + '?action=list_simple')
        .then(function(js){
          options = Array.isArray(js.data) ? js.data.map(function(r){ return { value: String(r.idprovee), label: (r.razon_social || r.razon_comercial || ''), ruc: r.ruc || '', razon_social: r.razon_social || '', razon_comercial: r.razon_comercial || '' }; }) : [];
          // Poblar select original (incluyendo data-ruc para lookup rapido)
          select.innerHTML = '<option value="">â€” Selecciona â€”</option>' + options.map(function(o){ return '<option value="'+o.value+'" data-ruc="'+escapeHtml(o.ruc || '')+'">'+escapeHtml(o.label)+'</option>'; }).join('');
          filter(input.value || '');
          renderList();
        })
        .catch(function(err){
          console.error('Error cargando proveedores:', err);
        });
    }

    // Exponer API para refrescar/agregar opciones desde fuera (sin recargar pagina)
    function addOptionExternal(item){
      if(!item) return;
      var id = String(item.id || item.value || '');
      if(!id) return;
      var label = item.label || item.razon_social || item.razon_comercial || item.ruc || id;
      var ruc = item.ruc || '';
      var exists = options.some(function(o){ return o.value === id; });
      if(!exists){ options.unshift({ value: id, label: label, ruc: ruc, razon_social: item.razon_social || '' }); }
      var existingOpt = select ? select.querySelector('option[value="' + id + '"]') : null;
      if(!existingOpt && select){
        var opt = document.createElement('option');
        opt.value = id; opt.textContent = label; opt.setAttribute('data-ruc', ruc);
        if(select.options.length>1){ select.insertBefore(opt, select.options[1]); } else { select.appendChild(opt); }
      }
      filter(input.value || '');
      renderList();
    }
    window.__proveeSelects = window.__proveeSelects || {};
    window.__proveeSelects[selectId] = { reload: loadOptions, add: addOptionExternal };

    var filtered = [];
    var activeIndex = -1;

    function renderList(){
      list.innerHTML = filtered.map(function(o, idx){
        return '<li data-idx="'+idx+'" class="cursor-pointer px-3 py-2 hover:bg-blue-50 '+(idx===activeIndex?'bg-blue-100':'')+'">'
               + '<div class="font-semibold text-gray-900">'+escapeHtml(o.label)+'</div>'
               + '<div class="text-xs text-gray-600">ID: '+escapeHtml(o.value)+' | RUC: '+escapeHtml(o.ruc || '-')+'</div>'
               + '</li>';
      }).join('');
    }

    function openList(){ if(filtered.length===0) return; list.classList.remove('hidden'); input.setAttribute('aria-expanded','true'); }
    function closeList(){ list.classList.add('hidden'); input.setAttribute('aria-expanded','false'); activeIndex=-1; highlight(); }
    function highlight(){ Array.from(list.children).forEach(function(li,i){ li.classList.toggle('bg-blue-100', i===activeIndex); }); }

    function filter(v){ var q=(v||'').toLowerCase().trim(); filtered = options.filter(function(o){ return o.label.toLowerCase().includes(q) || (o.ruc||'').toLowerCase().includes(q) || (o.razon_social||'').toLowerCase().includes(q); }); activeIndex=-1; renderList(); }

    function selectItem(item){
      // Actualiza select real y hidden
      var existingOpt = select ? select.querySelector('option[value="' + item.value + '"]') : null;
      if (!existingOpt && select) {
        // Insertar la opcion justo despues del placeholder para que no quede "al pie"
        var opt = document.createElement('option');
        opt.value = item.value;
        opt.textContent = item.label || item.razon_social || item.razon_comercial || item.value;
        opt.setAttribute('data-ruc', item.ruc || '');
        if (select.options.length > 1) {
          select.insertBefore(opt, select.options[1]);
        } else {
          select.appendChild(opt);
        }
        existingOpt = opt;
      }
      if (existingOpt) {
        existingOpt.selected = true;
      }
      if (select) select.value = item.value;
      var hid = $('m_provee_id'); if(hid) hid.value = item.value;
      // Actualizar valores internos (no mostrar tarjeta; el input refleja la seleccion)
      $('selectedProveerName').textContent = item.label;
      $('selectedProveedorId').textContent = item.value;
      $('selectedProveedorRuc').textContent = item.ruc || '';
      // Mantener la etiqueta seleccionada en el input como confirmacion
      input.value = item.label || '';
      closeList();
      // trigger change on select
      select.dispatchEvent(new Event('change', {bubbles:true}));
    }

    // keyboard navigation helper
    function ensureVisible(){ var li = list.children[activeIndex]; if(li){ var liTop = li.offsetTop; var liBottom = liTop + li.offsetHeight; if(liTop < list.scrollTop) list.scrollTop = liTop; else if(liBottom > list.scrollTop + list.clientHeight) list.scrollTop = liBottom - list.clientHeight; } }

    // events
    input.addEventListener('input', function(e){ filter(e.target.value); renderList(); openList(); });
    
    input.addEventListener('focus', function(){
      // Guardar el valor anterior antes de limpiar
      previousValue = select.value;
      previousLabel = input.value;
      // Limpiar el input automaticamente para permitir nueva busqueda
      input.value = '';
      if(options.length===0) loadOptions(); else { filter(''); renderList(); openList(); }
    });

    input.addEventListener('blur', function() {
      // Esperar un poco para que el evento click en la lista se procese primero
      setTimeout(function() {
        // Si el input esta vacio pero habia un valor previo, restaurarlo
        if (input.value.trim() === '' && previousValue) {
          input.value = previousLabel;
          select.value = previousValue;
          var hid = $('m_provee_id'); if(hid) hid.value = previousValue;
        }
      }, 200);
    });

    button.addEventListener('click', function(){ if(list.classList.contains('hidden')){ filter(input.value); renderList(); openList(); } else { closeList(); } });
    list.addEventListener('click', function(e){ var li = e.target.closest('li'); if(!li) return; var idx = Number(li.dataset.idx); var item = filtered[idx]; if(item) selectItem(item); });

    input.addEventListener('keydown', function(e){ var key=e.key; if(key==='ArrowDown'){ e.preventDefault(); if(list.classList.contains('hidden')){ openList(); return; } activeIndex = Math.min(activeIndex+1, filtered.length-1); highlight(); ensureVisible(); } else if(key==='ArrowUp'){ e.preventDefault(); if(list.classList.contains('hidden')){ openList(); return; } activeIndex = Math.max(activeIndex-1,0); highlight(); ensureVisible(); } else if(key==='Enter'){ if(!list.classList.contains('hidden') && activeIndex>=0){ e.preventDefault(); var item = filtered[activeIndex]; if(item) selectItem(item); } } else if(key==='Escape'){ closeList(); } });

    document.addEventListener('click', function(e){ if(!container.contains(e.target)) closeList(); });

    // escape HTML helper
    function escapeHtml(s){ return String(s||'').replace(/[&<>"]/g, function(c){ return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'}[c]; }); }

    // initial load
    loadOptions();
  }

  function bindEvents(){
    var searchBtn = $('btnBuscar'); if(searchBtn){ searchBtn.addEventListener('click', function(){ currentPage=1; fetchList(); }); }
    var newBtn = $('btnNuevo'); if(newBtn){ newBtn.addEventListener('click', function(){
      clearModal();
      var titleEl = $('modalTitle'); if (titleEl) titleEl.textContent = 'Nuevo Contacto';
      var saveBtn = $('m_guardar'); if (saveBtn) { saveBtn.textContent = 'Guardar'; saveBtn.removeAttribute('data-id'); saveBtn.classList.remove('hidden'); }
      openModal();
    }); }
    var closeBtn = $('btnCloseModal'); if(closeBtn){ closeBtn.addEventListener('click', closeModal); }
    var cancelBtn = $('m_cancelar'); if(cancelBtn){ cancelBtn.addEventListener('click', closeModal); }
    if(modal){ modal.addEventListener('click', function(e){ /* no action */ }); }
    var ac=$('btnAddEmail'); if(ac){ ac.addEventListener('click', function(){ addEmailInput(''); }); }
    var at=$('btnAddTelefono'); if(at){ at.addEventListener('click', function(){ addTelefonoInput(''); }); }
    var acl=$('btnAddCelular'); if(acl){ acl.addEventListener('click', function(){ addCelularInput(''); }); }
    if(pageSizeEl){ pageSizeEl.addEventListener('change', function(){ var v=parseInt(this.value,10); if(!isNaN(v)&&v>0){ limit=v; currentPage=1; fetchList(); } }); }

    var saveBtn = $('m_guardar'); if(saveBtn){
      saveBtn.addEventListener('click', function(){
        var id = this.getAttribute('data-id');
        var nombre = ($('m_nombre').value||'').trim();
        var apellido = ($('m_apellido').value||'').trim();
        var cargo = ($('m_cargo').value||'').trim();
        var cumpleanios = ($('m_cumpleanios').value||'').trim();
        var origen = ($('m_origen').value||'').trim();
        var provee_id = parseInt($('m_provee_id').value||0, 10);
        var emails = readEmails();

        if(!nombre){ Swal.fire({icon:'info', text:'Nombre es requerido'}); return; }
        if(!provee_id || provee_id <= 0){ Swal.fire({icon:'info', text:'Proveedor ID es requerido'}); return; }

        // Validacion de email
        if (emails.length === 0) {
          Swal.fire({icon:'info', text:'Debe ingresar al menos un correo electronico.'});
          return;
        }
        for (var i = 0; i < emails.length; i++) {
          if (!validateEmail(emails[i])) {
            Swal.fire({icon:'error', text:'El correo electronico "' + emails[i] + '" no es valido.'});
            return;
          }
        }

        var body = {
          nombre: nombre,
          apellido: apellido,
          cargo: cargo,
          cumpleanios: cumpleanios,
          origen: origen,
          provee_id: provee_id,
          email: JSON.stringify(emails),
          telefono: JSON.stringify(readTelefonos()),
          celular: JSON.stringify(readCelulares())
        };

        var action = id ? 'update' : 'create'; if(id){ body.id = id; }
        fetch(ctrl+'?action='+action, { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(body), credentials:'same-origin' })
          .then(function(res){ 
            if (!res.ok) {
              console.error('HTTP error, status:', res.status, res.statusText);
              return res.text().then(function(text) {
                console.error('Response body:', text);
                throw new Error('HTTP ' + res.status + ': ' + res.statusText);
              });
            }
            return res.text();
          })
          .then(function(text){
            console.log('Response text:', text);
            var js;
            try {
              js = JSON.parse(text);
            } catch (e) {
              console.warn('No es JSON valido. Intentando extraer JSON...', e);
              var idxObj = text.indexOf('{');
              var idxArr = text.indexOf('[');
              var start = -1;
              if (idxObj === -1 && idxArr === -1) throw e;
              if (idxObj === -1) start = idxArr; else if (idxArr === -1) start = idxObj; else start = Math.min(idxObj, idxArr);
              var endBrace = text.lastIndexOf('}');
              var endBracket = text.lastIndexOf(']');
              var end = Math.max(endBrace, endBracket);
              if (start === -1 || end === -1 || end <= start) {
                console.error('No se pudo extraer JSON valido');
                throw e;
              }
              var sub = text.slice(start, end + 1);
              js = JSON.parse(sub);
            }
            if(!js.success){ 
              Swal.fire({icon:'error', text: js.message || 'No se pudo guardar'}); 
              return; 
            } 
            Swal.fire({ icon:'success', title:(id?'Actualizado':'Creado')+' con Exito', timer:1500, showConfirmButton:false }); 
            closeModal(); 
            fetchList();
          })
          .catch(function(err){ 
            console.error('Error al guardar:', err);
            Swal.fire({ icon:'error', text:'Error de red al guardar: ' + err.message }); 
          });
      });
    }
    // --- Integracion: Modal rapido para crear Proveedor desde Contacto ---
    (function(){
      var provModal = $('prov_modal');
      var btnOpen = $('btnAddProveedor');
      var btnClose = $('prov_cerrar');
      var btnCancel = $('prov_cancelar');
      var btnSave = $('prov_guardar');
      var provCtrl = baseGuess + 'controller/proveedor/proveedor.php';

      function openProv(){ if(provModal){ provModal.classList.remove('hidden'); provModal.classList.add('flex'); } }
      function closeProv(){ if(provModal){ provModal.classList.add('hidden'); provModal.classList.remove('flex'); } }
      function clearProv(){
        var ids=['prov_ruc','prov_razon_social','prov_razon_comercial','prov_email','prov_telefono','prov_celular','prov_paginaweb'];
        for(var i=0;i<ids.length;i++){ var el=$(ids[i]); if(el) el.value=''; }
      }
      function applySelectedProveedor(p){
        if(!p || !p.id) return;
        var sel = $('m_provee_select');
        var label = p.razon_social || p.razon_comercial || p.ruc || String(p.id);
        var opt = sel ? sel.querySelector('option[value="'+p.id+'"]') : null;
        if(!opt && sel){
          opt = document.createElement('option');
          opt.value = p.id;
          opt.textContent = label;
          opt.setAttribute('data-ruc', p.ruc||'');
          if (sel.options.length > 1) sel.insertBefore(opt, sel.options[1]); else sel.appendChild(opt);
        }
        if(sel) sel.value = p.id;
        var hid=$('m_provee_id'); if(hid) hid.value = p.id;
        var cbInputEl = document.getElementById('__cb_input_m_provee_select'); if(cbInputEl) cbInputEl.value = label;
        var n=$('selectedProveerName'); if(n) n.textContent = label;
        var pid=$('selectedProveedorId'); if(pid) pid.textContent = p.id;
        var pr=$('selectedProveedorRuc'); if(pr) pr.textContent = p.ruc || '';
        // Actualizar lista del combobox en memoria (para que aparezca sin recargar)
        try { if(window.__proveeSelects && window.__proveeSelects['m_provee_select'] && window.__proveeSelects['m_provee_select'].add){ window.__proveeSelects['m_provee_select'].add({ id: p.id, razon_comercial: p.razon_comercial, razon_social: p.razon_social, ruc: p.ruc }); } } catch(e){}
      }

      if(btnOpen){ btnOpen.addEventListener('click', function(){ clearProv(); openProv(); }); }
      if(btnClose){ btnClose.addEventListener('click', closeProv); }
      if(btnCancel){ btnCancel.addEventListener('click', closeProv); }
      if(btnSave){ btnSave.addEventListener('click', function(){
        var ruc = ($('prov_ruc').value||'').trim();
        var razon_social = ($('prov_razon_social').value||'').trim();
        var razon_comercial = ($('prov_razon_comercial').value||'').trim();
        var email = ($('prov_email').value||'').trim();
        var telefono = ($('prov_telefono').value||'').trim();
        var celular = ($('prov_celular').value||'').trim();
        var paginaweb = ($('prov_paginaweb').value||'').trim();
        if(!ruc){ Swal.fire({icon:'info', text:'RUC es requerido'}); return; }
        if(email && !validateEmail(email)) { Swal.fire({icon:'error', text:'Ingrese un email valido'}); return; }
        var body = { ruc:ruc };
        if(razon_social) body.razon_social = razon_social;
        if(razon_comercial) body.razon_comercial = razon_comercial;
        if(email) body.email = email;
        if(telefono) body.telefono = telefono;
        if(celular) body.celular = celular;
        if(paginaweb) body.paginaweb = paginaweb;

        fetch(provCtrl+'?action=create', { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(body), credentials:'same-origin' })
          .then(function(res){ return res.text(); })
          .then(function(text){
            var js;
            try { js = JSON.parse(text); }
            catch(e){
              var idxObj = text.indexOf('{'); var idxArr = text.indexOf('[');
              var start = (idxObj===-1?idxArr:(idxArr===-1?idxObj:Math.min(idxObj,idxArr)));
              var end = Math.max(text.lastIndexOf('}'), text.lastIndexOf(']'));
              if(start>=0 && end>start) js = JSON.parse(text.slice(start,end+1)); else throw e;
            }
            if(js && js.success){
              Swal.fire({icon:'success', title:'Proveedor creado', timer:1200, showConfirmButton:false});
              closeProv();
              applySelectedProveedor({ id: js.id, razon_comercial: razon_comercial, razon_social: razon_social, ruc: ruc });
            } else {
              var msg = (js && js.message) || 'No se pudo crear el proveedor';
              if(/RUC ya registrado/i.test(msg||'')){
                // Buscar por RUC y seleccionar automaticamente
                fetch(provCtrl+'?action=search_ruc&ruc='+encodeURIComponent(ruc), { credentials:'same-origin' })
                  .then(function(r){ return r.json(); })
                  .then(function(j){
                    if(j && j.local){
                      var p=j.local; applySelectedProveedor({ id: p.idprovee, razon_comercial: p.razon_comercial, razon_social: p.razon_social, ruc: p.ruc });
                      Swal.fire({icon:'info', title:'Proveedor ya existia', text:'Se selecciono automaticamente.', timer:1800, showConfirmButton:false});
                      closeProv();
                    } else {
                      Swal.fire({icon:'error', text: msg});
                    }
                  })
                  .catch(function(){ Swal.fire({icon:'error', text: msg}); });
              } else {
                Swal.fire({icon:'error', text: msg});
              }
            }
          })
          .catch(function(err){ Swal.fire({icon:'error', text:'Error de red: '+err.message}); });
      }); }
    })();
  }

  function addClearSingleFilterButton(){
    var searchBtn = $('btnBuscar');
    if(!searchBtn) return;
    if (document.getElementById('btnVerTodosContactos')) return;
    var btn = document.createElement('button');
    btn.id = 'btnVerTodosContactos';
    btn.type = 'button';
    btn.textContent = 'Limpiar filtro';
    btn.className = 'px-3 py-2 bg-gray-200 text-gray-800 rounded ml-2';
    btn.addEventListener('click', function(){
      var qEl = $('q'); if(qEl) qEl.value = '';
      var campoSel = $('campoBusqueda'); if(campoSel) campoSel.value = 'todos';
      currentPage = 1;
      if (window.paginacion && window.paginacion.setCurrentPage) {
        window.paginacion.setCurrentPage(1);
      }
      // Limpiar el parametro de la URL sin recargar
      try {
        var url = new URL(window.location.href);
        url.searchParams.delete('contacto_id');
        window.history.replaceState({}, document.title, url.toString());
      } catch(e){}
      fetchList();
    });
    searchBtn.parentNode && searchBtn.parentNode.appendChild(btn);
  }

  document.addEventListener('DOMContentLoaded', function(){
    // Asegurar que los eventos basicos siempre se vinculen
    bindEvents();
    initSearchableSelect('m_provee_select','proveeComboContainer');
    var prev=$('btnPrev'), next=$('btnNext');
    if(prev){ prev.addEventListener('click', function(){ if(currentPage>1){ currentPage--; fetchList(); } }); }
    if(next){ next.addEventListener('click', function(){ if(currentPage<totalPages){ currentPage++; fetchList(); } }); }

    // Si viene ?contacto_id=123 desde Proveedores, aplicar filtro por ID y recargar en la primera pagina
    try {
      var params = new URLSearchParams(window.location.search);
      var cid = params.get('contacto_id');
      if (cid) {
        var qEl = $('q'); if (qEl) qEl.value = cid;
        var campoSel = $('campoBusqueda'); if (campoSel) campoSel.value = 'id';
        currentPage = 1;
        if (window.paginacion && window.paginacion.setCurrentPage) {
          window.paginacion.setCurrentPage(1);
        }
        addClearSingleFilterButton();
        // Cargar solo ese contacto sin listar todo
        loadContactById(cid);
        return;
      }
    } catch(e) {}

    fetchList();
  });
  
  // Integracion con paginacion compartida (señalizada desde el modulo del layout)
  window.addEventListener('contactos-paginacion-ready', function(){
    // Sobrescribe updatePager para usar el control compartido
    updatePager = function(){
      try {
        if (window.paginacion) {
          window.paginacion.setCurrentPage(currentPage);
          window.paginacion.rowsPerPage = limit;
          window.paginacion.updatePaginationInfo(totalRecords || 0);
          window.paginacion.renderPaginationControls();
        }
      } catch(e) {}
    };
    // Exponer recarga coherente con paginacion
    window.reloadContactosTable = function(){
      if (window.paginacion) {
        currentPage = Number(window.paginacion.currentPage) || currentPage;
        limit = Number(window.paginacion.rowsPerPage) || limit;
      }
      fetchList();
    };
  });
})();


