(function(){
  function $(id){ return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function(){
    var p = location.pathname.split('/');
    return p[1] ? ('/' + p[1] + '/') : '/';
  })();
  var ctrl = baseGuess + 'controller/producto/producto.php';
  var catgMap = {};
  var initialExtraIds = [];

  var modal = $('modalProducto');

  function openModal(){ if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); } }
  function closeModal(){
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
    clearModal();
  }

  function clearModal(){
    var ids = [
      'm_idprodmodel','m_name_prod','m_catg_id','m_catg_ids','m_variant_code','m_variant_name',
      'm_detail','m_img'
    ];
    ids.forEach(function(id){
      var el = $(id);
      if(!el) return;
      el.value = '';
    });
    if (window.tinymce && tinymce.get('m_detail')) {
      tinymce.get('m_detail').setContent('');
    }
    initialExtraIds = [];
    setExtraCategories([]);
    var imgPrev = $('m_img_preview');
    if(imgPrev){
      imgPrev.src = '';
      imgPrev.classList.add('hidden');
    }
    var title = $('modalProdTitle'); if(title) title.textContent = 'Nuevo producto';
  }

  function fetchJson(url, options){
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function(res){ return res.text(); })
      .then(function(text){
        var t = text.replace(/^\uFEFF/, '');
        try { return JSON.parse(t); }
        catch(e){
          var iObj = t.indexOf('{');
          var iArr = t.indexOf('[');
          var start = -1;
          if (iObj === -1 && iArr === -1) throw e;
          if (iObj === -1) start = iArr; else if (iArr === -1) start = iObj; else start = Math.min(iObj, iArr);
          var end = Math.max(t.lastIndexOf('}'), t.lastIndexOf(']'));
          if (start === -1 || end === -1 || end <= start) throw e;
          var sub = t.slice(start, end + 1);
          return JSON.parse(sub);
        }
      });
  }

  function renderRows(rows){
    var tbody = $('tbodyProductos');
    if(!tbody) return;
    tbody.innerHTML = '';
    if(!rows || !rows.length){
      var tr = document.createElement('tr');
      tr.innerHTML = '<td class="px-2 py-1 text-gray-500 text-xs" colspan="7">Sin datos</td>';
      tbody.appendChild(tr);
      return;
    }
    rows.forEach(function(r){
      var estado = (String(r.status) === '1' ? 'Activo' : 'Inactivo');
      var cat = r.categoria_nombre || '';
      var fecha = r.dateupdate || r.datecreate || '';
      var tr = document.createElement('tr');
      tr.innerHTML =
        '<td class="px-2 py-1 text-xs">'+ (r.idprodmodel || '') +'</td>'+
        '<td class="px-2 py-1 text-xs">'+ (r.name_prod || '') +'</td>'+
        '<td class="px-2 py-1 text-xs">'+ (r.variant_name || r.variant_code || '') +'</td>'+
        '<td class="px-2 py-1 text-xs">'+ cat +'</td>'+
        '<td class="px-2 py-1 text-xs">'+ estado +'</td>'+
        '<td class="px-2 py-1 text-xs">'+ fecha +'</td>'+
        '<td class="px-2 py-1 text-xs">'+
          '<button class="btn-prod-edit text-xs text-blue-600 mr-2" data-id="'+ (r.idprodmodel || '') +'">Editar</button>'+
          '<button class="btn-prod-del text-xs text-red-600" data-id="'+ (r.idprodmodel || '') +'">Eliminar</button>'+
        '</td>';
      tbody.appendChild(tr);
    });
    bindRowActions();
  }

  function fetchList(){
    var q = ($('prod_q') && $('prod_q').value || '').trim();
    var params = new URLSearchParams({ action: 'list', q: q });
    fetchJson(ctrl + '?' + params.toString())
      .then(function(js){
        if(!js || !js.success){ renderRows([]); return; }
        renderRows(js.data || []);
      })
      .catch(function(err){
        console.error('Error cargando productos:', err);
        renderRows([]);
      });
  }

  function getExtraIds(){
    var hidden = $('m_catg_ids');
    if(!hidden || !hidden.value) return [];
    return hidden.value.split(',').map(function(x){ return parseInt(x,10); }).filter(function(x){ return !isNaN(x) && x>0; });
  }

  function loadCategorias(selectedId){
    var catCtrl = baseGuess + 'controller/categoria/categoria.php?action=list';
    fetchJson(catCtrl)
      .then(function(js){
        var selMain = $('m_catg_id');
        var selExtra = $('m_catg_extra_select');
        catgMap = {};
        if(selMain){
          selMain.innerHTML = '<option value="">Seleccione categoría</option>';
        }
        if(selExtra){
          selExtra.innerHTML = '<option value="">Seleccione categoría adicional</option>';
        }
        var extraIds = (initialExtraIds && initialExtraIds.length) ? initialExtraIds.slice() : getExtraIds();
        if(js && js.success && js.data){
          js.data.forEach(function(c){
            var idNum = parseInt(c.idcat, 10);
            if(!isNaN(idNum)){
              catgMap[idNum] = c.name_cat;
            }
            if(selMain){
              var opt = document.createElement('option');
              opt.value = c.idcat;
              opt.textContent = c.name_cat;
              selMain.appendChild(opt);
            }
            if(selExtra){
              if(!isNaN(idNum) && idNum !== parseInt(selectedId || '0', 10) && extraIds.indexOf(idNum) === -1){
                var opt2 = document.createElement('option');
                opt2.value = c.idcat;
                opt2.textContent = c.name_cat;
                selExtra.appendChild(opt2);
              }
            }
          });
          if(selectedId && selMain){
            selMain.value = String(selectedId);
          }
          if(extraIds && extraIds.length){
            setExtraCategories(extraIds);
            initialExtraIds = [];
          }
        }
      })
      .catch(function(e){ console.error('Error cargando categorías:', e); });
  }

  function setExtraCategories(ids){
    var hidden = $('m_catg_ids');
    var tags = $('m_catg_extra_tags');
    if(!hidden || !tags) return;
    var unique = Array.from(new Set(ids.filter(function(x){ return !isNaN(x) && x>0; })));
    hidden.value = unique.join(',');
    tags.innerHTML = '';
    unique.forEach(function(id){
      var label = catgMap[id] || ('ID ' + id);
      var span = document.createElement('span');
      span.className = 'inline-flex items-center px-2 py-0.5 bg-blue-100 text-blue-700 rounded-full';
      span.textContent = label;
      var btn = document.createElement('button');
      btn.type = 'button';
      btn.className = 'ml-1 text-[10px] text-red-600';
      btn.textContent = '×';
      btn.addEventListener('click', function(){
        var current = hidden.value ? hidden.value.split(',').map(function(x){ return parseInt(x,10); }).filter(function(x){ return !isNaN(x); }) : [];
        var filtered = current.filter(function(v){ return v !== id; });
        setExtraCategories(filtered);
        // recargar opciones de adicionales para re-incluir esta categoría
        var mainId = $('m_catg_id') ? $('m_catg_id').value : '';
        loadCategorias(mainId || '');
      });
      span.appendChild(btn);
      tags.appendChild(span);
    });
  }

  function tryParseJson(text){
    if(!text) return null;
    try {
      return JSON.parse(text);
    } catch(e){
      return null;
    }
  }

  function openEdit(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){
        if(!js || !js.success || !js.data){ return; }
        var d = js.data;
        clearModal();
        if($('m_idprodmodel')) $('m_idprodmodel').value = d.idprodmodel || '';
        if($('m_name_prod')) $('m_name_prod').value = d.name_prod || '';

        if(d.catg_ids){
          try{
            var arr = JSON.parse(d.catg_ids);
            if(Array.isArray(arr)){
              initialExtraIds = arr.map(function(x){ return parseInt(x,10); }).filter(function(x){ return !isNaN(x); });
            } else {
              initialExtraIds = [];
            }
          } catch(e){
            initialExtraIds = [];
          }
        } else {
          initialExtraIds = [];
        }

        if($('m_variant_code')) $('m_variant_code').value = d.variant_code || '';
        if($('m_variant_name')) $('m_variant_name').value = d.variant_name || '';

        if(d.detail){
          var detailText = '';
          var parsed = tryParseJson(d.detail);
          if(typeof parsed === 'string'){
            detailText = parsed;
          } else if(parsed && typeof parsed === 'object' && parsed.rows && Array.isArray(parsed.rows)){
            var lines = [];
            if(parsed.title) lines.push(parsed.title);
            parsed.rows.forEach(function(r){
              var line = '';
              if(r.label){
                line += r.label;
                if(!r.label.endsWith(':')){
                  line += ':';
                }
              }
              if(r.value){
                line += (line ? ' ' : '') + r.value;
              }
              if(line){
                lines.push(line);
              }
            });
            detailText = lines.join('\n');
          } else if(typeof d.detail === 'string'){
            detailText = d.detail;
          }
          if (window.tinymce && tinymce.get('m_detail')) {
            tinymce.get('m_detail').setContent(detailText);
          } else if($('m_detail')) {
            $('m_detail').value = detailText;
          }
        }

        if($('m_img')) $('m_img').value = d.img || '';
        var imgPrev = $('m_img_preview');
        if(imgPrev){
          if(d.img){
            imgPrev.src = d.img;
            imgPrev.classList.remove('hidden');
          } else {
            imgPrev.src = '';
            imgPrev.classList.add('hidden');
          }
        }
        var title = $('modalProdTitle'); if(title) title.textContent = 'Editar producto';
        loadCategorias(d.catg_id || '');
        openModal();
      });
  }

  function confirmDelete(id){
    if(!id) return;
    if(!window.Swal){
      if(!confirm('¿Desea eliminar este producto?')) return;
      doDelete(id);
      return;
    }
    Swal.fire({ icon:'warning', title:'Eliminar producto', text:'¿Desea eliminar este registro?', showCancelButton:true, confirmButtonText:'Sí, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDelete(id); });
  }

  function doDelete(id){
    var fd = new FormData(); fd.append('id', id);
    fetchJson(ctrl + '?action=delete', { method:'POST', body: fd })
      .then(function(js){
        if(js && js.success){
          if(window.Swal){
            Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false});
          }
          fetchList();
        } else {
          var msg = (js && js.message) || 'No se pudo eliminar';
          if(window.Swal){ Swal.fire({icon:'error', text: msg}); } else { alert(msg); }
        }
      })
      .catch(function(){
        if(window.Swal){ Swal.fire({icon:'error', text:'Error de red al eliminar'}); } else { alert('Error de red al eliminar'); }
      });
  }

  function buildPayload(){
    var id = $('m_idprodmodel') ? $('m_idprodmodel').value : '';
    var name = ($('m_name_prod') && $('m_name_prod').value || '').trim();
    var catgId = $('m_catg_id') ? $('m_catg_id').value : '';
    if(!name){
      if(window.Swal){ Swal.fire({icon:'warning', text:'El nombre del producto es obligatorio.'}); } else { alert('El nombre del producto es obligatorio.'); }
      return null;
    }
    if(!catgId){
      if(window.Swal){ Swal.fire({icon:'warning', text:'La categoría principal es obligatoria.'}); } else { alert('La categoría principal es obligatoria.'); }
      return null;
    }

    var prod = {
      name_prod: name,
      catg_id: parseInt(catgId,10),
      variant_code: ($('m_variant_code') && $('m_variant_code').value || '').trim(),
      variant_name: ($('m_variant_name') && $('m_variant_name').value || '').trim(),
      img: ($('m_img') && $('m_img').value || '').trim()
    };

    // siempre enviar catg_ids (aunque esté vacío) para que el backend actualice
    var catgIdsText = ($('m_catg_ids') && $('m_catg_ids').value || '').trim();
    var arr = [];
    if(catgIdsText){
      arr = catgIdsText.split(',').map(function(x){ return parseInt(x.trim(),10); }).filter(function(x){ return !isNaN(x) && x>0; });
    }
    prod.catg_ids = arr;

    var detailText = '';
    if (window.tinymce && tinymce.get('m_detail')) {
      detailText = tinymce.get('m_detail').getContent();
    } else if ($('m_detail')) {
      detailText = $('m_detail').value || '';
    }
    detailText = detailText.trim();
    if(detailText){
      prod.detail = detailText;
    }

    if(id){
      prod.id = parseInt(id,10);
    }
    return prod;
  }

  function bindRowActions(){
    var edits = document.querySelectorAll('.btn-prod-edit');
    for(var i=0;i<edits.length;i++){
      edits[i].addEventListener('click', function(){ openEdit(this.getAttribute('data-id')); });
    }
    var dels = document.querySelectorAll('.btn-prod-del');
    for(var j=0;j<dels.length;j++){
      dels[j].addEventListener('click', function(){ confirmDelete(this.getAttribute('data-id')); });
    }
  }

  function bindEvents(){
    var bBuscar = $('btnProdBuscar'); if(bBuscar){ bBuscar.addEventListener('click', fetchList); }
    var inputQ = $('prod_q'); if(inputQ){
      inputQ.addEventListener('keyup', function(e){ if(e.key === 'Enter'){ fetchList(); } });
    }
    var bNuevo = $('btnProdNuevo'); if(bNuevo){
      bNuevo.addEventListener('click', function(){
        clearModal();
        loadCategorias();
        openModal();
      });
    }
    var bClose = $('btnCloseModalProd'); if(bClose){ bClose.addEventListener('click', closeModal); }
    var bCancel = $('m_cancelar_prod'); if(bCancel){ bCancel.addEventListener('click', closeModal); }

    var mainCat = $('m_catg_id');
    if(mainCat){
      mainCat.addEventListener('change', function(){
        loadCategorias(this.value || '');
      });
    }

    var fileInput = $('m_img_file');
    if(fileInput){
      fileInput.addEventListener('change', function(){
        if(!fileInput.files || !fileInput.files[0]) return;
        var fd = new FormData();
        fd.append('file', fileInput.files[0]);
        fetchJson(ctrl + '?action=upload_image', {
          method: 'POST',
          body: fd
        }).then(function(js){
          if(!js || !js.success || !js.url){
            var msg = (js && js.message) || 'No se pudo subir la imagen';
            if(window.Swal){ Swal.fire({icon:'error', text: msg}); } else { alert(msg); }
            return;
          }
          if($('m_img')) $('m_img').value = js.url;
          var imgPrev = $('m_img_preview');
          if(imgPrev){
            imgPrev.src = js.url;
            imgPrev.classList.remove('hidden');
          }
        }).catch(function(err){
          console.error('Error al subir imagen:', err);
          if(window.Swal){ Swal.fire({icon:'error', text:'Error de red al subir imagen: ' + err.message}); } else { alert('Error de red al subir imagen'); }
        });
      });
    }

    var btnAddExtra = $('m_catg_extra_add');
    if(btnAddExtra){
      btnAddExtra.addEventListener('click', function(){
        var sel = $('m_catg_extra_select');
        var hidden = $('m_catg_ids');
        if(!sel || !hidden) return;
        var val = sel.value;
        if(!val) return;
        var id = parseInt(val,10);
        if(isNaN(id) || id <= 0) return;
        var current = hidden.value ? hidden.value.split(',').map(function(x){ return parseInt(x,10); }).filter(function(x){ return !isNaN(x); }) : [];
        current.push(id);
        setExtraCategories(current);
        sel.value = '';
        // al agregar, recargar opciones para sacar la categoría recién añadida
        var mainId = $('m_catg_id') ? $('m_catg_id').value : '';
        loadCategorias(mainId || '');
      });
    }

    var btnNuevaCat = $('btnProdNuevaCat');
    var modalNuevaCat = $('modalNuevaCatProd');
    function openNuevaCatModal(){
      if(modalNuevaCat){
        modalNuevaCat.classList.remove('hidden');
        modalNuevaCat.classList.add('flex');
      }
      var n1 = $('np_cat_name'); if(n1) n1.value = '';
      var n2 = $('np_cat_desc'); if(n2) n2.value = '';
    }
    function closeNuevaCatModal(){
      if(modalNuevaCat){
        modalNuevaCat.classList.add('hidden');
        modalNuevaCat.classList.remove('flex');
      }
    }
    if(btnNuevaCat){
      btnNuevaCat.addEventListener('click', openNuevaCatModal);
    }
    var btnCloseNuevaCat = $('btnCloseModalNuevaCatProd');
    if(btnCloseNuevaCat){
      btnCloseNuevaCat.addEventListener('click', closeNuevaCatModal);
    }
    var btnCancelarNuevaCat = $('np_cat_cancelar');
    if(btnCancelarNuevaCat){
      btnCancelarNuevaCat.addEventListener('click', closeNuevaCatModal);
    }
    var btnGuardarNuevaCat = $('np_cat_guardar');
    if(btnGuardarNuevaCat){
      btnGuardarNuevaCat.addEventListener('click', function(){
        var name = ($('np_cat_name') && $('np_cat_name').value || '').trim();
        var desc = ($('np_cat_desc') && $('np_cat_desc').value || '').trim();
        if(!name){
          if(window.Swal){ Swal.fire({icon:'warning', text:'El nombre de la categoría es obligatorio.'}); } else { alert('El nombre de la categoría es obligatorio.'); }
          return;
        }
        var body = { name_cat: name, descripcion: desc, status: 1 };
        var catCtrl = baseGuess + 'controller/categoria/categoria.php?action=create';
        fetchJson(catCtrl, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(body)
        }).then(function(js){
          if(!js || !js.success || !js.id){
            var msg = (js && js.message) || 'No se pudo crear la categoría';
            if(window.Swal){ Swal.fire({icon:'error', text: msg}); } else { alert(msg); }
            return;
          }
          closeNuevaCatModal();
          loadCategorias(String(js.id));
        }).catch(function(err){
          console.error('Error al crear categoría desde producto:', err);
          if(window.Swal){ Swal.fire({icon:'error', text:'Error de red al crear categoría: ' + err.message}); } else { alert('Error de red al crear categoría'); }
        });
      });
    }

    var bSave = $('m_guardar_prod'); if(bSave){
      bSave.addEventListener('click', function(){
        var body = buildPayload();
        if(!body) return;
        var isUpdate = !!body.id;
        var url = ctrl + '?action=' + (isUpdate ? 'update' : 'create');
        fetchJson(url, {
          method:'POST',
          headers:{ 'Content-Type':'application/json' },
          body: JSON.stringify(body)
        })
          .then(function(js){
            if(!js || !js.success){
              var msg = (js && js.message) || 'No se pudo guardar';
              if(window.Swal){ Swal.fire({icon:'error', text: msg}); } else { alert(msg); }
              return;
            }
            if(window.Swal){
              Swal.fire({ icon:'success', title:(isUpdate?'Actualizado':'Creado')+' con éxito', timer:1500, showConfirmButton:false });
            }
            closeModal();
            fetchList();
          })
          .catch(function(err){
            console.error('Error al guardar producto:', err);
            if(window.Swal){ Swal.fire({ icon:'error', text:'Error de red al guardar: ' + err.message }); } else { alert('Error de red al guardar'); }
          });
      });
    }
  }

  document.addEventListener('DOMContentLoaded', function(){
    bindEvents();
    fetchList();
  });
})();
