(function () {
  var API_URL = base + 'controller/mautic/ConfigController.php';

  var tabButtons = document.querySelectorAll('[data-tab]');
  var tabPanels = document.querySelectorAll('.tab-panel');
  var btnOpenInstancia = document.getElementById('btn-open-instancia');
  var btnOpenSegmento = document.getElementById('btn-open-segmento');
  var btnOpenReporte = document.getElementById('btn-open-reporte');
  var btnSyncMautic = document.getElementById('btn-sync-mautic');
  var btnSyncPush = document.getElementById('btn-sync-push');
  var btnSyncPull = document.getElementById('btn-sync-pull');
  var syncResult = document.getElementById('sync_result');
  var instanciaFilterEstado = document.getElementById('instancia_filter_estado');
  var segmentoFilterInstancia = document.getElementById('segmento_filter_instancia');
  var reporteFilterInstancia = document.getElementById('reporte_filter_instancia');

  var formInstancia = document.getElementById('form-instancia');
  var instanciaId = document.getElementById('instancia_id');
  var instanciaNombre = document.getElementById('instancia_nombre');
  var instanciaNombreError = document.getElementById('instancia_nombre_error');
  var instanciaBaseUrl = document.getElementById('instancia_base_url');
  var instanciaBaseUrlError = document.getElementById('instancia_base_url_error');
  var instanciaMinCampaignId = document.getElementById('instancia_min_campaign_id');
  var instanciaMinCampaignIdError = document.getElementById('instancia_min_campaign_id_error');
  var instanciaAuthType = document.getElementById('instancia_auth_type');
  var instanciaUser = document.getElementById('instancia_api_user');
  var instanciaUserError = document.getElementById('instancia_api_user_error');
  var instanciaPass = document.getElementById('instancia_api_pass');
  var instanciaPassError = document.getElementById('instancia_api_pass_error');
  var instanciaClientId = document.getElementById('instancia_oauth_client_id');
  var instanciaClientIdError = document.getElementById('instancia_oauth_client_id_error');
  var instanciaClientSecret = document.getElementById('instancia_oauth_client_secret');
  var instanciaClientSecretError = document.getElementById('instancia_oauth_client_secret_error');
  var instanciaRedirect = document.getElementById('instancia_oauth_redirect_uri');
  var instanciaRedirectError = document.getElementById('instancia_oauth_redirect_uri_error');
  var instanciaAccessToken = document.getElementById('instancia_oauth_access_token');
  var instanciaAccessTokenError = document.getElementById('instancia_oauth_access_token_error');
  var instanciaRefreshToken = document.getElementById('instancia_oauth_refresh_token');
  var instanciaRefreshTokenError = document.getElementById('instancia_oauth_refresh_token_error');
  var instanciaActivo = document.getElementById('instancia_activo');
  var instanciaReset = document.getElementById('instancia_reset');
  var instanciaSave = document.getElementById('instancia_save');
  var instanciaTest = document.getElementById('instancia_test');
  var instanciaTestResult = document.getElementById('instancia_test_result');
  var instanciasBody = document.getElementById('instancias-body');

  var formSegmento = document.getElementById('form-segmento');
  var segmentoId = document.getElementById('segmento_id');
  var segmentoInstancia = document.getElementById('segmento_instancia');
  var segmentoInstanciaError = document.getElementById('segmento_instancia_error');
  var segmentoClave = document.getElementById('segmento_clave');
  var segmentoClaveError = document.getElementById('segmento_clave_error');
  var segmentoIdMautic = document.getElementById('segmento_id_mautic');
  var segmentoIdMauticError = document.getElementById('segmento_id_mautic_error');
  var segmentoDesc = document.getElementById('segmento_desc');
  var segmentoDescError = document.getElementById('segmento_desc_error');
  var segmentoReset = document.getElementById('segmento_reset');
  var segmentoSave = document.getElementById('segmento_save');
  var segmentosBody = document.getElementById('segmentos-body');

  var formReporte = document.getElementById('form-reporte');
  var reporteId = document.getElementById('reporte_id');
  var reporteInstancia = document.getElementById('reporte_instancia');
  var reporteInstanciaError = document.getElementById('reporte_instancia_error');
  var reporteKey = document.getElementById('reporte_key');
  var reporteKeyError = document.getElementById('reporte_key_error');
  var reporteReportId = document.getElementById('reporte_report_id');
  var reporteReportIdError = document.getElementById('reporte_report_id_error');
  var reporteCampoCampania = document.getElementById('reporte_campo_campania');
  var reporteCampoCampaniaError = document.getElementById('reporte_campo_campania_error');
  var reporteCampoLead = document.getElementById('reporte_campo_lead');
  var reporteCampoLeadError = document.getElementById('reporte_campo_lead_error');
  var reporteCampoEmail = document.getElementById('reporte_campo_email');
  var reporteCampoEmailError = document.getElementById('reporte_campo_email_error');
  var reporteCampoSubject = document.getElementById('reporte_campo_subject');
  var reporteCampoSubjectError = document.getElementById('reporte_campo_subject_error');
  var reporteCampoClicks = document.getElementById('reporte_campo_clicks');
  var reporteCampoClicksError = document.getElementById('reporte_campo_clicks_error');
  var reporteCampoSent = document.getElementById('reporte_campo_sent');
  var reporteCampoSentError = document.getElementById('reporte_campo_sent_error');
  var reporteCampoRead = document.getElementById('reporte_campo_read');
  var reporteCampoReadError = document.getElementById('reporte_campo_read_error');
  var reporteActivo = document.getElementById('reporte_activo');
  var reporteReset = document.getElementById('reporte_reset');
  var reporteSave = document.getElementById('reporte_save');
  var reportesBody = document.getElementById('reportes-body');

  var oauthFields = document.querySelectorAll('.oauth-field');
  var basicFields = document.querySelectorAll('.basic-field');
  var instanciasCache = [];

  function setActiveTab(tabKey) {
    tabButtons.forEach(function (btn) {
      var active = btn.getAttribute('data-tab') === tabKey;
      btn.classList.toggle('bg-gray-900', active);
      btn.classList.toggle('text-white', active);
      btn.classList.toggle('bg-gray-100', !active);
      btn.classList.toggle('text-gray-700', !active);
    });
    tabPanels.forEach(function (panel) {
      panel.classList.toggle('hidden', panel.id !== 'tab-' + tabKey);
    });
  }

  function openModal(id) {
    var modal = document.getElementById(id);
    if (modal) {
      modal.classList.remove('hidden');
      modal.classList.add('flex');
    }
  }

  function closeModal(id) {
    var modal = document.getElementById(id);
    if (modal) {
      modal.classList.add('hidden');
      modal.classList.remove('flex');
    }
  }

  function markInvalid(el, invalid) {
    if (!el) {
      return;
    }
    el.classList.toggle('border-red-500', invalid);
    el.classList.toggle('bg-red-50', invalid);
    if (invalid) {
      el.setAttribute('aria-invalid', 'true');
    } else {
      el.removeAttribute('aria-invalid');
    }
  }

  function setError(errorEl, invalid) {
    if (!errorEl) {
      return;
    }
    errorEl.classList.toggle('hidden', !invalid);
  }

  function applyFieldValidation(fieldEl, errorEl, invalid, showErrors) {
    if (showErrors) {
      markInvalid(fieldEl, invalid);
      setError(errorEl, invalid);
    } else {
      markInvalid(fieldEl, false);
      setError(errorEl, false);
    }
  }

  function setSaveState(btn, valid) {
    if (!btn) {
      return;
    }
    btn.disabled = !valid;
    btn.classList.toggle('opacity-50', !valid);
    btn.classList.toggle('cursor-not-allowed', !valid);
  }

  function validateInstanceForm(showErrors) {
    var valid = true;
    var isEdit = instanciaId.value !== '';
    var authType = instanciaAuthType.value || 'basic';
    var nombreInvalid = instanciaNombre.value.trim() === '';
    var baseUrlInvalid = instanciaBaseUrl.value.trim() === '';
    var userInvalid = instanciaUser.value.trim() === '';
    var passInvalid = !isEdit && instanciaPass.value.trim() === '';
    var clientIdInvalid = instanciaClientId.value.trim() === '';
    var clientSecretInvalid = !isEdit && instanciaClientSecret.value.trim() === '';
    var redirectInvalid = false;
    var accessTokenInvalid = false;
    var refreshTokenInvalid = instanciaRefreshToken.value.trim() === '';
    var minCampaignInvalid = false;

    if (instanciaMinCampaignId && instanciaMinCampaignId.value.trim() !== '') {
      minCampaignInvalid = !/^\d+$/.test(instanciaMinCampaignId.value.trim());
    }

    applyFieldValidation(instanciaNombre, instanciaNombreError, nombreInvalid, showErrors);
    applyFieldValidation(instanciaMinCampaignId, instanciaMinCampaignIdError, minCampaignInvalid, showErrors);
    if (nombreInvalid) {
      valid = false;
    }

    if (authType === 'basic') {
      applyFieldValidation(instanciaBaseUrl, instanciaBaseUrlError, baseUrlInvalid, showErrors);
      applyFieldValidation(instanciaUser, instanciaUserError, userInvalid, showErrors);
      applyFieldValidation(instanciaPass, instanciaPassError, passInvalid, showErrors);
      applyFieldValidation(instanciaClientId, instanciaClientIdError, false, showErrors);
      applyFieldValidation(instanciaClientSecret, instanciaClientSecretError, false, showErrors);
      applyFieldValidation(instanciaRedirect, instanciaRedirectError, false, showErrors);
      applyFieldValidation(instanciaAccessToken, instanciaAccessTokenError, false, showErrors);
      applyFieldValidation(instanciaRefreshToken, instanciaRefreshTokenError, false, showErrors);
      if (baseUrlInvalid || userInvalid || passInvalid) {
        valid = false;
      }
    } else {
      applyFieldValidation(instanciaBaseUrl, instanciaBaseUrlError, baseUrlInvalid, showErrors);
      applyFieldValidation(instanciaUser, instanciaUserError, false, showErrors);
      applyFieldValidation(instanciaPass, instanciaPassError, false, showErrors);
      applyFieldValidation(instanciaClientId, instanciaClientIdError, clientIdInvalid, showErrors);
      applyFieldValidation(instanciaClientSecret, instanciaClientSecretError, clientSecretInvalid, showErrors);
      applyFieldValidation(instanciaRedirect, instanciaRedirectError, redirectInvalid, showErrors);
      applyFieldValidation(instanciaAccessToken, instanciaAccessTokenError, accessTokenInvalid, showErrors);
      applyFieldValidation(instanciaRefreshToken, instanciaRefreshTokenError, refreshTokenInvalid, showErrors);
      if (baseUrlInvalid || clientIdInvalid || clientSecretInvalid || refreshTokenInvalid) {
        valid = false;
      }
    }

    if (minCampaignInvalid) {
      valid = false;
    }

    return valid;
  }

  function validateSegmentForm(showErrors) {
    var valid = true;
    var instanciaInvalid = segmentoInstancia.value === '';
    var claveInvalid = segmentoClave.value.trim() === '';
    var idInvalid = segmentoIdMautic.value.trim() === '';
    applyFieldValidation(segmentoInstancia, segmentoInstanciaError, instanciaInvalid, showErrors);
    applyFieldValidation(segmentoClave, segmentoClaveError, claveInvalid, showErrors);
    applyFieldValidation(segmentoIdMautic, segmentoIdMauticError, idInvalid, showErrors);
    applyFieldValidation(segmentoDesc, segmentoDescError, false, showErrors);
    if (instanciaInvalid || claveInvalid || idInvalid) {
      valid = false;
    }
    return valid;
  }

  function validateReporteForm(showErrors) {
    var valid = true;
    var instanciaInvalid = reporteInstancia.value === '';
    var keyInvalid = reporteKey.value.trim() === '';
    var reportIdInvalid = reporteReportId.value.trim() === '';
    var campaniaInvalid = reporteCampoCampania.value.trim() === '';
    var leadInvalid = reporteCampoLead.value.trim() === '';
    var emailInvalid = reporteCampoEmail.value.trim() === '';
    var subjectInvalid = reporteCampoSubject && reporteCampoSubject.value.trim() === '';
    var clicksInvalid = reporteCampoClicks.value.trim() === '';
    var sentInvalid = reporteCampoSent.value.trim() === '';
    var readInvalid = reporteCampoRead.value.trim() === '';
    applyFieldValidation(reporteInstancia, reporteInstanciaError, instanciaInvalid, showErrors);
    applyFieldValidation(reporteKey, reporteKeyError, keyInvalid, showErrors);
    applyFieldValidation(reporteReportId, reporteReportIdError, reportIdInvalid, showErrors);
    applyFieldValidation(reporteCampoCampania, reporteCampoCampaniaError, campaniaInvalid, showErrors);
    applyFieldValidation(reporteCampoLead, reporteCampoLeadError, leadInvalid, showErrors);
    applyFieldValidation(reporteCampoEmail, reporteCampoEmailError, emailInvalid, showErrors);
    applyFieldValidation(reporteCampoSubject, reporteCampoSubjectError, subjectInvalid, showErrors);
    applyFieldValidation(reporteCampoClicks, reporteCampoClicksError, clicksInvalid, showErrors);
    applyFieldValidation(reporteCampoSent, reporteCampoSentError, sentInvalid, showErrors);
    applyFieldValidation(reporteCampoRead, reporteCampoReadError, readInvalid, showErrors);
    if (instanciaInvalid || keyInvalid || reportIdInvalid || campaniaInvalid || leadInvalid || emailInvalid ||
        subjectInvalid ||
        clicksInvalid || sentInvalid || readInvalid) {
      valid = false;
    }
    return valid;
  }

  function updateAuthFields() {
    var authType = instanciaAuthType.value || 'basic';
    oauthFields.forEach(function (el) {
      el.classList.toggle('hidden', authType !== 'oauth2');
    });
    basicFields.forEach(function (el) {
      el.classList.toggle('hidden', authType !== 'basic');
    });
  }

  function setTestResult(message, ok) {
    if (!instanciaTestResult) {
      return;
    }
    instanciaTestResult.textContent = message || '';
    instanciaTestResult.classList.toggle('text-green-600', !!ok);
    instanciaTestResult.classList.toggle('text-red-600', !ok && message);
    instanciaTestResult.classList.toggle('text-gray-500', !message);
  }

  function setSyncResult(message, ok) {
    if (!syncResult) {
      return;
    }
    syncResult.textContent = message || '';
    syncResult.classList.toggle('text-emerald-700', !!ok);
    syncResult.classList.toggle('text-red-600', !ok && message);
    syncResult.classList.toggle('text-gray-500', !message);
  }

  function sanitizeErrorMessage(message) {
    if (!message) {
      return 'No se pudo conectar.';
    }
    var lower = message.toLowerCase();
    if (lower.indexOf('api disabled') !== -1 || lower.indexOf('api_disabled') !== -1) {
      return 'API deshabilitada en Mautic.';
    }
    if (lower.indexOf('access_denied') !== -1 || lower.indexOf('unauthorized') !== -1) {
      return 'Acceso denegado por Mautic.';
    }
    return 'No se pudo conectar.';
  }

  function sanitizeSyncMessage(message) {
    if (!message) {
      return 'Error al sincronizar.';
    }
    var lower = message.toLowerCase();
    if (lower.indexOf('api disabled') !== -1 || lower.indexOf('api_disabled') !== -1) {
      return 'API deshabilitada en Mautic.';
    }
    if (lower.indexOf('access_denied') !== -1 || lower.indexOf('unauthorized') !== -1) {
      return 'Acceso denegado por Mautic.';
    }
    if (lower.indexOf('usuario y password requeridos') !== -1 || lower.indexOf('client id') !== -1) {
      return 'Credenciales incompletas en la instancia.';
    }
    if (lower.indexOf('segmento') !== -1 && lower.indexOf('requer') !== -1) {
      return 'Faltan segmentos configurados.';
    }
    if (lower.indexOf('report') !== -1 && lower.indexOf('requer') !== -1) {
      return 'Falta configurar el reporte.';
    }
    if (lower.indexOf('sesion expirada') !== -1) {
      return 'Sesion expirada. Vuelve a iniciar sesion.';
    }
    if (lower.indexOf('respuesta api mautic') !== -1) {
      return 'Error de API Mautic.';
    }
    return 'Error al sincronizar.';
  }

  function setSyncButtonState(btn, running) {
    if (!btn) {
      return;
    }
    btn.disabled = running;
    btn.classList.toggle('opacity-50', running);
    btn.classList.toggle('cursor-not-allowed', running);
  }

  function fetchJson(url, options) {
    return fetch(url, options || {}).then(function (res) {
      var contentType = res.headers.get('content-type') || '';
      var isJson = contentType.indexOf('application/json') !== -1;
      if (!res.ok) {
        if (isJson) {
          return res.json().then(function (data) {
            var message = (data && data.message) ? data.message : 'Request failed';
            throw new Error(message);
          }).catch(function () {
            throw new Error('Request failed');
          });
        }
        return res.text().then(function () {
          throw new Error('Sesion expirada o sin acceso.');
        });
      }
      if (isJson) {
        return res.json();
      }
      return res.text();
    });
  }

  function postJson(url, payload) {
    return fetchJson(url, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload || {})
    });
  }

  function resetInstanciaForm() {
    if (formInstancia) {
      formInstancia.dataset.attempted = 'false';
    }
    instanciaId.value = '';
    instanciaNombre.value = '';
    instanciaBaseUrl.value = '';
    if (instanciaMinCampaignId) {
      instanciaMinCampaignId.value = '';
    }
    instanciaAuthType.value = 'basic';
    instanciaUser.value = '';
    instanciaPass.value = '';
    instanciaClientId.value = '';
    instanciaClientSecret.value = '';
    instanciaRedirect.value = '';
    instanciaAccessToken.value = '';
    instanciaRefreshToken.value = '';
    instanciaActivo.checked = true;
    updateAuthFields();
    setSaveState(instanciaSave, validateInstanceForm(false));
    setTestResult('', false);
  }

  function resetSegmentoForm() {
    if (formSegmento) {
      formSegmento.dataset.attempted = 'false';
    }
    segmentoId.value = '';
    segmentoClave.value = '';
    segmentoIdMautic.value = '';
    segmentoDesc.value = '';
    setSaveState(segmentoSave, validateSegmentForm(false));
  }

  function resetReporteForm() {
    if (formReporte) {
      formReporte.dataset.attempted = 'false';
    }
    reporteId.value = '';
    reporteKey.value = 'all_emails';
    reporteReportId.value = '';
    reporteCampoCampania.value = 'campaign_id';
    reporteCampoLead.value = 'contactId';
    reporteCampoEmail.value = 'email_address';
    if (reporteCampoSubject) {
      reporteCampoSubject.value = 'subject';
    }
    reporteCampoClicks.value = 'hits';
    reporteCampoSent.value = 'date_sent';
    reporteCampoRead.value = 'date_read';
    reporteActivo.checked = true;
    setSaveState(reporteSave, validateReporteForm(false));
  }

  function renderInstancias(rows) {
    instanciasBody.innerHTML = '';
    rows.forEach(function (row) {
      var active = row.activo == 1 ? 'Si' : 'No';
      instanciasBody.insertAdjacentHTML('beforeend',
        '<tr class="border-b">' +
        '<td class="p-2">' + row.id + '</td>' +
        '<td class="p-2">' + (row.nombre || '') + '</td>' +
        '<td class="p-2">' + row.base_url + '</td>' +
        '<td class="p-2">' + (row.auth_type || 'basic') + '</td>' +
        '<td class="p-2">' + row.api_user + '</td>' +
        '<td class="p-2">' + active + '</td>' +
        '<td class="p-2">' +
        '<button class="text-blue-600 mr-2" data-action="edit" data-id="' + row.id + '">Editar</button>' +
        '<button class="text-red-600" data-action="delete" data-id="' + row.id + '">Eliminar</button>' +
        '</td>' +
        '</tr>');
    });
  }

  function applyInstanciaFilter() {
    var estado = instanciaFilterEstado ? instanciaFilterEstado.value : '';
    var filtered = instanciasCache.slice();
    if (estado !== '') {
      filtered = filtered.filter(function (row) {
        return String(row.activo) === estado;
      });
    }
    renderInstancias(filtered);
  }

  function loadInstancias() {
    fetchJson(API_URL + '?action=list_instances').then(function (data) {
      instanciasCache = data.data || [];
      segmentoInstancia.innerHTML = '';
      reporteInstancia.innerHTML = '';
      if (segmentoFilterInstancia) {
        segmentoFilterInstancia.innerHTML = '<option value="">Todas</option>';
      }
      if (reporteFilterInstancia) {
        reporteFilterInstancia.innerHTML = '<option value="">Todas</option>';
      }
      instanciasCache.forEach(function (row) {
        segmentoInstancia.insertAdjacentHTML('beforeend', '<option value="' + row.id + '">' + (row.nombre || row.base_url) + '</option>');
        reporteInstancia.insertAdjacentHTML('beforeend', '<option value="' + row.id + '">' + (row.nombre || row.base_url) + '</option>');
        if (segmentoFilterInstancia) {
          segmentoFilterInstancia.insertAdjacentHTML('beforeend', '<option value="' + row.id + '">' + (row.nombre || row.base_url) + '</option>');
        }
        if (reporteFilterInstancia) {
          reporteFilterInstancia.insertAdjacentHTML('beforeend', '<option value="' + row.id + '">' + (row.nombre || row.base_url) + '</option>');
        }
      });
      applyInstanciaFilter();
    });
  }

  function loadSegmentos() {
    var query = '';
    if (segmentoFilterInstancia && segmentoFilterInstancia.value) {
      query = '&instance_id=' + encodeURIComponent(segmentoFilterInstancia.value);
    }
    fetchJson(API_URL + '?action=list_segments' + query).then(function (data) {
      var rows = data.data || [];
      segmentosBody.innerHTML = '';
      rows.forEach(function (row) {
        segmentosBody.insertAdjacentHTML('beforeend',
          '<tr class="border-b">' +
          '<td class="p-2">' + row.id + '</td>' +
          '<td class="p-2">' + row.mautic_instancia_id + '</td>' +
          '<td class="p-2">' + row.segmento_clave + '</td>' +
          '<td class="p-2">' + row.mautic_segment_id + '</td>' +
          '<td class="p-2">' + (row.descripcion || '') + '</td>' +
          '<td class="p-2">' +
          '<button class="text-blue-600 mr-2" data-action="edit" data-id="' + row.id + '">Editar</button>' +
          '<button class="text-red-600" data-action="delete" data-id="' + row.id + '">Eliminar</button>' +
          '</td>' +
          '</tr>');
      });
    });
  }

  function loadReportes() {
    var query = '';
    if (reporteFilterInstancia && reporteFilterInstancia.value) {
      query = '&instance_id=' + encodeURIComponent(reporteFilterInstancia.value);
    }
    fetchJson(API_URL + '?action=list_reports' + query).then(function (data) {
      var rows = data.data || [];
      reportesBody.innerHTML = '';
      rows.forEach(function (row) {
        var active = row.activo == 1 ? 'Si' : 'No';
        reportesBody.insertAdjacentHTML('beforeend',
          '<tr class="border-b">' +
          '<td class="p-2">' + row.id + '</td>' +
          '<td class="p-2">' + row.mautic_instancia_id + '</td>' +
          '<td class="p-2">' + row.report_key + '</td>' +
          '<td class="p-2">' + row.report_id + '</td>' +
          '<td class="p-2">' + row.campo_campania + '</td>' +
          '<td class="p-2">' + (row.campo_lead_id || '') + '</td>' +
          '<td class="p-2">' + row.campo_clicks + '</td>' +
          '<td class="p-2">' + active + '</td>' +
          '<td class="p-2">' +
          '<button class="text-blue-600 mr-2" data-action="edit" data-id="' + row.id + '">Editar</button>' +
          '<button class="text-red-600" data-action="delete" data-id="' + row.id + '">Eliminar</button>' +
          '</td>' +
          '</tr>');
      });
    });
  }

  if (formInstancia) {
    formInstancia.addEventListener('submit', function (e) {
      e.preventDefault();
      formInstancia.dataset.attempted = 'true';
      var valid = validateInstanceForm(true);
      setSaveState(instanciaSave, valid);
      if (!valid) {
        return;
      }
      postJson(API_URL + '?action=save_instance', {
        id: instanciaId.value || null,
        nombre: instanciaNombre.value,
        base_url: instanciaBaseUrl.value,
        min_campaign_id: instanciaMinCampaignId ? instanciaMinCampaignId.value : '',
        auth_type: instanciaAuthType.value,
        api_user: instanciaUser.value,
        api_pass: instanciaPass.value,
        oauth_client_id: instanciaClientId.value,
        oauth_client_secret: instanciaClientSecret.value,
        oauth_redirect_uri: instanciaRedirect.value,
        oauth_access_token: instanciaAccessToken.value,
        oauth_refresh_token: instanciaRefreshToken.value,
        activo: instanciaActivo.checked ? 1 : 0
      }).then(function () {
        resetInstanciaForm();
        closeModal('modal-instancia');
        loadInstancias();
      });
    });
    formInstancia.addEventListener('input', function () {
      var showErrors = formInstancia.dataset.attempted === 'true';
      setSaveState(instanciaSave, validateInstanceForm(showErrors));
      setTestResult('', false);
    });
    formInstancia.addEventListener('change', function () {
      var showErrors = formInstancia.dataset.attempted === 'true';
      setSaveState(instanciaSave, validateInstanceForm(showErrors));
      setTestResult('', false);
    });
  }

  if (instanciaReset) {
    instanciaReset.addEventListener('click', resetInstanciaForm);
  }

  if (formSegmento) {
    formSegmento.addEventListener('submit', function (e) {
      e.preventDefault();
      formSegmento.dataset.attempted = 'true';
      var valid = validateSegmentForm(true);
      setSaveState(segmentoSave, valid);
      if (!valid) {
        return;
      }
      postJson(API_URL + '?action=save_segment', {
        id: segmentoId.value || null,
        mautic_instancia_id: segmentoInstancia.value,
        segmento_clave: segmentoClave.value,
        mautic_segment_id: segmentoIdMautic.value,
        descripcion: segmentoDesc.value
      }).then(function () {
        resetSegmentoForm();
        closeModal('modal-segmento');
        loadSegmentos();
      });
    });
    formSegmento.addEventListener('input', function () {
      var showErrors = formSegmento.dataset.attempted === 'true';
      setSaveState(segmentoSave, validateSegmentForm(showErrors));
    });
    formSegmento.addEventListener('change', function () {
      var showErrors = formSegmento.dataset.attempted === 'true';
      setSaveState(segmentoSave, validateSegmentForm(showErrors));
    });
  }

  if (segmentoReset) {
    segmentoReset.addEventListener('click', resetSegmentoForm);
  }

  if (formReporte) {
    formReporte.addEventListener('submit', function (e) {
      e.preventDefault();
      formReporte.dataset.attempted = 'true';
      var valid = validateReporteForm(true);
      setSaveState(reporteSave, valid);
      if (!valid) {
        return;
      }
      postJson(API_URL + '?action=save_report', {
        id: reporteId.value || null,
        mautic_instancia_id: reporteInstancia.value,
        report_key: reporteKey.value,
        report_id: reporteReportId.value,
        campo_campania: reporteCampoCampania.value,
        campo_lead_id: reporteCampoLead.value,
        campo_email: reporteCampoEmail.value,
        campo_subject: reporteCampoSubject ? reporteCampoSubject.value : '',
        campo_clicks: reporteCampoClicks.value,
        campo_date_sent: reporteCampoSent.value,
        campo_date_read: reporteCampoRead.value,
        activo: reporteActivo.checked ? 1 : 0
      }).then(function () {
        resetReporteForm();
        closeModal('modal-reporte');
        loadReportes();
      });
    });
    formReporte.addEventListener('input', function () {
      var showErrors = formReporte.dataset.attempted === 'true';
      setSaveState(reporteSave, validateReporteForm(showErrors));
    });
    formReporte.addEventListener('change', function () {
      var showErrors = formReporte.dataset.attempted === 'true';
      setSaveState(reporteSave, validateReporteForm(showErrors));
    });
  }

  if (reporteReset) {
    reporteReset.addEventListener('click', resetReporteForm);
  }

  instanciasBody.addEventListener('click', function (e) {
    var btn = e.target.closest('button');
    if (!btn) {
      return;
    }
    var id = btn.getAttribute('data-id');
    if (btn.getAttribute('data-action') === 'delete') {
      if (confirm('Eliminar instancia?')) {
        postJson(API_URL + '?action=delete_instance', { id: id }).then(function () {
          loadInstancias();
        });
      }
      return;
    }
    if (btn.getAttribute('data-action') === 'edit') {
      fetchJson(API_URL + '?action=list_instances').then(function (data) {
        var row = (data.data || []).find(function (r) { return String(r.id) === String(id); });
      if (!row) {
        return;
      }
      instanciaId.value = row.id;
      instanciaNombre.value = row.nombre || '';
      instanciaBaseUrl.value = row.base_url || '';
      if (instanciaMinCampaignId) {
        instanciaMinCampaignId.value = row.min_campaign_id || '';
      }
      instanciaAuthType.value = row.auth_type || 'basic';
        instanciaUser.value = row.api_user || '';
        instanciaPass.value = '';
        instanciaClientId.value = row.oauth_client_id || '';
        instanciaClientSecret.value = '';
        instanciaRedirect.value = row.oauth_redirect_uri || '';
      instanciaAccessToken.value = '';
      instanciaRefreshToken.value = '';
      instanciaActivo.checked = row.activo == 1;
      updateAuthFields();
      setSaveState(instanciaSave, validateInstanceForm(formInstancia.dataset.attempted === 'true'));
      openModal('modal-instancia');
    });
  }
  });

  segmentosBody.addEventListener('click', function (e) {
    var btn = e.target.closest('button');
    if (!btn) {
      return;
    }
    var id = btn.getAttribute('data-id');
    if (btn.getAttribute('data-action') === 'delete') {
      if (confirm('Eliminar segmento?')) {
        postJson(API_URL + '?action=delete_segment', { id: id }).then(function () {
          loadSegmentos();
        });
      }
      return;
    }
    if (btn.getAttribute('data-action') === 'edit') {
      fetchJson(API_URL + '?action=list_segments').then(function (data) {
        var row = (data.data || []).find(function (r) { return String(r.id) === String(id); });
      if (!row) {
        return;
      }
      segmentoId.value = row.id;
      segmentoInstancia.value = row.mautic_instancia_id;
      segmentoClave.value = row.segmento_clave || '';
      segmentoIdMautic.value = row.mautic_segment_id || '';
      segmentoDesc.value = row.descripcion || '';
      setSaveState(segmentoSave, validateSegmentForm(formSegmento.dataset.attempted === 'true'));
      openModal('modal-segmento');
    });
  }
  });

  reportesBody.addEventListener('click', function (e) {
    var btn = e.target.closest('button');
    if (!btn) {
      return;
    }
    var id = btn.getAttribute('data-id');
    if (btn.getAttribute('data-action') === 'delete') {
      if (confirm('Eliminar reporte?')) {
        postJson(API_URL + '?action=delete_report', { id: id }).then(function () {
          loadReportes();
        });
      }
      return;
    }
    if (btn.getAttribute('data-action') === 'edit') {
      fetchJson(API_URL + '?action=list_reports').then(function (data) {
        var row = (data.data || []).find(function (r) { return String(r.id) === String(id); });
      if (!row) {
        return;
      }
      reporteId.value = row.id;
      reporteInstancia.value = row.mautic_instancia_id;
      reporteKey.value = row.report_key || '';
      reporteReportId.value = row.report_id || '';
      reporteCampoCampania.value = row.campo_campania || '';
      reporteCampoLead.value = row.campo_lead_id || '';
      reporteCampoEmail.value = row.campo_email || '';
      if (reporteCampoSubject) {
        reporteCampoSubject.value = row.campo_subject || '';
      }
      reporteCampoClicks.value = row.campo_clicks || '';
      reporteCampoSent.value = row.campo_date_sent || '';
      reporteCampoRead.value = row.campo_date_read || '';
      reporteActivo.checked = row.activo == 1;
      setSaveState(reporteSave, validateReporteForm(formReporte.dataset.attempted === 'true'));
      openModal('modal-reporte');
    });
  }
  });

  document.querySelectorAll('[data-close]').forEach(function (btn) {
    btn.addEventListener('click', function () {
      closeModal(btn.getAttribute('data-close'));
    });
  });

  ['modal-instancia', 'modal-segmento', 'modal-reporte'].forEach(function (id) {
    var modal = document.getElementById(id);
    if (!modal) {
      return;
    }
    modal.addEventListener('click', function (e) {
      if (e.target === modal) {
        closeModal(id);
      }
    });
  });

  if (btnOpenInstancia) {
    btnOpenInstancia.addEventListener('click', function () {
      resetInstanciaForm();
      updateAuthFields();
      openModal('modal-instancia');
    });
  }

  if (btnOpenSegmento) {
    btnOpenSegmento.addEventListener('click', function () {
      resetSegmentoForm();
      openModal('modal-segmento');
    });
  }

  if (btnOpenReporte) {
    btnOpenReporte.addEventListener('click', function () {
      resetReporteForm();
      openModal('modal-reporte');
    });
  }

  tabButtons.forEach(function (btn) {
    btn.addEventListener('click', function () {
      setActiveTab(btn.getAttribute('data-tab'));
    });
  });

  resetInstanciaForm();
  resetSegmentoForm();
  resetReporteForm();
  loadInstancias();
  loadSegmentos();
  loadReportes();
  setActiveTab('instancias');

  if (instanciaAuthType) {
    instanciaAuthType.addEventListener('change', function () {
      updateAuthFields();
      setSaveState(instanciaSave, validateInstanceForm(formInstancia.dataset.attempted === 'true'));
      setTestResult('', false);
    });
  }
  if (instanciaTest) {
    instanciaTest.addEventListener('click', function () {
      var authType = instanciaAuthType.value || 'basic';
      var baseUrl = instanciaBaseUrl.value.trim();
      if (baseUrl === '') {
        setTestResult('Base URL requerida.', false);
        return;
      }
      if (authType === 'basic' && (instanciaUser.value.trim() === '' || instanciaPass.value.trim() === '')) {
        setTestResult('Usuario y password requeridos.', false);
        return;
      }
      if (authType === 'oauth2' &&
          (instanciaClientId.value.trim() === '' || instanciaClientSecret.value.trim() === '' || instanciaRefreshToken.value.trim() === '')) {
        setTestResult('Client ID, Client Secret y Refresh Token requeridos.', false);
        return;
      }

      instanciaTest.disabled = true;
      instanciaTest.classList.add('opacity-50', 'cursor-not-allowed');
      setTestResult('Probando conexion...', true);

      postJson(API_URL + '?action=test_instance', {
        base_url: instanciaBaseUrl.value,
        auth_type: authType,
        api_user: instanciaUser.value,
        api_pass: instanciaPass.value,
        oauth_client_id: instanciaClientId.value,
        oauth_client_secret: instanciaClientSecret.value,
        oauth_redirect_uri: instanciaRedirect.value,
        oauth_access_token: instanciaAccessToken.value,
        oauth_refresh_token: instanciaRefreshToken.value
      }).then(function (data) {
        var user = data.user ? (' (' + data.user + ')') : '';
        setTestResult((data.message || 'Conexion OK') + user, true);
      }).catch(function (err) {
        setTestResult(sanitizeErrorMessage(err && err.message ? err.message : ''), false);
      }).finally(function () {
        instanciaTest.disabled = false;
        instanciaTest.classList.remove('opacity-50', 'cursor-not-allowed');
      });
    });
  }

  if (btnSyncMautic) {
    btnSyncMautic.addEventListener('click', function () {
      setSyncButtonState(btnSyncMautic, true);
      setSyncResult('Sincronizando...', true);

      fetchJson(base + 'controller/mautic/SyncController.php?action=full_sync').then(function (data) {
        var total = (data.instances || []).length;
        setSyncResult('Sincronizacion OK. Instancias: ' + total + '.', true);
      }).catch(function (err) {
        setSyncResult(sanitizeSyncMessage(err && err.message ? err.message : ''), false);
      }).finally(function () {
        setSyncButtonState(btnSyncMautic, false);
      });
    });
  }

  if (btnSyncPush) {
    btnSyncPush.addEventListener('click', function () {
      setSyncButtonState(btnSyncPush, true);
      setSyncResult('Subiendo contactos...', true);

      fetchJson(base + 'controller/mautic/SyncController.php?action=push_contactos&limit=50').then(function (data) {
        var total = (data.instances || []).length;
        var created = 0;
        var updated = 0;
        (data.instances || []).forEach(function (row) {
          created += row.push.created || 0;
          updated += row.push.updated || 0;
        });
        setSyncResult('Contactos enviados. Instancias: ' + total + '. Nuevos: ' + created + ', Actualizados: ' + updated + '.', true);
      }).catch(function (err) {
        setSyncResult(sanitizeSyncMessage(err && err.message ? err.message : ''), false);
      }).finally(function () {
        setSyncButtonState(btnSyncPush, false);
      });
    });
  }

  if (btnSyncPull) {
    btnSyncPull.addEventListener('click', function () {
      setSyncButtonState(btnSyncPull, true);
      setSyncResult('Trayendo campanas...', true);

      fetchJson(base + 'controller/mautic/SyncController.php?action=pull_campanas').then(function (data) {
        var total = (data.instances || []).length;
        var campaigns = 0;
        (data.instances || []).forEach(function (row) {
          campaigns += row.pull.campaigns || 0;
        });
        setSyncResult('Campanas sincronizadas. Instancias: ' + total + '. Campanas: ' + campaigns + '.', true);
      }).catch(function (err) {
        setSyncResult(sanitizeSyncMessage(err && err.message ? err.message : ''), false);
      }).finally(function () {
        setSyncButtonState(btnSyncPull, false);
      });
    });
  }
  if (instanciaFilterEstado) {
    instanciaFilterEstado.addEventListener('change', applyInstanciaFilter);
  }
  if (segmentoFilterInstancia) {
    segmentoFilterInstancia.addEventListener('change', loadSegmentos);
  }
  if (reporteFilterInstancia) {
    reporteFilterInstancia.addEventListener('change', loadReportes);
  }
})();
