// Sincroniza la barra de scroll superior con el contenedor de tabla
(function(){
  const top = document.getElementById('tabla-scroll-top');
  const topInner = document.getElementById('tabla-scroll-top-inner');
  const body = document.getElementById('tabla-scroll');
  if (!top || !topInner || !body) return;

  function syncWidth(){
    const table = body.querySelector('table');
    if (!table) return;
    topInner.style.width = table.scrollWidth + 'px';
  }
  function linkScroll(from, to){
    let lock = false;
    from.addEventListener('scroll', ()=>{
      if (lock) return; lock = true; to.scrollLeft = from.scrollLeft; lock = false;
    });
  }
  syncWidth();
  // También después de render dinámico
  window.addEventListener('load', syncWidth);
  setTimeout(syncWidth, 500);

  linkScroll(top, body);
  linkScroll(body, top);

  // Ajustar margen izquierdo de la paginación para no quedar bajo la columna sticky
  function adjustPaginationIndent(){
    const table = body.querySelector('table');
    const pag = document.getElementById('pagination-container');
    if (!table || !pag) return;
    const firstTh = table.querySelector('thead th:first-child');
    const firstTd = table.querySelector('tbody td:first-child');
    const w = (firstTh?.getBoundingClientRect().width) || (firstTd?.getBoundingClientRect().width) || 64;
    pag.style.marginLeft = (w + 12) + 'px';
  }
  adjustPaginationIndent();
  window.addEventListener('resize', adjustPaginationIndent);
  setTimeout(adjustPaginationIndent, 400);
})();
