// Tabla de clientes con Tabulator (paginación remota + acciones)
(function(){
  const cont = document.getElementById('clientes-table');
  if (!cont || typeof Tabulator === 'undefined') return;

  const pageSize = parseInt(document.getElementById('rowsPerPage')?.value || '10', 10);

  function recogerFiltros(){
    const txt = (document.getElementById('texto-buscar')?.value||'').trim().toLowerCase();
    const campo = document.getElementById('filtro-por')?.value||'';
    const tipo = document.getElementById('filtro-tipo-cliente')?.value||'';
    const status = document.getElementById('filtro-status')?.value||'';
    const origen = document.getElementById('filtro-origen')?.value||'';
    const spanDesde = document.getElementById('fecha-desde');
    const spanHasta = document.getElementById('fecha-hasta');
    const desde = (spanDesde?.textContent||'').replace('Desde: ','');
    const hasta = (spanHasta?.textContent||'').replace('Hasta: ','');
    const tipoFecha = document.querySelector('input[name="tipoFecha"]:checked');
    return {
      filtrarPorFecha: !!(desde && hasta),
      fechaAviso: !!(tipoFecha && tipoFecha.value === 'aviso'),
      desde, hasta,
      tipoCliente: tipo,
      statusAtencion: status,
      origen,
      texto: txt,
      campoTexto: campo,
    };
  }

  const table = new Tabulator('#clientes-table', {
    layout: 'fitDataStretch',
    height: '65vh',
    ajaxURL: base + 'controller/cliente/obtener_lista.php',
    ajaxContentType: 'json',
    pagination: true,
    paginationMode: 'remote',
    paginationSize: pageSize,
    paginationElement: document.getElementById('pagination-container'),
    // Mapear nombres del backend
    paginationDataReceived: {
      last_page: 'totalPaginas',
      data: 'clientes',
      last_row: 'totalClientes',
    },
    ajaxURLGenerator: function(url, config, params){
      const u = new URL(url, window.location.origin);
      u.searchParams.set('page', params.page);
      u.searchParams.set('limit', params.size);
      return u.toString();
    },
    ajaxRequestFunc: function(url, config, params){
      const filtros = recogerFiltros();
      // Debug
      // console.debug('Tabulator fetch ->', url, filtros);
      return fetch(url, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(filtros)
      })
      .then(async (r) => {
        const text = await r.text();
        try { return JSON.parse(text); } catch (e) {
          console.error('Respuesta no JSON desde obtener_lista.php', text);
          return { clientes: [], totalPaginas: 1, totalClientes: 0 };
        }
      })
      .catch(err => {
        console.error('Error de red Tabulator:', err);
        return { clientes: [], totalPaginas: 1, totalClientes: 0 };
      });
    },
    ajaxResponse: function(url, params, resp){
      // Adaptar al formato que Tabulator espera
      return {
        data: resp?.clientes || [],
        last_page: resp?.totalPaginas || 1,
        last_row: resp?.totalClientes || (resp?.clientes?.length || 0),
      };
    },
    columns: [
      { title: 'Acciones', field: 'acciones', width: 120, hozAlign: 'center', headerHozAlign:'center', formatter: function(cell){
          const id = cell.getRow().getData().idcliente;
          return `<div class="flex items-center gap-1 justify-center">
            <button class="px-2 py-1 bg-blue-600 text-white rounded" onclick="window.abrirModalEditar(${id})" title="Editar">Editar</button>
          </div>`;
        }
      },
      { title: 'N°', field: 'idcliente', width: 80, hozAlign:'center' },
      { title: 'Usuario', field: 'usuario', width: 160 },
      { title: 'F. Atención', field: 'data_created', width: 130 },
      { title: 'Razón Comercial', field: 'empresa', width: 180 },
      { title: 'Razón Social', field: 'razon', width: 180 },
      { title: 'Rubro', field: 'rubro', width: 140 },
      { title: 'Tipo Cliente', field: 'tipo_cliente', width: 140 },
      { title: 'Origen', field: 'origen_nombre', width: 140 },
      { title: 'Estado', field: 'estado_cliente', width: 140 },
      { title: 'Atención', field: 'estado_atencion', width: 140 },
      { title: 'Nombres', field: 'nombres', width: 160 },
      { title: 'Apellidos', field: 'apellidos', width: 160 },
      { title: 'Cargo', field: 'cargo', width: 140 },
      { title: 'Teléfonos', field: 'telefono', width: 160 },
      { title: 'RUC', field: 'ruc', width: 140 },
      { title: 'Email', field: 'email', width: 220 },
      { title: 'Web', field: 'web', width: 160 },
      { title: 'Dirección Oficina', field: 'direccion_oficina', width: 220 },
      { title: 'Distrito', field: 'distrito', width: 160 },
      { title: 'Ciudad', field: 'ciudad', width: 160 },
      { title: 'Cumpleaños', field: 'cumpleanios', width: 130 },
      { title: 'Aniversario', field: 'aniversario', width: 130 },
    ],
  });

  // Eventos de depuración y UX
  table.on('dataLoaded', function(data){
    // console.debug('Tabulator dataLoaded:', data?.length);
    try {
      const total = table.getDataCount('active');
      const span = document.getElementById('cantidad-registros');
      if (span) span.textContent = String(document.getElementById('rowsPerPage')?.value || '10');
    } catch(_){}
  });
  table.on('ajaxError', function(xhr, textStatus, errorThrown){
    console.error('Tabulator ajaxError:', textStatus || errorThrown, xhr?.responseText);
  });

  // Controles externos
  document.getElementById('rowsPerPage')?.addEventListener('change', (e)=>{
    const size = parseInt(e.target.value,10)||10;
    table.setPageSize(size);
  });
  ['texto-buscar','filtro-por','filtro-tipo-cliente','filtro-status','filtro-origen'].forEach(id=>{
    const el = document.getElementById(id);
    if (!el) return;
    el.addEventListener('change', ()=> table.setData());
    el.addEventListener('keyup', (ev)=>{ if (ev.key === 'Enter') table.setData(); });
  });
  // Rango de fechas: cuando script.js actualiza spans, el usuario puede presionar enter en input o cambiamos al hacer blur
  const fechaRango = document.getElementById('fecha-rango');
  fechaRango?.addEventListener('change', ()=> setTimeout(()=>table.setData(), 0));

  // Primer render
  setTimeout(()=> table.setData(), 0);
})();
