(function(){
  function $(id){ return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function(){ var p=location.pathname.split('/'); return p[1] ? ('/'+p[1]+'/') : '/'; })();
  var ctrl = baseGuess + 'controller/empresa/empresa.php';
  var paginacion = window.empPaginacion || window.paginacion;
  var expandedRow = null;
  var expandedEmpresaId = null;
  var contactsCache = {};
  var empresaNameById = {};

  function escapeHtml(s){
    return String(s || '').replace(/[&<>"]/g, function(c){ return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'})[c] || c; });
  }

  function fetchJson(url, options){
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function(res){ return res.text(); })
      .then(function(text){
        var t = text.replace(/^\uFEFF/, '');
        try { return JSON.parse(t); } catch (e) {
          var idxObj = t.indexOf('{');
          var idxArr = t.indexOf('[');
          var start = (idxObj === -1) ? idxArr : (idxArr === -1 ? idxObj : Math.min(idxObj, idxArr));
          var end = Math.max(t.lastIndexOf('}'), t.lastIndexOf(']'));
          if (start === -1 || end === -1 || end <= start) throw e;
          return JSON.parse(t.slice(start, end + 1));
        }
      });
  }

  function collapseContacts(){
    if(expandedRow && expandedRow.parentNode){ expandedRow.parentNode.removeChild(expandedRow); }
    expandedRow = null;
    expandedEmpresaId = null;
    updateToggleButtons();
  }

  function updateToggleButtons(){
    var buttons = document.querySelectorAll('.btn-toggle-contactos');
    buttons.forEach(function(btn){
      var id = btn.getAttribute('data-id');
      btn.textContent = (id && id === expandedEmpresaId) ? 'Ocultar Contactos' : 'Ver Contactos';
    });
  }

  function renderRows(rows, message){
    var tbody = $('tbodyEmpresas');
    if(!tbody) return;
    if(message){
      tbody.innerHTML = '<tr><td class="px-2 py-1 text-gray-500 text-xs" colspan="8">'+escapeHtml(message)+'</td></tr>';
      return;
    }
    if(!rows || !rows.length){
      tbody.innerHTML = '<tr><td class="px-2 py-1 text-gray-500 text-xs" colspan="8">Sin datos</td></tr>';
      return;
    }
    var html = '';
    empresaNameById = {};
    rows.forEach(function(r){
      var displayName = r.nombre_comercial || r.razon_social || r.ruc || ('Empresa #' + r.id);
      empresaNameById[String(r.id)] = displayName;
      html += '<tr data-emp-id="'+escapeHtml(r.id)+'">'
           +  '<td class="px-2 py-1">'+escapeHtml(r.id)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.ruc)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.nombre_comercial)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.razon_social)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.rubro)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.telefono)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.email)+'</td>'
           +  '<td class="px-2 py-1">'
           +    '<button class="btn-toggle-contactos bg-blue-500 text-white text-xs px-2 py-1 rounded mr-1" data-id="'+escapeHtml(r.id)+'">Ver Contactos</button>'
           +    '<button class="btn-edit bg-yellow-500 text-white text-xs px-2 py-1 rounded mr-1" data-id="'+escapeHtml(r.id)+'"><i class="fas fa-pen"></i></button>'
           +    '<button class="btn-delete bg-red-600 text-white text-xs px-2 py-1 rounded" data-id="'+escapeHtml(r.id)+'"><i class="fas fa-trash"></i></button>'
           +  '</td>'
           + '</tr>';
    });
    tbody.innerHTML = html;
    bindRowActions();
    updateToggleButtons();
  }

  function buildListUrl(){
    var q = ($('emp-q') && $('emp-q').value || '').trim();
    var by = ($('emp-search-by') && $('emp-search-by').value) || 'todos';
    var params = new URLSearchParams();
    params.set('action', 'list');
    params.set('q', q);
    params.set('by', by);
    params.set('page', paginacion ? paginacion.currentPage : 1);
    params.set('limit', paginacion ? paginacion.rowsPerPage : 25);
    return ctrl + '?' + params.toString();
  }

  function loadEmpresas(){
    var url = buildListUrl();
    fetchJson(url)
      .then(function(js){
        if(!js || js.success !== true){
          renderRows([], (js && js.message) || 'No se pudo procesar la solicitud.');
          return;
        }
        renderRows(js.data || []);
        var total = parseInt(js.total || 0, 10);
        var totalEl = $('totalEmpresas'); if (totalEl) totalEl.textContent = 'Total: ' + total;
        if (paginacion) {
          paginacion.updatePaginationInfo(total);
          paginacion.renderPaginationControls();
        }
      })
      .catch(function(){
        renderRows([], 'No se pudo procesar la solicitud.');
      });
  }

  function bindRowActions(){
    var btnsToggle = document.querySelectorAll('.btn-toggle-contactos');
    btnsToggle.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        var id = this.getAttribute('data-id');
        if(!id) return;
        if(expandedEmpresaId === id){
          collapseContacts();
          return;
        }
        collapseContacts();
        expandedEmpresaId = id;
        var tr = this.closest('tr');
        if(!tr || !tr.parentNode) return;
        var loading = document.createElement('tr');
        loading.className = 'contactos-row bg-gray-50';
        loading.innerHTML = '<td colspan="8" class="px-4 py-3 text-sm text-gray-500">Cargando contactos...</td>';
        tr.parentNode.insertBefore(loading, tr.nextSibling);
        expandedRow = loading;
        updateToggleButtons();

        if(contactsCache[id]){
          renderContactsBlock(id, contactsCache[id]);
          return;
        }
        fetchJson(ctrl + '?action=list_contactos&empresa_id=' + encodeURIComponent(id))
          .then(function(js){
            if(expandedEmpresaId !== id) return;
            if(!js || js.success !== true){
              loading.innerHTML = '<td colspan="8" class="px-4 py-3 text-sm text-red-600">No se pudieron cargar los contactos.</td>';
              return;
            }
            var data = js.data || [];
            contactsCache[id] = data;
            renderContactsBlock(id, data);
          })
          .catch(function(){
            if(expandedEmpresaId !== id) return;
            loading.innerHTML = '<td colspan="8" class="px-4 py-3 text-sm text-red-600">Error al cargar contactos.</td>';
          });
      });
    });

    var btnsEdit = document.querySelectorAll('.btn-edit');
    btnsEdit.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        openEditEmpresa(this.getAttribute('data-id'));
      });
    });

    var btnsDelete = document.querySelectorAll('.btn-delete');
    btnsDelete.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        confirmDeleteEmpresa(this.getAttribute('data-id'));
      });
    });
  }

  function renderContactsBlock(empresaId, rows){
    if(!expandedRow) return;
    var html = '<td colspan="8" class="contactos-cell bg-gray-50 px-3 py-3" style="white-space: normal; overflow: visible;">';
    html += '<div class="border border-gray-200 rounded-md bg-white">';
    html += '<div class="flex items-center justify-between px-4 py-2 bg-gray-100 rounded-t-md">';
    html += '<div class="text-sm font-semibold text-gray-800">Contactos de Empresa #' + escapeHtml(empresaId) + '</div>';
    html += '<button class="btn-new-contact bg-green-600 text-white text-xs px-2 py-1 rounded" data-emp-id="'+escapeHtml(empresaId)+'"><i class="fas fa-plus"></i> Nuevo Contacto</button>';
    html += '</div>';
    if(!rows || !rows.length){
      html += '<div class="px-4 py-3 text-sm text-gray-500">Sin contactos registrados.</div>';
    } else {
      html += '<div class="overflow-x-auto">';
      html += '<table class="min-w-full text-xs">';
      html += '<thead class="bg-gray-800 text-white"><tr>'
           + '<th class="px-3 py-2 text-left">ID</th>'
           + '<th class="px-3 py-2 text-left">Nombres</th>'
           + '<th class="px-3 py-2 text-left">Apellidos</th>'
           + '<th class="px-3 py-2 text-left">Celular</th>'
           + '<th class="px-3 py-2 text-left">Email</th>'
           + '<th class="px-3 py-2 text-left">Acciones</th>'
           + '</tr></thead>';
      html += '<tbody class="divide-y divide-gray-200">';
      rows.forEach(function(r){
        html += '<tr>'
             + '<td class="px-3 py-2">'+escapeHtml(r.id)+'</td>'
             + '<td class="px-3 py-2">'+escapeHtml(r.nombres)+'</td>'
             + '<td class="px-3 py-2">'+escapeHtml(r.apellidos)+'</td>'
             + '<td class="px-3 py-2">'+escapeHtml(r.celular)+'</td>'
             + '<td class="px-3 py-2">'+escapeHtml(r.email)+'</td>'
             + '<td class="px-3 py-2">'
             +   '<button class="btn-edit-contact text-yellow-600 hover:text-yellow-800 mr-2" data-id="'+escapeHtml(r.id)+'"><i class="fas fa-pen"></i></button>'
             +   '<button class="btn-delete-contact text-red-600 hover:text-red-800" data-id="'+escapeHtml(r.id)+'"><i class="fas fa-trash"></i></button>'
             + '</td>'
             + '</tr>';
      });
      html += '</tbody></table></div>';
    }
    html += '</div></td>';
    expandedRow.innerHTML = html;
    bindContactActions(empresaId);
  }

  function bindContactActions(empresaId){
    var btnNew = expandedRow.querySelector('.btn-new-contact');
    if(btnNew){
      btnNew.addEventListener('click', function(ev){
        ev.stopPropagation();
        openNewContacto(empresaId);
      });
    }
    var btnEdit = expandedRow.querySelectorAll('.btn-edit-contact');
    btnEdit.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        openEditContacto(this.getAttribute('data-id'));
      });
    });
    var btnDelete = expandedRow.querySelectorAll('.btn-delete-contact');
    btnDelete.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        confirmDeleteContacto(this.getAttribute('data-id'));
      });
    });
  }

  function openEmpresaModal(){
    var modal = $('empresaModal');
    if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); }
  }
  function closeEmpresaModal(){
    var modal = $('empresaModal');
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
  }
  function openContactoModal(){
    var modal = $('contactoQuickModal');
    if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); }
  }
  function closeContactoModal(){
    var modal = $('contactoQuickModal');
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
  }

  function setActiveTab(tab){
    var tabs = ['empresa','direccion','otros'];
    tabs.forEach(function(t){
      var el = $('tab-' + t);
      if(el){ el.classList.toggle('hidden', t !== tab); }
    });
    var btns = document.querySelectorAll('.emp-tab-btn');
    btns.forEach(function(btn){
      var isActive = btn.getAttribute('data-tab') === tab;
      btn.classList.toggle('bg-primary', isActive);
      btn.classList.toggle('text-white', isActive);
      btn.classList.toggle('bg-gray-200', !isActive);
    });
  }

  function clearEmpresaForm(){
    var ids = [
      'e_id','e_ruc','e_nombre_comercial','e_razon_social','e_rubro','e_tipo_empresa',
      'e_n_trabajadores','e_estado_contribuyente','e_condicion_contribuyente','e_country_id',
      'e_department_id','e_province_id','e_district_id','e_direccion','e_referencia','e_telefono',
      'e_celular','e_email','e_website','e_origen','e_aniversario','e_politica_pago',
      'e_procedimiento_especial','e_frecuencia_compra','e_adicionales'
    ];
    ids.forEach(function(id){ var el=$(id); if(el) el.value=''; });
    var cb = $('e_trabaja_con_proveedores'); if(cb) cb.checked = false;
    var country = $('e_country_id'); if(country) country.value = 'PE';
    renderEmpresaHistorial([]);
  }

  function fillEmpresaForm(data){
    $('e_id').value = data.id || '';
    $('e_ruc').value = data.ruc || '';
    $('e_nombre_comercial').value = data.nombre_comercial || '';
    $('e_razon_social').value = data.razon_social || '';
    $('e_rubro').value = data.rubro || '';
    $('e_tipo_empresa').value = data.tipo_empresa || '';
    $('e_n_trabajadores').value = data.n_trabajadores || '';
    $('e_estado_contribuyente').value = data.estado_contribuyente || '';
    $('e_condicion_contribuyente').value = data.condicion_contribuyente || '';
    $('e_country_id').value = data.country_id || 'PE';
    $('e_department_id').value = data.department_id || '';
    $('e_province_id').value = data.province_id || '';
    $('e_district_id').value = data.district_id || '';
    $('e_direccion').value = data.direccion || '';
    $('e_referencia').value = data.referencia || '';
    $('e_telefono').value = data.telefono || '';
    $('e_celular').value = data.celular || '';
    $('e_email').value = data.email || '';
    $('e_website').value = data.website || '';
    $('e_origen').value = data.origen || '';
    $('e_aniversario').value = data.aniversario || '';
    $('e_politica_pago').value = data.politica_pago || '';
    $('e_procedimiento_especial').value = data.procedimiento_especial || '';
    $('e_frecuencia_compra').value = data.frecuencia_compra || '';
    $('e_adicionales').value = data.adicionales || '';
    var cb = $('e_trabaja_con_proveedores');
    if(cb) cb.checked = (parseInt(data.trabaja_con_proveedores || 0, 10) === 1);
  }

  function collectEmpresaForm(){
    return {
      id: $('e_id').value,
      ruc: $('e_ruc').value.trim(),
      nombre_comercial: $('e_nombre_comercial').value.trim(),
      razon_social: $('e_razon_social').value.trim(),
      rubro: $('e_rubro').value.trim(),
      tipo_empresa: $('e_tipo_empresa').value,
      n_trabajadores: $('e_n_trabajadores').value,
      estado_contribuyente: $('e_estado_contribuyente').value,
      condicion_contribuyente: $('e_condicion_contribuyente').value,
      country_id: $('e_country_id').value.trim(),
      department_id: $('e_department_id').value.trim(),
      province_id: $('e_province_id').value.trim(),
      district_id: $('e_district_id').value.trim(),
      direccion: $('e_direccion').value.trim(),
      referencia: $('e_referencia').value.trim(),
      telefono: $('e_telefono').value.trim(),
      celular: $('e_celular').value.trim(),
      email: $('e_email').value.trim(),
      website: $('e_website').value.trim(),
      origen: $('e_origen').value.trim(),
      aniversario: $('e_aniversario').value,
      politica_pago: $('e_politica_pago').value.trim(),
      procedimiento_especial: $('e_procedimiento_especial').value.trim(),
      frecuencia_compra: $('e_frecuencia_compra').value.trim(),
      adicionales: $('e_adicionales').value.trim(),
      trabaja_con_proveedores: $('e_trabaja_con_proveedores').checked ? 1 : 0
    };
  }

  function renderEmpresaHistorial(rows){
    var container = $('empresaHistorialContainer');
    if (!container) return;
    if (!rows || !rows.length) {
      container.innerHTML = '<div class="text-xs text-gray-500">Sin movimientos</div>';
      return;
    }
    var html = '';
    rows.forEach(function(r){
      var nombre = r.usuario || ((r.nombres || '') + ' ' + (r.apellidos || '')).trim();
      var tipo = (r.tipo_actividad === 'creacion') ? 'Creacion' : 'Actualizacion';
      var fecha = r.fecha || '';
      html += '<div class="border-b border-gray-200 pb-2 mb-2 last:border-b-0 last:pb-0 last:mb-0">'
           +  '<div class="text-gray-800">'+escapeHtml(tipo)+'</div>'
           +  '<div class="text-gray-600">Usuario: '+escapeHtml(nombre || ('ID ' + r.usuario_id))+'</div>'
           +  '<div class="text-gray-500">'+escapeHtml(fecha)+'</div>'
           + '</div>';
    });
    container.innerHTML = html;
  }

  function openNewEmpresa(){
    clearEmpresaForm();
    setActiveTab('empresa');
    $('empresaModalTitle').textContent = 'Nueva Empresa';
    openEmpresaModal();
  }

  function openEditEmpresa(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){
        if(!js || !js.success){ Swal.fire({icon:'error', text:'No se pudo cargar la empresa'}); return; }
        clearEmpresaForm();
        fillEmpresaForm(js.data || {});
        renderEmpresaHistorial(js.historial || []);
        setActiveTab('empresa');
        $('empresaModalTitle').textContent = 'Editar Empresa';
        openEmpresaModal();
      });
  }

  function saveEmpresa(){
    var payload = collectEmpresaForm();
    if(!payload.ruc || !payload.razon_social){
      Swal.fire({icon:'warning', text:'RUC y Razón Social son obligatorios.'});
      return;
    }
    var isEdit = payload.id && payload.id !== '';
    var action = isEdit ? 'update' : 'create';
    fetchJson(ctrl + '?action=' + action, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    }).then(function(js){
      if(js && js.success){
        Swal.fire({icon:'success', title:'Listo', text:js.message || 'Guardado'});
        closeEmpresaModal();
        loadEmpresas();
      } else {
        Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo guardar'});
      }
    }).catch(function(){
      Swal.fire({icon:'error', text:'Error al guardar'});
    });
  }

  function confirmDeleteEmpresa(id){
    if(!id) return;
    Swal.fire({ icon:'warning', title:'Eliminar empresa', text:'¿Desea eliminar este registro?', showCancelButton:true, confirmButtonText:'Si, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDeleteEmpresa(id); });
  }

  function doDeleteEmpresa(id){
    fetchJson(ctrl + '?action=delete', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ id: id })
    }).then(function(js){
      if(js && js.success){
        Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false});
        collapseContacts();
        loadEmpresas();
      } else {
        Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo eliminar'});
      }
    });
  }

  function clearContactoForm(){
    ['contacto-id','contacto-empresa-id','contacto-empresa-nombre','contacto-nombres','contacto-apellidos','contacto-celular','contacto-email','contacto-num-doc','contacto-origen'].forEach(function(id){
      var el=$(id); if(el) el.value='';
    });
  }

  function setContactoEmpresa(empresaId){
    var idVal = empresaId ? String(empresaId) : '';
    var nombre = empresaNameById[idVal] || (idVal ? ('Empresa #' + idVal) : '');
    var inputNombre = $('contacto-empresa-nombre');
    var inputId = $('contacto-empresa-id');
    if(inputNombre) inputNombre.value = nombre;
    if(inputId) inputId.value = idVal;
  }

  function fillContactoForm(data){
    $('contacto-id').value = data.id || '';
    setContactoEmpresa(data.empresa_id || '');
    $('contacto-nombres').value = data.nombres || '';
    $('contacto-apellidos').value = data.apellidos || '';
    $('contacto-celular').value = data.celular || '';
    $('contacto-email').value = data.email || '';
  }

  function openNewContacto(empresaId){
    clearContactoForm();
    setContactoEmpresa(empresaId);
    $('contactoQuickTitle').textContent = 'Nuevo Contacto';
    openContactoModal();
  }

  function openEditContacto(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get_contacto&id=' + encodeURIComponent(id))
      .then(function(js){
        if(!js || !js.success){ Swal.fire({icon:'error', text:'No se pudo cargar el contacto'}); return; }
        clearContactoForm();
        fillContactoForm(js.data || {});
        $('contactoQuickTitle').textContent = 'Editar Contacto';
        openContactoModal();
      });
  }

  function saveContacto(){
    var payload = {
      id: $('contacto-id').value,
      empresa_id: $('contacto-empresa-id').value,
      nombres: $('contacto-nombres').value.trim(),
      apellidos: $('contacto-apellidos').value.trim(),
      celular: $('contacto-celular').value.trim(),
      email: $('contacto-email').value.trim(),
      num_doc: $('contacto-num-doc').value.trim(),
      origen: $('contacto-origen').value.trim()
    };
    if(!payload.nombres){
      Swal.fire({icon:'warning', text:'Nombres es obligatorio.'});
      return;
    }
    if(!payload.origen){
      Swal.fire({icon:'warning', text:'Origen es obligatorio.'});
      return;
    }
    var isEdit = payload.id && payload.id !== '';
    var action = isEdit ? 'update_contacto' : 'create_contacto';
    fetchJson(ctrl + '?action=' + action, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    }).then(function(js){
      if(js && js.success){
        Swal.fire({icon:'success', title:'Listo', text:js.message || 'Guardado'});
        closeContactoModal();
        if(payload.empresa_id){
          delete contactsCache[payload.empresa_id];
          if(expandedEmpresaId === payload.empresa_id){
            fetchJson(ctrl + '?action=list_contactos&empresa_id=' + encodeURIComponent(payload.empresa_id))
              .then(function(resp){
                if(resp && resp.success){
                  contactsCache[payload.empresa_id] = resp.data || [];
                  renderContactsBlock(payload.empresa_id, resp.data || []);
                }
              });
          }
        }
      } else {
        Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo guardar'});
      }
    }).catch(function(){
      Swal.fire({icon:'error', text:'Error al guardar'});
    });
  }

  function confirmDeleteContacto(id){
    if(!id) return;
    Swal.fire({ icon:'warning', title:'Eliminar contacto', text:'¿Desea eliminar este contacto?', showCancelButton:true, confirmButtonText:'Si, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDeleteContacto(id); });
  }

  function doDeleteContacto(id){
    fetchJson(ctrl + '?action=delete_contacto', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ id: id })
    }).then(function(js){
      if(js && js.success){
        Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false});
        if(expandedEmpresaId){
          delete contactsCache[expandedEmpresaId];
          fetchJson(ctrl + '?action=list_contactos&empresa_id=' + encodeURIComponent(expandedEmpresaId))
            .then(function(resp){
              if(resp && resp.success){
                contactsCache[expandedEmpresaId] = resp.data || [];
                renderContactsBlock(expandedEmpresaId, resp.data || []);
              }
            });
        }
      } else {
        Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo eliminar'});
      }
    });
  }

  function bindUI(){
    var btnNuevo = $('btnNuevo');
    if(btnNuevo) btnNuevo.addEventListener('click', openNewEmpresa);
    var btnBuscar = $('btnBuscar');
    if(btnBuscar) btnBuscar.addEventListener('click', function(){ if(paginacion) paginacion.currentPage = 1; loadEmpresas(); });
    var q = $('emp-q');
    if(q) q.addEventListener('keydown', function(e){ if(e.key === 'Enter'){ e.preventDefault(); if(paginacion) paginacion.currentPage = 1; loadEmpresas(); } });
    var btnClear = $('btnClearSearch');
    if(btnClear) btnClear.addEventListener('click', function(){ if(q) q.value=''; if(paginacion) paginacion.currentPage = 1; loadEmpresas(); });
    var sel = $('pageSize');
    if(sel && paginacion){
      sel.addEventListener('change', function(){ paginacion.updateRowsPerPage(parseInt(this.value || '25', 10)); });
    }

    var closeBtn = $('btnCloseEmpresaModal');
    if(closeBtn) closeBtn.addEventListener('click', closeEmpresaModal);
    var cancelBtn = $('btnCancelarEmpresa');
    if(cancelBtn) cancelBtn.addEventListener('click', closeEmpresaModal);
    var saveBtn = $('btnGuardarEmpresa');
    if(saveBtn) saveBtn.addEventListener('click', saveEmpresa);

    var closeContactBtn = $('btnContactoQuickClose');
    if(closeContactBtn) closeContactBtn.addEventListener('click', closeContactoModal);
    var cancelContactBtn = $('btnContactoQuickCancel');
    if(cancelContactBtn) cancelContactBtn.addEventListener('click', closeContactoModal);
    var saveContactBtn = $('btnContactoQuickSave');
    if(saveContactBtn) saveContactBtn.addEventListener('click', saveContacto);

    var tabButtons = document.querySelectorAll('.emp-tab-btn');
    tabButtons.forEach(function(btn){
      btn.addEventListener('click', function(){ setActiveTab(this.getAttribute('data-tab')); });
    });
  }

  window.reloadEmpresasTable = loadEmpresas;
  document.addEventListener('DOMContentLoaded', function(){
    bindUI();
    if(paginacion){
      paginacion.renderFunction = function(){ loadEmpresas(); };
    }
    loadEmpresas();
  });
})();
