const tbody = document.querySelector('#tabla-cumpleaneros tbody');
const paginacion = document.getElementById('paginacion');
const filtroMes = document.getElementById('filtro-mes');
const inputBuscar = document.getElementById('buscar');
const selectPageSize = document.getElementById('page-size');
const modal = document.getElementById('modal-cumpleanios');
const form = modal?.querySelector('#form-cumpleanios');
const btnCerrar = modal?.querySelector('#btn-cerrar-modal');
const btnCerrar2 = modal?.querySelector('#btn-cerrar-modal-2');
const inputFecha = form?.querySelector('input[name="cumpleanios"]');
const textAcciones = form?.querySelector('textarea[name="accionescliente"]');
const infoRazon = modal?.querySelector('#info-razon');
const infoContacto = modal?.querySelector('#info-contacto');
const infoFecha = modal?.querySelector('#info-fecha');

let allRows = [];
let filtered = [];
let page = 1;
let pageSize = parseInt(selectPageSize?.value || '25', 10);
const meses = ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];

function formatear(fecha) {
  if (!fecha) return '';
  const d = new Date(fecha);
  if (Number.isNaN(d.getTime())) return fecha;
  return `${d.getDate().toString().padStart(2,'0')}/${meses[d.getMonth()]}`;
}

function switchModal(open = false) {
  if (!modal) return;
  modal.classList.toggle('hidden', !open);
  modal.classList.toggle('flex', open);
}

function renderTabla() {
  tbody.innerHTML = '';
  const start = (page - 1) * pageSize;
  const slice = filtered.slice(start, start + pageSize);
  slice.forEach((c) => {
    const tr = document.createElement('tr');
    tr.className = 'hover:bg-gray-50';
    tr.innerHTML = `
      <td class="px-4 py-2 text-xs">${c.idcliente || ''}</td>
      <td class="px-4 py-2 text-xs">${c.razon || ''}</td>
      <td class="px-4 py-2 text-xs">${(c.nombres || '') + ' ' + (c.apellidos || '')}</td>
      <td class="px-4 py-2 text-xs">${c.cargo || ''}</td>
      <td class="px-4 py-2 text-xs">${formatear(c.cumpleanios)}</td>
      <td class="px-4 py-2 text-xs">${formatear(c.aniversario)}</td>
      <td class="px-4 py-2 text-xs">
        <div class="flex items-center gap-2">
          <span class="inline-block truncate max-w-[240px]" title="${c.accionescliente || ''}">${c.accionescliente || ''}</span>
          <button class="bg-blue-500 text-white px-2 py-1 rounded text-xs hover:bg-blue-600" data-id="${c.idcliente}">Editar</button>
        </div>
      </td>
    `;
    const btn = tr.querySelector('button');
    if (btn) {
      btn.addEventListener('click', () => {
        if (form) form.dataset.id = c.idcliente;
        if (textAcciones) textAcciones.value = c.accionescliente || '';
        if (infoRazon) infoRazon.textContent = c.razon || '-';
        if (infoContacto) infoContacto.textContent = `${c.nombres || ''} ${c.apellidos || ''}`.trim() || '-';
        if (infoFecha) infoFecha.textContent = `Cumpleaños: ${c.cumpleanios ? c.cumpleanios.split(' ')[0] : '-'}`;
        if (inputFecha) {
          inputFecha.value = c.cumpleanios ? c.cumpleanios.split(' ')[0] : '';
          if (inputFecha._flatpickr) inputFecha._flatpickr.setDate(c.cumpleanios, true);
        }
        switchModal(true);
      });
    }
    tbody.appendChild(tr);
  });
  renderPaginacion();
}

function renderPaginacion() {
  const total = filtered.length;
  const totalPages = Math.max(1, Math.ceil(total / pageSize));
  page = Math.min(page, totalPages);
  paginacion.innerHTML = '';
  const info = document.createElement('span');
  info.textContent = `Página ${page} de ${totalPages} (${total} registros)`;
  paginacion.appendChild(info);

  const controls = document.createElement('div');
  controls.className = 'flex items-center gap-1';
  const mkBtn = (label, targetPage, disabled=false) => {
    const b = document.createElement('button');
    b.textContent = label;
    b.className = `px-2 py-1 rounded border text-xs ${disabled?'text-gray-400 border-gray-200':'text-primary border-primary'}`;
    b.disabled = disabled;
    if (!disabled) b.addEventListener('click', () => { page = targetPage; renderTabla(); });
    return b;
  };
  controls.appendChild(mkBtn('«', Math.max(1, page-1), page===1));
  for (let p = Math.max(1, page-2); p <= Math.min(totalPages, page+2); p++) {
    const b = mkBtn(p, p, p===page);
    if (p===page) b.classList.add('bg-primary','text-white');
    controls.appendChild(b);
  }
  controls.appendChild(mkBtn('»', Math.min(totalPages, page+1), page===totalPages));
  paginacion.appendChild(controls);
}

function aplicarFiltros() {
  const mes = parseInt(filtroMes?.value || '0', 10);
  const term = (inputBuscar?.value || '').toLowerCase();
  filtered = allRows.filter(c => {
    const cumpleMes = c.cumpleanios ? (new Date(c.cumpleanios).getMonth() + 1) : null;
    const anivMes = c.aniversario ? (new Date(c.aniversario).getMonth() + 1) : null;
    const mesOk = mes === 0 || cumpleMes === mes || anivMes === mes;
    const texto = `${c.razon || ''} ${c.nombres || ''} ${c.apellidos || ''} ${c.cargo || ''}`.toLowerCase();
    const termOk = term === '' || texto.includes(term);
    return mesOk && termOk;
  });
  page = 1;
  renderTabla();
}

function cargarDatos() {
  fetch('../../controller/cliente/cumpleanios-aniversario.php')
    .then(r => r.json())
    .then(resp => {
      if (resp.success && Array.isArray(resp.data)) {
        allRows = resp.data;
        filtered = allRows.slice();
        renderTabla();
      }
    })
    .catch(() => {});
}

selectPageSize?.addEventListener('change', () => {
  pageSize = parseInt(selectPageSize.value, 10);
  page = 1;
  renderTabla();
});
filtroMes?.addEventListener('change', aplicarFiltros);
inputBuscar?.addEventListener('input', aplicarFiltros);
btnCerrar?.addEventListener('click', () => switchModal(false));
btnCerrar2?.addEventListener('click', () => switchModal(false));

form?.addEventListener('submit', async e => {
  e.preventDefault();
  const id = form.dataset.id;
  if (!id) return;
  const data = new FormData(form);
  try {
    const resp = await fetch(`../../controller/cliente/actualizar-acc-cumple.php?id=${id}`, { method: 'POST', body: data });
    const json = await resp.json();
    if (json.success) {
      switchModal(false);
      cargarDatos();
    } else {
      alert(json.message || 'No se pudo guardar');
    }
  } catch (err) {
    alert('Error de red');
  }
});

cargarDatos();
