(function(){
  function $(id){ return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function(){ var p=location.pathname.split('/'); return p[1] ? ('/'+p[1]+'/') : '/'; })();
  var ctrl = baseGuess + 'controller/contactos/contacto.php';
  var empresaCtrl = baseGuess + 'controller/empresa/empresa.php';
  var paginacion = window.ctPaginacion || window.paginacion;
  var columnToggles = document.querySelectorAll('.ct-col-toggle');
  var columnState = {};

  function escapeHtml(s){
    return String(s || '').replace(/[&<>"]/g, function(c){ return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'})[c] || c; });
  }

  var MONTH_NAMES = [
    'Enero','Febrero','Marzo','Abril','Mayo','Junio',
    'Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'
  ];

  function formatDatePretty(dateStr){
    var raw = String(dateStr || '').trim();
    if (!raw) return '';
    var normalized = raw.replace(' ', 'T');
    var d = new Date(normalized);
    if (Number.isNaN(d.getTime())) return raw;
    var day = String(d.getDate()).padStart(2, '0');
    var month = MONTH_NAMES[d.getMonth()] || '';
    var year = d.getFullYear();
    return day + ' ' + month + ' ' + year;
  }

  var MAX_EMAIL_CHARS = 30;

  function formatTruncated(text){
    var value = String(text || '');
    if (value.length <= MAX_EMAIL_CHARS) {
      return { text: escapeHtml(value), title: '' };
    }
    var short = value.slice(0, MAX_EMAIL_CHARS) + '...';
    return { text: escapeHtml(short), title: ' title=\"' + escapeHtml(value) + '\"' };
  }

  function fetchJson(url, options){
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function(res){ return res.text(); })
      .then(function(text){
        var t = text.replace(/^\uFEFF/, '');
        try { return JSON.parse(t); } catch (e) {
          var idxObj = t.indexOf('{');
          var idxArr = t.indexOf('[');
          var start = (idxObj === -1) ? idxArr : (idxArr === -1 ? idxObj : Math.min(idxObj, idxArr));
          var end = Math.max(t.lastIndexOf('}'), t.lastIndexOf(']'));
          if (start === -1 || end === -1 || end <= start) throw e;
          return JSON.parse(t.slice(start, end + 1));
        }
      });
  }

  function listUrl(){
    var q = ($('ct-q') && $('ct-q').value || '').trim();
    var campo = ($('ct-search-by') && $('ct-search-by').value) || 'todos';
    var params = new URLSearchParams();
    params.set('action', 'list');
    params.set('q', q);
    params.set('campo', campo);
    params.set('page', paginacion ? paginacion.currentPage : 1);
    params.set('limit', paginacion ? paginacion.rowsPerPage : 25);
    return ctrl + '?' + params.toString();
  }

  function renderRows(rows, message){
    var tbody = $('tbodyContactos');
    if(!tbody) return;
    if(message){
      tbody.innerHTML = '<tr><td class="px-2 py-1 text-gray-500 text-xs" colspan="14">'+escapeHtml(message)+'</td></tr>';
      return;
    }
    if(!rows || !rows.length){
      tbody.innerHTML = '<tr><td class="px-2 py-1 text-gray-500 text-xs" colspan="14">Sin datos</td></tr>';
      return;
    }
    var html = '';
    rows.forEach(function(r){
      var empresa = r.nombre_comercial || r.razon_social || r.ruc || '';
      var emailsText = r.emails_all || r.email || '';
      var emailCell = formatTruncated(emailsText);
      html += '<tr>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.id)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(empresa)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.nombres)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.apellidos)+'</td>'
           +  '<td class="px-2 py-1" data-col="num_doc">'+escapeHtml(r.num_doc)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.cargo)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.origen)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.celular)+'</td>'
           +  '<td class="px-2 py-1 max-w-[220px] truncate"' + emailCell.title + '>' + emailCell.text + '</td>'
           +  '<td class="px-2 py-1" data-col="tipo_contacto">'+escapeHtml(r.tipo_contacto)+'</td>'
           +  '<td class="px-2 py-1" data-col="direccion">'+escapeHtml(r.direccion)+'</td>'
           +  '<td class="px-2 py-1" data-col="referencia">'+escapeHtml(r.referencia)+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(formatDatePretty(r.updated_at || ''))+'</td>'
           +  '<td class="px-2 py-1">'+escapeHtml(r.usuario_ultimo || '')+'</td>'
           +  '<td class="px-2 py-1">'
           +    '<button class="btn-edit bg-yellow-500 text-white text-xs px-2 py-1 rounded mr-1" data-id="'+escapeHtml(r.id)+'"><i class="fas fa-pen"></i></button>'
           +    '<button class="btn-delete bg-red-600 text-white text-xs px-2 py-1 rounded" data-id="'+escapeHtml(r.id)+'"><i class="fas fa-trash"></i></button>'
           +  '</td>'
           + '</tr>';
    });
    tbody.innerHTML = html;
    bindRowActions();
    applyColumnVisibility();
  }

  function loadContactos(){
    fetchJson(listUrl())
      .then(function(js){
        if(!js || js.success !== true){
          renderRows([], (js && js.message) || 'No se pudo procesar la solicitud.');
          return;
        }
        renderRows(js.data || []);
        var total = parseInt(js.total || 0, 10);
        var totalEl = $('totalContactos'); if (totalEl) totalEl.textContent = 'Total: ' + total;
        if (paginacion) {
          paginacion.updatePaginationInfo(total);
          paginacion.renderPaginationControls();
        }
      })
      .catch(function(){ renderRows([], 'No se pudo procesar la solicitud.'); });
  }

  function bindRowActions(){
    var edits = document.querySelectorAll('.btn-edit');
    edits.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        openEdit(this.getAttribute('data-id'));
      });
    });
    var dels = document.querySelectorAll('.btn-delete');
    dels.forEach(function(btn){
      btn.addEventListener('click', function(ev){
        ev.stopPropagation();
        confirmDelete(this.getAttribute('data-id'));
      });
    });
  }

  var currentEmpresaId = '';
  var currentEmpresaLabel = '';

  function openModal(){
    var modal = $('contactoModal');
    if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); }
  }
  function closeModal(){
    var modal = $('contactoModal');
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
  }

  function openEmpresaQuick(){
    clearEmpresaQuick();
    var modal = $('empresaQuickModal');
    if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); }
  }
  function closeEmpresaQuick(){
    var modal = $('empresaQuickModal');
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
  }
  function clearEmpresaQuick(){
    ['qe_ruc','qe_razon_social','qe_nombre_comercial','qe_origen'].forEach(function(id){
      var el = $(id); if(el) el.value = '';
    });
  }
  function saveEmpresaQuick(){
    var ruc = ($('qe_ruc') && $('qe_ruc').value || '').trim();
    var razon = ($('qe_razon_social') && $('qe_razon_social').value || '').trim();
    var nombre = ($('qe_nombre_comercial') && $('qe_nombre_comercial').value || '').trim();
    var origen = ($('qe_origen') && $('qe_origen').value || '').trim();
    if(!ruc){ Swal.fire({icon:'warning', text:'RUC es requerido.'}); return; }
    if(!razon){ Swal.fire({icon:'warning', text:'Razon social es requerida.'}); return; }
    var payload = { ruc: ruc, razon_social: razon, nombre_comercial: nombre, origen: origen };
    fetchJson(empresaCtrl + '?action=create', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    }).then(function(js){
      if(js && js.success){
        setEmpresaSelection(js.id || '', buildEmpresaLabel({ ruc: ruc, razon_social: razon, nombre_comercial: nombre }));
        closeEmpresaQuick();
        Swal.fire({icon:'success', title:'Empresa creada', timer:1200, showConfirmButton:false});
      } else {
        Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo crear la empresa'});
      }
    });
  }

  function addTelefonoRow(value){
    var container = $('telefonosContainer');
    if(!container) return;
    var row = document.createElement('div');
    row.className = 'flex items-stretch gap-0';
    row.innerHTML = '<select class="border border-gray-300 px-2 py-1 rounded-l-md text-sm focus:outline-none telefono-tipo">'
                  +   '<option value="">- Tipo -</option>'
                  +   '<option value="movil">Movil</option>'
                  +   '<option value="fijo">Fijo</option>'
                  +   '<option value="casa">Casa</option>'
                  +   '<option value="trabajo">Trabajo</option>'
                  +   '<option value="otro">Otro</option>'
                  + '</select>'
                  + '<input type="text" inputmode="numeric" pattern="[0-9]*" class="border border-l-0 border-gray-300 px-2 py-1 w-full focus:outline-none telefono-extra" placeholder="Numero">'
                  + '<button type="button" class="inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0"><i class="fas fa-times"></i></button>';
    var select = row.querySelector('select');
    var input = row.querySelector('input');
    input.addEventListener('input', function(){ this.value = this.value.replace(/\D+/g, ''); });
    if(input && value){
      input.value = (typeof value === 'string') ? value : (value.telefono || '');
    }
    if(select && value && value.tipo){ select.value = value.tipo; }
    if(select && (!value || !value.tipo)){ select.value = 'movil'; }
    row.querySelector('button').addEventListener('click', function(){ row.remove(); });
    container.appendChild(row);
  }

  function addEmailRow(value){
    var container = $('emailsContainer');
    if(!container) return;
    var row = document.createElement('div');
    row.className = 'flex items-stretch gap-0';
    row.innerHTML = '<select class="border border-gray-300 px-2 py-1 rounded-l-md text-sm focus:outline-none email-tipo">'
                  +   '<option value="">- Tipo -</option>'
                  +   '<option value="trabajo">Trabajo</option>'
                  +   '<option value="personal">Personal</option>'
                  +   '<option value="casa">Casa</option>'
                  +   '<option value="otro">Otro</option>'
                  + '</select>'
                  + '<input type="email" class="border border-l-0 border-gray-300 px-2 py-1 w-full focus:outline-none email-extra" placeholder="Email">'
                  + '<button type="button" class="inline-flex items-center justify-center px-3 bg-red-600 text-white rounded-r-md rounded-l-none hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-400 border border-red-600 border-r-0"><i class="fas fa-times"></i></button>';
    var select = row.querySelector('select');
    var input = row.querySelector('input');
    if(input && value){
      input.value = (typeof value === 'string') ? value : (value.email || '');
    }
    if(select && value && value.tipo){ select.value = value.tipo; }
    if(select && (!value || !value.tipo)){ select.value = 'trabajo'; }
    row.querySelector('button').addEventListener('click', function(){ row.remove(); });
    container.appendChild(row);
  }

  function clearForm(){
    ['m_id','m_nombres','m_apellidos','m_cargo','m_num_doc','m_origen','m_tipo_contacto','m_fecha_cumpleanos','m_direccion','m_referencia','m_celular','m_telefono_fijo','m_email','m_email_tipo','m_empresa_input','m_empresa_id'].forEach(function(id){
      var el=$(id); if(el) el.value='';
    });
    if ($('m_email_tipo')) { $('m_email_tipo').value = 'trabajo'; }
    currentEmpresaId = '';
    currentEmpresaLabel = '';
    var tel = $('telefonosContainer'); if(tel) tel.innerHTML = '';
    var em = $('emailsContainer'); if(em) em.innerHTML = '';
    var hist = $('historialContainer'); if(hist) hist.innerHTML = '';
  }

  function fillForm(data){
    $('m_id').value = data.id || '';
    setEmpresaSelection(data.empresa_id || '', buildEmpresaLabel(data));
    currentEmpresaId = String(data.empresa_id || '');
    currentEmpresaLabel = buildEmpresaLabel(data);
    $('m_nombres').value = data.nombres || '';
    $('m_apellidos').value = data.apellidos || '';
    $('m_cargo').value = data.cargo || '';
    if ($('m_num_doc')) { $('m_num_doc').value = data.num_doc || ''; }
    if ($('m_origen')) { $('m_origen').value = data.origen || ''; }
    if ($('m_tipo_contacto')) { $('m_tipo_contacto').value = data.tipo_contacto || ''; }
    if ($('m_fecha_cumpleanos')) { $('m_fecha_cumpleanos').value = data.fecha_cumpleanos || ''; }
    $('m_celular').value = data.celular || '';
    $('m_telefono_fijo').value = data.telefono_fijo || '';
    $('m_email').value = data.email || '';
    if ($('m_email_tipo')) { $('m_email_tipo').value = data.email_tipo || 'trabajo'; }
    if ($('m_direccion')) { $('m_direccion').value = data.direccion || ''; }
    if ($('m_referencia')) { $('m_referencia').value = data.referencia || ''; }
    var tel = data.telefonos || [];
    var ems = data.emails || [];
    tel.forEach(function(v){
      if (typeof v === 'string') {
        addTelefonoRow({ telefono: v, tipo: 'otro' });
      } else {
        addTelefonoRow({ telefono: v.telefono || '', tipo: v.tipo || 'otro' });
      }
    });
    ems.forEach(function(v){
      if (typeof v === 'string') {
        addEmailRow({ email: v, tipo: 'personal' });
      } else {
        addEmailRow({ email: v.email || '', tipo: v.tipo || 'personal' });
      }
    });
  }

  function collectForm(){
    var telefonos = Array.from(document.querySelectorAll('#telefonosContainer > div')).map(function(row){
      var input = row.querySelector('.telefono-extra');
      var select = row.querySelector('.telefono-tipo');
      return { telefono: (input ? input.value.trim() : ''), tipo: (select ? select.value : 'otro') };
    }).filter(function(v){ return v.telefono; });
    var emails = Array.from(document.querySelectorAll('#emailsContainer > div')).map(function(row){
      var input = row.querySelector('.email-extra');
      var select = row.querySelector('.email-tipo');
      return { email: (input ? input.value.trim() : ''), tipo: (select ? select.value : 'personal') };
    }).filter(function(v){ return v.email; });
    return {
      id: $('m_id').value,
      empresa_id: $('m_empresa_id').value,
      nombres: $('m_nombres').value.trim(),
      apellidos: $('m_apellidos').value.trim(),
      cargo: $('m_cargo').value.trim(),
      num_doc: $('m_num_doc') ? $('m_num_doc').value.trim() : '',
      origen: $('m_origen') ? $('m_origen').value : '',
      tipo_contacto: $('m_tipo_contacto') ? $('m_tipo_contacto').value.trim() : '',
      fecha_cumpleanos: $('m_fecha_cumpleanos') ? $('m_fecha_cumpleanos').value : '',
      celular: $('m_celular').value.trim(),
      telefono_fijo: $('m_telefono_fijo').value.trim(),
      email: $('m_email').value.trim(),
      email_tipo: $('m_email_tipo') ? $('m_email_tipo').value : 'trabajo',
      direccion: $('m_direccion') ? $('m_direccion').value.trim() : '',
      referencia: $('m_referencia') ? $('m_referencia').value.trim() : '',
      telefonos: telefonos,
      emails: emails
    };
  }

  function openNew(){
    clearForm();
    closeEmpresaQuick();
    $('contactoModalTitle').textContent = 'Nuevo Contacto';
    loadEmpresas('', '');
    openModal();
  }

  function openEdit(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){
        if(!js || !js.success){ Swal.fire({icon:'error', text:'No se pudo cargar el contacto'}); return; }
        clearForm();
        closeEmpresaQuick();
        fillForm(js.data || {});
        loadEmpresas('', (js.data && js.data.empresa_id) ? js.data.empresa_id : '');
        renderHistorial(js.historial || []);
        $('contactoModalTitle').textContent = 'Editar Contacto';
        openModal();
      });
  }

  function save(){
    var payload = collectForm();
    if(!payload.empresa_id){ Swal.fire({icon:'warning', text:'Empresa es requerida.'}); return; }
    if(!payload.nombres){ Swal.fire({icon:'warning', text:'Nombres es requerido.'}); return; }
    var action = payload.id ? 'update' : 'create';
    fetchJson(ctrl + '?action=' + action, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    }).then(function(js){
      if(js && js.success){
        Swal.fire({icon:'success', title:'Listo', timer:1200, showConfirmButton:false});
        closeModal();
        loadContactos();
      } else {
        Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo guardar'});
      }
    });
  }

  function confirmDelete(id){
    if(!id) return;
    Swal.fire({ icon:'warning', title:'Eliminar contacto', text:'¿Desea eliminar este contacto?', showCancelButton:true, confirmButtonText:'Si, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDelete(id); });
  }

  function doDelete(id){
    var fd = new FormData();
    fd.append('id', id);
    fetchJson(ctrl + '?action=delete', { method:'POST', body: fd })
      .then(function(js){
        if(js && js.success){
          Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false});
          loadContactos();
        } else {
          Swal.fire({icon:'error', text:(js && js.message) || 'No se pudo eliminar'});
        }
      });
  }

  function renderHistorial(rows){
    var container = $('historialContainer');
    if (!container) return;
    if (!rows || !rows.length) {
      container.innerHTML = '<div class="text-xs text-gray-500">Sin movimientos</div>';
      return;
    }
    var html = '';
    rows.forEach(function(r){
      var nombre = r.usuario || ((r.nombres || '') + ' ' + (r.apellidos || '')).trim();
      var tipo = (r.tipo_actividad === 'creacion') ? 'Creación' : 'Actualización';
      var fecha = r.fecha || '';
      html += '<div class="border-b border-gray-200 pb-2 mb-2 last:border-b-0 last:pb-0 last:mb-0">'
           +  '<div class="text-gray-800">'+escapeHtml(tipo)+'</div>'
           +  '<div class="text-gray-600">Usuario: '+escapeHtml(nombre || ('ID ' + r.usuario_id))+'</div>'
           +  '<div class="text-gray-500">'+escapeHtml(fecha)+'</div>'
           + '</div>';
    });
    container.innerHTML = html;
  }

  function buildEmpresaLabel(e){
    if (!e) return '';
    return e.nombre_comercial || e.razon_social || e.ruc || (e.id ? ('Empresa #' + e.id) : '');
  }

  function setEmpresaSelection(id, label){
    var input = $('m_empresa_input');
    var hidden = $('m_empresa_id');
    if (hidden) hidden.value = id ? String(id) : '';
    if (input && label) input.value = label;
  }

  function confirmEmpresaChange(nextId, nextLabel, onConfirm){
    var inEdit = !!($('m_id') && $('m_id').value);
    if (!inEdit || !currentEmpresaId || String(nextId) === String(currentEmpresaId)) {
      onConfirm();
      return;
    }
    Swal.fire({
      icon: 'warning',
      title: 'Cambiar empresa',
      text: 'Vas a cambiar la empresa del contacto. ¿Estas seguro?',
      showCancelButton: true,
      confirmButtonText: 'Si, cambiar',
      cancelButtonText: 'Cancelar'
    }).then(function(r){
      if (!r.isConfirmed) {
        setEmpresaSelection(currentEmpresaId, currentEmpresaLabel);
        return;
      }
      onConfirm();
      currentEmpresaId = String(nextId || '');
      currentEmpresaLabel = nextLabel || '';
    });
  }

  function renderEmpresaDropdown(items){
    var dd = $('empresaDropdown');
    if (!dd) return;
    dd.innerHTML = '';
    if (!items || !items.length) {
      dd.innerHTML = '<div class=\"px-3 py-2 text-xs text-gray-500\">Sin resultados</div>';
      return;
    }
    items.forEach(function(e){
      var row = document.createElement('div');
      row.className = 'px-2 py-1 hover:bg-gray-100 cursor-pointer text-sm';
      var nombre = e.nombre_comercial || e.razon_social || ('Empresa #' + (e.id || ''));
      var ruc = e.ruc ? e.ruc : '';
      row.setAttribute('data-id', e.id);
      row.setAttribute('data-text', nombre);
      row.innerHTML = '<div class="font-medium">' + escapeHtml(nombre) + '</div>'
                    + '<div class="text-xs text-gray-600">' + escapeHtml(ruc) + '</div>';
      row.addEventListener('click', function(){
        var label = buildEmpresaLabel(e);
        confirmEmpresaChange(e.id, label, function(){
          setEmpresaSelection(e.id, label);
          toggleEmpresaDropdown(false);
        });
      });
      dd.appendChild(row);
    });
  }

  function toggleEmpresaDropdown(show){
    var dd = $('empresaDropdown');
    if (!dd) return;
    dd.classList.toggle('hidden', !show);
  }

  function loadEmpresas(query, selectedId){
    var q = (query || '').trim();
    var url = ctrl + '?action=empresa_options';
    if (q) {
      url += '&q=' + encodeURIComponent(q);
    }
    fetchJson(url)
      .then(function(js){
        if(!js || !js.success) return;
        var list = js.data || [];
        renderEmpresaDropdown(list);
        if (selectedId) {
          var found = list.find(function(e){ return String(e.id) === String(selectedId); });
          if (found) {
            setEmpresaSelection(found.id, buildEmpresaLabel(found));
          }
        }
      });
  }

  function bindUI(){
    var btnNuevo = $('btnNuevo');
    if(btnNuevo) btnNuevo.addEventListener('click', openNew);
    var btnBuscar = $('btnBuscar');
    if(btnBuscar) btnBuscar.addEventListener('click', function(){ if(paginacion) paginacion.currentPage = 1; loadContactos(); });
    var q = $('ct-q');
    if(q) q.addEventListener('keydown', function(e){ if(e.key === 'Enter'){ e.preventDefault(); if(paginacion) paginacion.currentPage = 1; loadContactos(); } });
    var btnClear = $('btnClearSearch');
    if(btnClear) btnClear.addEventListener('click', function(){ if(q) q.value=''; if(paginacion) paginacion.currentPage = 1; loadContactos(); });
    var sel = $('pageSize');
    if(sel && paginacion){
      sel.addEventListener('change', function(){ paginacion.updateRowsPerPage(parseInt(this.value || '25', 10)); });
    }

    var btnAddTel = $('btnAddTelefono');
    if(btnAddTel) btnAddTel.addEventListener('click', function(){ addTelefonoRow(''); });
    var btnAddEmail = $('btnAddEmail');
    if(btnAddEmail) btnAddEmail.addEventListener('click', function(){ addEmailRow(''); });

    var btnClose = $('btnCloseModal');
    if(btnClose) btnClose.addEventListener('click', closeModal);
    var btnCancel = $('btnCancelar');
    if(btnCancel) btnCancel.addEventListener('click', closeModal);
    var btnGuardar = $('btnGuardar');
    if(btnGuardar) btnGuardar.addEventListener('click', save);

    var btnNuevaEmpresa = $('btnNuevaEmpresa');
    if(btnNuevaEmpresa) btnNuevaEmpresa.addEventListener('click', openEmpresaQuick);
    var btnEmpresaQuickClose = $('btnEmpresaQuickClose');
    if(btnEmpresaQuickClose) btnEmpresaQuickClose.addEventListener('click', closeEmpresaQuick);
    var btnEmpresaQuickCancel = $('btnEmpresaQuickCancel');
    if(btnEmpresaQuickCancel) btnEmpresaQuickCancel.addEventListener('click', closeEmpresaQuick);
    var btnEmpresaQuickSave = $('btnEmpresaQuickSave');
    if(btnEmpresaQuickSave) btnEmpresaQuickSave.addEventListener('click', saveEmpresaQuick);

    var celular = $('m_celular');
    if (celular) {
      celular.setAttribute('inputmode', 'numeric');
      celular.setAttribute('pattern', '[0-9]*');
      celular.addEventListener('input', function(){ this.value = this.value.replace(/\D+/g, ''); });
    }
    var telefonoFijo = $('m_telefono_fijo');
    if (telefonoFijo) {
      telefonoFijo.setAttribute('inputmode', 'numeric');
      telefonoFijo.setAttribute('pattern', '[0-9]*');
      telefonoFijo.addEventListener('input', function(){ this.value = this.value.replace(/\D+/g, ''); });
    }
    var numDoc = $('m_num_doc');
    if (numDoc) {
      numDoc.setAttribute('inputmode', 'numeric');
      numDoc.setAttribute('pattern', '[0-9]*');
      numDoc.addEventListener('input', function(){ this.value = this.value.replace(/\D+/g, ''); });
    }
    var ruc = $('qe_ruc');
    if (ruc) {
      ruc.setAttribute('inputmode', 'numeric');
      ruc.setAttribute('pattern', '[0-9]*');
      ruc.addEventListener('input', function(){ this.value = this.value.replace(/\D+/g, ''); });
    }

    var empresaInput = $('m_empresa_input');
    if (empresaInput) {
      var timer = null;
      empresaInput.addEventListener('focus', function(){
        loadEmpresas(this.value, $('m_empresa_id') ? $('m_empresa_id').value : '');
        toggleEmpresaDropdown(true);
      });
      empresaInput.addEventListener('input', function(){
        var value = this.value;
        var hidden = $('m_empresa_id');
        if (hidden) hidden.value = '';
        clearTimeout(timer);
        timer = setTimeout(function(){
          loadEmpresas(value, $('m_empresa_id') ? $('m_empresa_id').value : '');
          toggleEmpresaDropdown(true);
        }, 200);
      });
      empresaInput.addEventListener('blur', function(){
        setTimeout(function(){ toggleEmpresaDropdown(false); }, 150);
      });
    }
  }

  function applyColumnVisibility(){
    var table = document.getElementById('tablaContactos');
    if (!table) return;
    table.querySelectorAll('[data-col]').forEach(function(el){
      var col = el.getAttribute('data-col');
      var isVisible = columnState[col] !== false;
      el.classList.toggle('hidden', !isVisible);
    });
  }

  window.reloadContactosTable = loadContactos;
  document.addEventListener('DOMContentLoaded', function(){
    bindUI();
    if (columnToggles.length) {
      columnToggles.forEach(function(cb){
        var col = cb.getAttribute('data-col');
        columnState[col] = cb.checked;
        cb.addEventListener('change', function(){
          columnState[col] = cb.checked;
          applyColumnVisibility();
        });
      });
      applyColumnVisibility();
    }
    if(paginacion){ paginacion.renderFunction = function(){ loadContactos(); }; }
    loadContactos();
  });
})();
