(function(){
  function $(id){ return document.getElementById(id); }
  var baseGuess = (typeof base !== 'undefined' && base) ? base : (function(){ var p=location.pathname.split('/'); return p[1] ? ('/'+p[1]+'/') : '/'; })();
  var ctrl = baseGuess + 'controller/categoria/categoria.php';

  var modal = $('modalCategoria');

  function openModal(){ if(modal){ modal.classList.remove('hidden'); modal.classList.add('flex'); } }
  function closeModal(){
    if(modal){ modal.classList.add('hidden'); modal.classList.remove('flex'); }
    clearModal();
  }

  function clearModal(){
    ['m_idcat','m_name_cat','m_descripcion'].forEach(function(id){
      var el = $(id); if(el) el.value = '';
    });
    var st = $('m_status'); if(st) st.value = '1';
    var title = $('modalCatTitle'); if(title) title.textContent = 'Nueva categoría';
    var save = $('m_guardar_cat'); if(save) save.removeAttribute('data-id');
  }

  function fetchJson(url, options){
    var fetchOpts = Object.assign({ credentials: 'same-origin' }, options || {});
    return fetch(url, fetchOpts)
      .then(function(res){ return res.text(); })
      .then(function(text){
        var t = text.replace(/^\uFEFF/, '');
        try { return JSON.parse(t); }
        catch(e){
          var iObj = t.indexOf('{');
          var iArr = t.indexOf('[');
          var start = -1;
          if (iObj === -1 && iArr === -1) throw e;
          if (iObj === -1) start = iArr; else if (iArr === -1) start = iObj; else start = Math.min(iObj, iArr);
          var end = Math.max(t.lastIndexOf('}'), t.lastIndexOf(']'));
          if (start === -1 || end === -1 || end <= start) throw e;
          var sub = t.slice(start, end + 1);
          return JSON.parse(sub);
        }
      });
  }

  function renderRows(rows){
    var tbody = $('tbodyCategorias');
    if(!tbody) return;
    tbody.innerHTML = '';
    if(!rows || !rows.length){
      var tr = document.createElement('tr');
      tr.innerHTML = '<td class=\"px-2 py-1 text-gray-500 text-xs\" colspan=\"6\">Sin datos</td>';
      tbody.appendChild(tr);
      return;
    }
    rows.forEach(function(r){
      var tr = document.createElement('tr');
      var estado = (String(r.status) === '1' ? 'Activo' : 'Inactivo');
      tr.innerHTML =
        '<td class=\"px-2 py-1 text-xs\">'+ (r.idcat || '') +'</td>'+
        '<td class=\"px-2 py-1 text-xs\">'+ (r.name_cat || '') +'</td>'+
        '<td class=\"px-2 py-1 text-xs\">'+ (r.descripcion || '') +'</td>'+
        '<td class=\"px-2 py-1 text-xs\">'+ estado +'</td>'+
        '<td class=\"px-2 py-1 text-xs\">'+ (r.dateupdate || r.datecreate || '') +'</td>'+
        '<td class=\"px-2 py-1 text-xs\">'+
          '<button class=\"btn-cat-edit text-xs text-blue-600 mr-2\" data-id=\"'+ (r.idcat || '') +'\">Editar</button>'+
          '<button class=\"btn-cat-del text-xs text-red-600\" data-id=\"'+ (r.idcat || '') +'\">Eliminar</button>'+
        '</td>';
      tbody.appendChild(tr);
    });
    bindRowActions();
  }

  function fetchList(){
    var q = ($('cat_q') && $('cat_q').value || '').trim();
    var params = new URLSearchParams({ action: 'list', q: q });
    fetchJson(ctrl + '?' + params.toString())
      .then(function(js){
        if(!js || !js.success){ renderRows([]); return; }
        renderRows(js.data || []);
      })
      .catch(function(err){
        console.error('Error cargando categorías:', err);
        renderRows([]);
      });
  }

  function openEdit(id){
    if(!id) return;
    fetchJson(ctrl + '?action=get&id=' + encodeURIComponent(id))
      .then(function(js){
        if(!js || !js.success || !js.data){ return; }
        var d = js.data;
        if($('m_idcat')) $('m_idcat').value = d.idcat || '';
        if($('m_name_cat')) $('m_name_cat').value = d.name_cat || '';
        if($('m_descripcion')) $('m_descripcion').value = d.descripcion || '';
        if($('m_status')) $('m_status').value = String(d.status || '1');
        var title = $('modalCatTitle'); if(title) title.textContent = 'Editar categoría';
        var save = $('m_guardar_cat'); if(save) save.setAttribute('data-id', d.idcat || '');
        openModal();
      });
  }

  function confirmDelete(id){
    if(!id) return;
    if(!window.Swal){
      if(!confirm('¿Desea eliminar esta categoría?')) return;
      doDelete(id);
      return;
    }
    Swal.fire({ icon:'warning', title:'Eliminar categoría', text:'¿Desea eliminar este registro?', showCancelButton:true, confirmButtonText:'Sí, eliminar' })
      .then(function(r){ if(!r.isConfirmed) return; doDelete(id); });
  }

  function doDelete(id){
    var fd = new FormData(); fd.append('id', id);
    fetchJson(ctrl + '?action=delete', { method:'POST', body: fd })
      .then(function(js){
        if(js && js.success){
          if(window.Swal){
            Swal.fire({icon:'success', title:'Eliminado', timer:1200, showConfirmButton:false});
          }
          fetchList();
        } else {
          var msg = (js && js.message) || 'No se pudo eliminar';
          if(window.Swal){ Swal.fire({icon:'error', text: msg}); } else { alert(msg); }
        }
      })
      .catch(function(){
        if(window.Swal){ Swal.fire({icon:'error', text:'Error de red al eliminar'}); } else { alert('Error de red al eliminar'); }
      });
  }

  function bindRowActions(){
    var edits = document.querySelectorAll('.btn-cat-edit');
    for(var i=0;i<edits.length;i++){
      edits[i].addEventListener('click', function(){ openEdit(this.getAttribute('data-id')); });
    }
    var dels = document.querySelectorAll('.btn-cat-del');
    for(var j=0;j<dels.length;j++){
      dels[j].addEventListener('click', function(){ confirmDelete(this.getAttribute('data-id')); });
    }
  }

  function bindEvents(){
    var bBuscar = $('btnCatBuscar'); if(bBuscar){ bBuscar.addEventListener('click', fetchList); }
    var inputQ = $('cat_q'); if(inputQ){
      inputQ.addEventListener('keyup', function(e){ if(e.key === 'Enter'){ fetchList(); } });
    }
    var bNuevo = $('btnCatNuevo'); if(bNuevo){
      bNuevo.addEventListener('click', function(){
        clearModal();
        openModal();
      });
    }
    var bClose = $('btnCloseModalCat'); if(bClose){ bClose.addEventListener('click', closeModal); }
    var bCancel = $('m_cancelar_cat'); if(bCancel){ bCancel.addEventListener('click', closeModal); }

    var bSave = $('m_guardar_cat'); if(bSave){
      bSave.addEventListener('click', function(){
        var id = this.getAttribute('data-id');
        var body = {
          name_cat: ($('m_name_cat') && $('m_name_cat').value || '').trim(),
          descripcion: ($('m_descripcion') && $('m_descripcion').value || '').trim(),
          status: ($('m_status') && $('m_status').value || '1')
        };
        if(!body.name_cat){
          if(window.Swal){ Swal.fire({icon:'warning', text:'El nombre de la categoría es obligatorio.'}); } else { alert('El nombre de la categoría es obligatorio.'); }
          return;
        }
        var url = ctrl + '?action=' + (id ? 'update' : 'create');
        if(id){ body.id = id; }
        fetchJson(url, {
          method:'POST',
          headers:{ 'Content-Type':'application/json' },
          body: JSON.stringify(body)
        })
          .then(function(js){
            if(!js || !js.success){
              var msg = (js && js.message) || 'No se pudo guardar';
              if(window.Swal){ Swal.fire({icon:'error', text: msg}); } else { alert(msg); }
              return;
            }
            if(window.Swal){
              Swal.fire({ icon:'success', title:(id?'Actualizado':'Creado')+' con éxito', timer:1500, showConfirmButton:false });
            }
            closeModal();
            fetchList();
          })
          .catch(function(err){
            console.error('Error al guardar categoría:', err);
            if(window.Swal){ Swal.fire({ icon:'error', text:'Error de red al guardar: ' + err.message }); } else { alert('Error de red al guardar'); }
          });
      });
    }
  }

  document.addEventListener('DOMContentLoaded', function(){
    bindEvents();
    fetchList();
  });
})();

