(function () {
  var API_URL = base + 'controller/campanas/CampaniaApiController.php';
  var CONTACTOS_URL = base + 'controller/campanas/CampaniaContactoController.php?action=contactos&id=';
  var PENDIENTES_URL = base + 'controller/campanas/CampaniaContactoController.php?action=pendientes&id=';

  var treeEl = document.getElementById('tree');
  var searchEl = document.getElementById('treeSearch');
  var btnCreateRoot = document.getElementById('btnCreateRoot');
  var overlay = document.getElementById('overlayPanel');
  var form = document.getElementById('formCampana');
  var btnCerrar = document.getElementById('btnCerrarModal');
  var btnCancelar = document.getElementById('btnCancelarModal');
  var inputTitulo = document.getElementById('titulo');
  var inputAsunto = document.getElementById('asunto');
  var inputInicio = document.getElementById('fecha_inicio');
  var inputFin = document.getElementById('fecha_fin');
  var inputId = document.getElementById('id_campania');
  var inputParent = document.getElementById('parent_id');
  var panelTitle = document.getElementById('panelTitle');
  var contactosEmpty = document.getElementById('contactos-empty');
  var contactosTable = document.getElementById('contactos-table');
  var contactosBody = document.getElementById('contactos-body');
  var contactosPerPage = document.getElementById('contactos-per-page');
  var contactosPagination = document.getElementById('contactos-pagination');
  var pendientesEmpty = document.getElementById('pendientes-empty');
  var pendientesTable = document.getElementById('pendientes-table');
  var pendientesBody = document.getElementById('pendientes-body');
  var pendientesPagination = document.getElementById('pendientes-pagination');
  var pendientesPerPage = document.getElementById('pendientes-per-page');
  var crumbsEl = document.getElementById('crumbs');
  var titleEl = document.getElementById('h1');
  var metaEl = document.getElementById('meta');
  var metaStatusEl = document.getElementById('meta-estado');
  var metaAsuntoEl = document.getElementById('meta-asunto');
  var metaAsuntoTextEl = document.getElementById('meta-asunto-text');
  var kpiDirectEl = document.getElementById('kpiDirect');
  var kpiTotalEl = document.getElementById('kpiTotal');
  var kpiSendsEl = document.getElementById('kpiSends');
  var kpiOpenedEl = document.getElementById('kpiOpened');
  var kpiClickersEl = document.getElementById('kpiClickers');
  var kpiPendingEl = document.getElementById('kpiPending');
  var tabsEl = document.getElementById('tabs');
  var panelHelp = document.getElementById('panel-help');
  var panelContactos = document.getElementById('panel-contactos');
  var panelPendientes = document.getElementById('panel-pendientes');

  var treeData = [];
  var expanded = new Set();
  var selectedId = null;
  var contactosData = [];
  var contactosSort = { key: '', dir: 'asc' };
  var contactosPage = 1;
  var pendientesData = [];
  var pendientesPage = 1;

  function fetchJson(url, options) {
    return fetch(url, options || {}).then(function (res) {
      if (!res.ok) {
        throw new Error('Request failed');
      }
      return res.json();
    });
  }

  function loadCampanas(nextSelectedId) {
    fetchJson(API_URL + '?action=list').then(function (data) {
      if (!data.success) {
        throw new Error(data.message || 'Error');
      }
      treeData = data.data || [];
      renderTree();
      updateSortIndicators();
      if (nextSelectedId) {
        if (findItemById(treeData, nextSelectedId)) {
          selectCampaign(nextSelectedId);
        }
      } else if (selectedId && findItemById(treeData, selectedId)) {
        selectCampaign(selectedId);
      } else {
        selectedId = null;
        showDefaultHeader();
        showContactEmpty('Selecciona una campana para ver sus contactos.');
      }
    }).catch(function () {
      renderTreeEmpty();
    });
  }

  function renderTreeEmpty() {
    if (!treeEl) {
      return;
    }
    treeEl.innerHTML = '<div class="px-3 py-4 text-sm text-gray-500">Sin campanas</div>';
  }

  function normalizeDate(value) {
    if (!value) {
      return '';
    }
    return value.substring(0, 10);
  }

  function renderTree() {
    if (!treeEl) {
      return;
    }
    var query = searchEl ? searchEl.value.trim().toLowerCase() : '';
    var data = treeData;
    var forceOpen = false;
    if (query) {
      data = filterTree(treeData, query);
      forceOpen = true;
    }

    if (!data || !data.length) {
      renderTreeEmpty();
      return;
    }

    treeEl.innerHTML = renderList(data, forceOpen);
  }

  function renderList(items, forceOpen) {
    var html = '<ul>';
    items.forEach(function (item) {
      var hasChildren = item.children && item.children.length;
      var isOpen = forceOpen || expanded.has(item.id_campania);
      var title = escapeHtml(item.titulo || '');
      var sub = '';
      var instancia = escapeHtml(item.instancia_nombre || '');
      var childCount = hasChildren ? item.children.length : 0;
      var caret = hasChildren
        ? '<button type="button" class="caret" data-action="toggle" data-id="' + item.id_campania + '">' +
          '<i class="fas fa-chevron-' + (isOpen ? 'down' : 'right') + '"></i>' +
          '</button>'
        : '<span class="caret" aria-hidden="true"></span>';

      html += '<li>';
      html += '<div class="node' + (selectedId === item.id_campania ? ' selected' : '') + '" data-id="' + item.id_campania + '">';
      html += caret;
      html += '<div class="node-main">';
      html += '<div class="node-title">' + title + '</div>';
      var subText = instancia ? ('Mautic: ' + instancia) : '';
      html += '<div class="node-sub">' + subText + '</div>';
      html += '</div>';
      html += '<div class="badges">';
      html += '<span class="badge outline">ID ' + item.id_campania + '</span>';
      if (childCount) {
        html += '<span class="badge orange">' + childCount + ' sub</span>';
      }
      html += '</div>';
      html += '</div>';

      if (hasChildren && isOpen) {
        html += renderList(item.children, forceOpen);
      }
      html += '</li>';
    });
    html += '</ul>';
    return html;
  }

  function openModal(mode, data) {
    form.dataset.mode = mode;
    inputId.value = data && data.id_campania ? data.id_campania : '';
    inputParent.value = data && data.parent_id ? data.parent_id : '';
    inputTitulo.value = data && data.titulo ? data.titulo : '';
    inputAsunto.value = data && data.asunto ? data.asunto : '';
    inputInicio.value = normalizeDate(data && data.fecha_inicio ? data.fecha_inicio : '');
    inputFin.value = normalizeDate(data && data.fecha_fin ? data.fecha_fin : '');
    panelTitle.textContent = mode === 'edit' ? 'Editar Campana' : 'Nueva Campana';
    overlay.classList.remove('hidden');
  }

  function closeModal() {
    overlay.classList.add('hidden');
  }

  function submitForm(payload, action) {
    return fetchJson(API_URL + '?action=' + action, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  }

  function loadContactos(id) {
    fetchJson(CONTACTOS_URL + id).then(function (data) {
      if (!data || !data.length) {
        showContactEmpty('Esta campana no tiene contactos asignados.');
        updateHeader(findItemById(treeData, id), 0);
        return;
      }
      contactosData = data;
      contactosPage = 1;
      showContactTable();
      updateHeader(findItemById(treeData, id), data.length);
      updateSortIndicators();
      renderContactos();
    }).catch(function () {
      showContactEmpty('Error al cargar contactos.');
      updateHeader(findItemById(treeData, id), '--');
    });
  }

  function showContactEmpty(message) {
    if (!contactosEmpty || !contactosTable) {
      return;
    }
    contactosEmpty.textContent = message;
    contactosEmpty.classList.remove('hidden');
    contactosTable.classList.add('hidden');
    if (contactosPagination) {
      contactosPagination.classList.add('hidden');
    }
  }

  function showContactTable() {
    if (!contactosEmpty || !contactosTable) {
      return;
    }
    contactosEmpty.classList.add('hidden');
    contactosTable.classList.remove('hidden');
    if (contactosPagination) {
      contactosPagination.classList.remove('hidden');
    }
  }

  function renderContactos() {
    if (!contactosBody) {
      return;
    }
    var rows = contactosData.slice();
    if (contactosSort.key) {
      rows.sort(function (a, b) {
        var av = Number(a[contactosSort.key] || 0);
        var bv = Number(b[contactosSort.key] || 0);
        if (av === bv) {
          return 0;
        }
        return contactosSort.dir === 'asc' ? (av - bv) : (bv - av);
      });
    }
    contactosBody.innerHTML = '';
    var perPage = contactosPerPage ? parseInt(contactosPerPage.value, 10) : 25;
    if (!perPage || perPage <= 0) {
      perPage = 25;
    }
    var totalPages = Math.max(1, Math.ceil(rows.length / perPage));
    if (contactosPage > totalPages) {
      contactosPage = totalPages;
    }
    var start = (contactosPage - 1) * perPage;
    var pageRows = rows.slice(start, start + perPage);

    pageRows.forEach(function (c) {
      var abierto = c.open || ((c.open_flag || 0) > 0 ? 'Yes' : 'No');
      var nombre = ((c.nombres || '') + ' ' + (c.apellidos || '')).trim();
      var email = c.email || '';
      var empresa = c.empresa || '';
      var cargo = c.cargo || '';
      var telefono = c.telefono || '';
      var celular = c.celular || '';
      var trabajadores = (c.n_trabajadores === 0 || c.n_trabajadores) ? String(c.n_trabajadores) : '';
      var nombreShort = truncateText(nombre, 35);
      var emailShort = truncateText(email, 35);
      var empresaShort = truncateText(empresa, 35);
      var cargoShort = truncateText(cargo, 30);
      var telefonoShort = truncateText(telefono, 20);
      var celularShort = truncateText(celular, 20);
      var row = '<tr class="border-b hover:bg-gray-50">' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(empresa) + '">' + escapeHtml(empresaShort) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(trabajadores) + '">' + escapeHtml(trabajadores) + '</td>' +
        '<td class="px-2 py-1 font-medium text-xs" title="' + escapeHtml(nombre) + '">' + escapeHtml(nombreShort) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(cargo) + '">' + escapeHtml(cargoShort) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(email) + '">' + escapeHtml(emailShort) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(telefono) + '">' + escapeHtml(telefonoShort) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(celular) + '">' + escapeHtml(celularShort) + '</td>' +
        '<td class="px-2 py-1 text-center text-xs">' + abierto + '</td>' +
        '<td class="px-2 py-1 text-center text-xs">' + (c.clicks || 0) + '</td>' +
        '</tr>';
      contactosBody.insertAdjacentHTML('beforeend', row);
    });

    renderContactPagination(totalPages);
  }

  function renderContactPagination(totalPages) {
    if (!contactosPagination) {
      return;
    }
    var html = '';
    var prevDisabled = contactosPage <= 1 ? 'opacity-50 cursor-not-allowed' : '';
    var nextDisabled = contactosPage >= totalPages ? 'opacity-50 cursor-not-allowed' : '';
    html += '<div class="flex flex-wrap items-center gap-2 text-xs">';
    html += '<button class="px-2 py-1 border rounded ' + prevDisabled + '" data-page="prev">Anterior</button>';
    for (var i = 1; i <= totalPages; i++) {
      var active = i === contactosPage ? 'bg-gray-800 text-white border-gray-800' : '';
      html += '<button class="px-2 py-1 border rounded ' + active + '" data-page="' + i + '">' + i + '</button>';
    }
    html += '<button class="px-2 py-1 border rounded ' + nextDisabled + '" data-page="next">Siguiente</button>';
    html += '</div>';
    contactosPagination.innerHTML = html;
  }

  function bindContactSorting() {
    var headers = document.querySelectorAll('#contactos-table th.sortable');
    headers.forEach(function (th) {
      th.addEventListener('click', function () {
        var key = th.getAttribute('data-sort');
        if (!key) {
          return;
        }
        if (contactosSort.key === key) {
          contactosSort.dir = contactosSort.dir === 'asc' ? 'desc' : 'asc';
        } else {
          contactosSort.key = key;
          contactosSort.dir = 'asc';
        }
        updateSortIndicators();
        renderContactos();
      });
    });
    if (contactosPagination) {
      contactosPagination.addEventListener('click', function (e) {
        var btn = e.target.closest('button');
        if (!btn) {
          return;
        }
        var target = btn.getAttribute('data-page');
        if (!target) {
          return;
        }
        if (target === 'prev') {
          contactosPage = Math.max(1, contactosPage - 1);
        } else if (target === 'next') {
          contactosPage = contactosPage + 1;
        } else {
          var page = parseInt(target, 10);
          if (!isNaN(page)) {
            contactosPage = page;
          }
        }
        renderContactos();
      });
    }
    if (contactosPerPage) {
      contactosPerPage.addEventListener('change', function () {
        contactosPage = 1;
        renderContactos();
      });
    }
  }

  function updateSortIndicators() {
    var indicators = document.querySelectorAll('#contactos-table .sort-indicator');
    indicators.forEach(function (el) {
      var key = el.getAttribute('data-indicator');
      if (!key) {
        return;
      }
      if (contactosSort.key === key) {
        el.textContent = contactosSort.dir === 'asc' ? '↑' : '↓';
      } else {
        el.textContent = '↕';
      }
    });
  }

  function showDefaultHeader() {
    if (crumbsEl) {
      crumbsEl.textContent = 'Selecciona una campana';
    }
    if (titleEl) {
      titleEl.textContent = 'Gestion de campanas';
    }
    if (metaEl) {
      metaEl.textContent = '';
    }
    if (metaStatusEl) {
      metaStatusEl.textContent = '';
    }
    setKpis('--', '--', '--', '--', '--', '--');
    setActiveTab('resumen');
  }

  function setKpis(direct, total, sends, opened, clickers, pending) {
    if (kpiDirectEl) {
      kpiDirectEl.textContent = direct;
    }
    if (kpiTotalEl) {
      kpiTotalEl.textContent = total;
    }
    if (kpiSendsEl) {
      kpiSendsEl.textContent = sends;
    }
    if (kpiOpenedEl) {
      kpiOpenedEl.textContent = opened;
    }
    if (kpiClickersEl) {
      kpiClickersEl.textContent = clickers;
    }
    if (kpiPendingEl) {
      kpiPendingEl.textContent = pending;
    }
  }

  function updateHeader(item, directCount) {
    if (!item) {
      showDefaultHeader();
      return;
    }
    if (crumbsEl) {
      crumbsEl.textContent = 'Campana / ' + (item.titulo || '');
    }
    if (titleEl) {
      titleEl.textContent = item.titulo || 'Campana';
    }
    if (metaEl) {
      var dateParts = [];
      if (item.fecha_inicio) {
        dateParts.push('Inicio: ' + item.fecha_inicio);
      }
      if (item.fecha_fin) {
        dateParts.push('Fin: ' + item.fecha_fin);
      }
      var dateLine = dateParts.join(' | ');
      metaEl.textContent = dateLine;
      if (metaAsuntoEl && metaAsuntoTextEl) {
        metaAsuntoTextEl.textContent = 'Asunto: ' + (item.asunto || 'Sin asunto');
      }
    }
    if (metaStatusEl) {
      metaStatusEl.textContent = 'Estado: ' + getCampaignStatus(item);
    }
    var count = typeof directCount === 'number' ? directCount : '--';
    setKpis(count, count, '--', '--', '--', '--');
  }

  function getCampaignStatus(item) {
    if (!item || !item.fecha_inicio || !item.fecha_fin) {
      return 'Sin Rango de Fecha';
    }
    var now = new Date();
    var start = new Date(item.fecha_inicio + 'T00:00:00');
    var end = new Date(item.fecha_fin + 'T23:59:59');
    if (now < start) {
      return 'Proximo lanzamiento';
    }
    if (now > end) {
      return 'Finalizada';
    }
    return 'Activa';
  }

  function setActiveTab(tab) {
    if (tabsEl) {
      var tabs = tabsEl.querySelectorAll('.tab');
      tabs.forEach(function (btn) {
        btn.classList.toggle('active', btn.getAttribute('data-tab') === tab);
      });
    }
    if (panelHelp) {
      panelHelp.classList.toggle('hidden', tab !== 'resumen');
    }
    if (panelContactos) {
      panelContactos.classList.toggle('hidden', tab !== 'contactos');
    }
    if (panelPendientes) {
      panelPendientes.classList.toggle('hidden', tab !== 'pendientes');
    }
    if (tab === 'pendientes') {
      if (contactosEmpty) {
        contactosEmpty.classList.add('hidden');
      }
      if (contactosTable) {
        contactosTable.classList.add('hidden');
      }
      if (contactosPagination) {
        contactosPagination.classList.add('hidden');
      }
    }
    if (tab === 'contactos') {
      if (pendientesTable) {
        pendientesTable.classList.add('hidden');
      }
      if (pendientesEmpty) {
        pendientesEmpty.classList.add('hidden');
      }
    }
  }

  function selectCampaign(id) {
    if (!id) {
      return;
    }
    selectedId = id;
    renderTree();
    var item = findItemById(treeData, id);
    updateHeader(item, '--');
    setActiveTab('contactos');
    showContactEmpty('Cargando contactos...');
    loadContactos(id);
    loadMetrics(id);
  }

  function showPendientesEmpty(message) {
    if (!pendientesEmpty || !pendientesTable) {
      return;
    }
    pendientesEmpty.textContent = message || 'Sin pendientes.';
    pendientesEmpty.classList.remove('hidden');
    pendientesTable.classList.add('hidden');
    if (pendientesPagination) {
      pendientesPagination.classList.add('hidden');
    }
  }

  function showPendientesTable() {
    if (!pendientesEmpty || !pendientesTable) {
      return;
    }
    pendientesEmpty.classList.add('hidden');
    pendientesTable.classList.remove('hidden');
    if (pendientesPagination) {
      pendientesPagination.classList.remove('hidden');
    }
  }

  function renderPendientes() {
    if (!pendientesBody) {
      return;
    }
    pendientesBody.innerHTML = '';
    if (!pendientesData.length) {
      showPendientesEmpty('No hay pendientes para esta campana.');
      return;
    }
    showPendientesTable();
    var perPage = pendientesPerPage ? parseInt(pendientesPerPage.value, 10) : 25;
    if (!perPage || perPage <= 0) {
      perPage = 25;
    }
    var totalPages = Math.max(1, Math.ceil(pendientesData.length / perPage));
    if (pendientesPage > totalPages) {
      pendientesPage = totalPages;
    }
    var start = (pendientesPage - 1) * perPage;
    var pageRows = pendientesData.slice(start, start + perPage);
    pageRows.forEach(function (row) {
      var email = row.email || '';
      var leadId = row.mautic_lead_id || '--';
      var firstSeen = row.first_seen_at || '--';
      var lastSeen = row.last_seen_at || '--';
      var source = row.source || '--';
      var emailShort = truncateText(email, 40);
      var html = '<tr class="border-b hover:bg-gray-50">' +
        '<td class="px-2 py-1 text-xs text-gray-600" title="' + escapeHtml(email) + '">' + escapeHtml(emailShort) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600">' + escapeHtml(String(leadId)) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600">' + escapeHtml(firstSeen) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600">' + escapeHtml(lastSeen) + '</td>' +
        '<td class="px-2 py-1 text-xs text-gray-600">' + escapeHtml(source) + '</td>' +
        '</tr>';
      pendientesBody.insertAdjacentHTML('beforeend', html);
    });
    renderPendientesPagination(totalPages);
  }

  function renderPendientesPagination(totalPages) {
    if (!pendientesPagination) {
      return;
    }
    var html = '';
    var prevDisabled = pendientesPage <= 1 ? 'opacity-50 cursor-not-allowed' : '';
    var nextDisabled = pendientesPage >= totalPages ? 'opacity-50 cursor-not-allowed' : '';
    html += '<div class="flex flex-wrap items-center gap-2 text-xs">';
    html += '<button class="px-2 py-1 border rounded ' + prevDisabled + '" data-page="prev">Anterior</button>';
    for (var i = 1; i <= totalPages; i++) {
      var active = i === pendientesPage ? 'bg-gray-800 text-white border-gray-800' : '';
      html += '<button class="px-2 py-1 border rounded ' + active + '" data-page="' + i + '">' + i + '</button>';
    }
    html += '<button class="px-2 py-1 border rounded ' + nextDisabled + '" data-page="next">Siguiente</button>';
    html += '</div>';
    pendientesPagination.innerHTML = html;
  }

  function loadPendientes(id) {
    if (!id) {
      return;
    }
    showPendientesEmpty('Cargando pendientes...');
    fetchJson(PENDIENTES_URL + id).then(function (data) {
      pendientesData = Array.isArray(data) ? data : [];
      pendientesPage = 1;
      renderPendientes();
    }).catch(function () {
      pendientesData = [];
      showPendientesEmpty('No se pudo cargar pendientes.');
    });
  }

  if (pendientesPerPage) {
    pendientesPerPage.addEventListener('change', function () {
      pendientesPage = 1;
      renderPendientes();
    });
  }

  if (btnCreateRoot) {
    btnCreateRoot.addEventListener('click', function () {
      openModal('create', {});
    });
  }

  if (btnCerrar) {
    btnCerrar.addEventListener('click', closeModal);
  }

  if (btnCancelar) {
    btnCancelar.addEventListener('click', closeModal);
  }

  if (overlay) {
    overlay.addEventListener('click', closeModal);
  }

  if (form) {
    form.addEventListener('submit', function (e) {
      e.preventDefault();
      var mode = form.dataset.mode || 'create';
      var payload = {
        titulo: inputTitulo.value.trim(),
        asunto: inputAsunto.value.trim(),
        fecha_inicio: inputInicio.value || null,
        fecha_fin: inputFin.value || null,
        parent_id: inputParent.value ? parseInt(inputParent.value, 10) : null
      };

      if (!payload.titulo) {
        alert('Titulo requerido');
        return;
      }

      if (mode === 'edit') {
        payload.id = parseInt(inputId.value, 10);
        submitForm(payload, 'update').then(function () {
          closeModal();
          loadCampanas(payload.id);
        });
        return;
      }

      submitForm(payload, 'create').then(function () {
        closeModal();
        if (payload.parent_id) {
          expanded.add(payload.parent_id);
        }
        loadCampanas();
      });
    });
  }

  if (treeEl) {
    treeEl.addEventListener('click', function (e) {
      var target = e.target;
      var actionEl = target.closest('[data-action]');
      if (actionEl) {
        e.preventDefault();
        var action = actionEl.getAttribute('data-action');
        var actionId = parseInt(actionEl.getAttribute('data-id'), 10);

        if (action === 'toggle') {
          if (expanded.has(actionId)) {
            expanded.delete(actionId);
          } else {
            expanded.add(actionId);
          }
          renderTree();
          return;
        }

        if (action === 'edit') {
          var editItem = findItemById(treeData, actionId);
          if (editItem) {
            openModal('edit', editItem);
          }
          return;
        }

        if (action === 'add') {
          openModal('create', { parent_id: actionId });
          return;
        }

        if (action === 'delete') {
          if (confirm('Eliminar campana?')) {
            submitForm({ id: actionId }, 'delete').then(function () {
              if (selectedId === actionId) {
                selectedId = null;
                showContactEmpty('Selecciona una campana para ver sus contactos.');
              }
              loadCampanas();
            });
          }
          return;
        }
      }

      var node = target.closest('.node');
      if (node) {
        var nodeId = parseInt(node.getAttribute('data-id'), 10);
        if (nodeId) {
          selectCampaign(nodeId);
        }
      }
    });
  }

  if (searchEl) {
    searchEl.addEventListener('input', renderTree);
  }

  if (tabsEl) {
    tabsEl.addEventListener('click', function (e) {
      var target = e.target;
      var tab = target.closest('.tab');
      if (!tab) {
        return;
      }
      var tabKey = tab.getAttribute('data-tab');
      if (tabKey === 'contactos' || tabKey === 'resumen' || tabKey === 'pendientes') {
        setActiveTab(tabKey);
        if (tabKey === 'contactos' && selectedId) {
          showContactEmpty('Cargando contactos...');
          loadContactos(selectedId);
        }
        if (tabKey === 'pendientes' && selectedId) {
          loadPendientes(selectedId);
        }
      }
    });
  }

  if (pendientesPagination) {
    pendientesPagination.addEventListener('click', function (e) {
      var btn = e.target.closest('button');
      if (!btn) {
        return;
      }
      var target = btn.getAttribute('data-page');
      if (!target) {
        return;
      }
      if (target === 'prev') {
        pendientesPage = Math.max(1, pendientesPage - 1);
      } else if (target === 'next') {
        var totalPages = Math.max(1, Math.ceil(pendientesData.length / 25));
        pendientesPage = Math.min(totalPages, pendientesPage + 1);
      } else {
        var page = parseInt(target, 10);
        if (page) {
          pendientesPage = page;
        }
      }
      renderPendientes();
    });
  }

  function findItemById(items, id) {
    for (var i = 0; i < items.length; i++) {
      var item = items[i];
      if (item.id_campania === id) {
        return item;
      }
      if (item.children && item.children.length) {
        var found = findItemById(item.children, id);
        if (found) {
          return found;
        }
      }
    }
    return null;
  }

  function filterTree(items, query) {
    if (!query) {
      return items;
    }
    var result = [];
    items.forEach(function (item) {
      var match = (item.titulo || '').toLowerCase().indexOf(query) !== -1;
      var childMatches = item.children ? filterTree(item.children, query) : [];
      if (match || childMatches.length) {
        var copy = Object.assign({}, item);
        copy.children = childMatches;
        result.push(copy);
      }
    });
    return result;
  }

  function loadMetrics(id) {
    fetchJson(API_URL + '?action=metrics&id=' + id).then(function (data) {
      if (!data || !data.success) {
        return;
      }
      var metrics = data.data || {};
      var total = metrics.total_contactos || 0;
      var clicks = metrics.clickers_total || 0;
      var opens = metrics.open_total || 0;
      var pending = Math.max(0, total - opens);
      setKpis(total, total, total, opens, clicks, pending);
    }).catch(function () {
      setKpis('--', '--', '--', '--', '--', '--');
    });
  }

  function escapeHtml(text) {
    return String(text || '')
      .replace(/&/g, '&amp;')
      .replace(/</g, '&lt;')
      .replace(/>/g, '&gt;')
      .replace(/"/g, '&quot;')
      .replace(/'/g, '&#39;');
  }

  function truncateText(text, maxLen) {
    var value = String(text || '');
    if (value.length <= maxLen) {
      return value;
    }
    return value.slice(0, maxLen - 1) + '…';
  }

  bindContactSorting();
  loadCampanas();
})();

