# SYSTEM_CRM

Sistema CRM en PHP con integración a Notion y frontend con TailwindCSS. Incluye un pequeño servidor Node.js para notificaciones en tiempo real y sincronización.

**Contenido**
- Requisitos
- Instalación rápida
- Variables de entorno
- Servidor de sincronización (Node.js)
- Base de datos
- Desarrollo y ejecución
- Buenas prácticas (.env y dependencias)
- Archivos ignorados y cómo obtenerlos

**Requisitos**
- PHP 8.x y MySQL (XAMPP/LAMP/MAMP). Acceso a `php` por línea de comando.
- Node.js 18+ y npm.
- Composer (si necesitas reinstalar dependencias PHP).

**Instalación rápida**
- instalacion de php PhpSpreadsheet funcion para importar e exportar excel
- PHP 8.0 o superior
- Composer instalado
- MySQL / MariaDB
- Extensiones PHP habilitadas:
- pdo
- pdo_mysql
- zip
- xml
- gd
- escribir en la terminal composer require phpoffice/phpspreadsheet.
- esto creara la carpeta /vendor/vendor/autoload.php
- estructura requerida
- controller/
└── campanas/
    ├── CampanasExcelController.php
models/
├── Campanas.php
└── Subcampanas.php
-desde el modulo de campañas usar el modulo de campañas
-usando el boton para crear el archivo excel con las campañas y subcampañas creadas previamente, con todos los registros y atributos del modulo
-Recomendaciones****
-Exportar antes de importar
-No eliminar columnas del Excel
-Verificar fechas (inicio < fin)
-Las subcampañas solo se importan si la campaña existe

- Clonar el repo en `htdocs` (XAMPP) y abrir `http://localhost/SYSTEM_CRM/`.
- Copiar variables de entorno y completar valores:
  - Windows (CMD): `copy .env.example .env`
  - PowerShell: `cp .env.example .env`
  - macOS/Linux: `cp .env.example .env`
- Instalar dependencias de Node en la raíz: `npm install`.
- Servidor de sincronización (si usas tiempo real): `node server/sync-server.js`.
- PHP (solo si falta `config/vendor/`): `cd config && composer install`.

**Variables de entorno**
- Archivo: `.env` en la raíz del proyecto.
- No subir `.env` al repositorio. Usa `.env.example` como plantilla.
- Variables esperadas:
  - `NOTION_TOKEN`, `NOTION_DATABASE_ID_CLIENTES`, `NOTION_DATABASE_ID_USUARIOS`, `NOTION_VERSION`
  - `DB_HOST`, `DB_PORT`, `DB_NAME`, `DB_USER`, `DB_PASS`

Ejemplo: ver `./.env.example`.

**CSS**
- El proyecto ya incluye `assets/css/output.css` y otros CSS listos.
- No es necesario compilar Tailwind para ejecutar el sistema.

**Servidor de sincronización (Node.js)**
- Archivo: `server/sync-server.js`
- Dependencias: `express`, `socket.io` (instaladas con `npm install`).
- Arranque: `node server/sync-server.js`
- Puerto por defecto: `8080` (cambia con `PORT` en entorno si lo deseas).
- Requisitos:
  - El binario `php` debe estar disponible en PATH, ya que el servidor ejecuta scripts PHP para sincronización.

**Base de datos**
- Credenciales desde `.env`.
- Script de ajustes de tablas: `config/Tablas.sql` (ejecútalo sobre tu base de datos si corresponde).

**Desarrollo y ejecución**
- Backend PHP: servido por Apache de XAMPP en `http://localhost/SYSTEM_CRM/`.
- Socket/Tiempo real: levantar `node server/sync-server.js`.
- Estilos: si modificas CSS utilitario y usas Tailwind, configura tu flujo de build localmente (no requerido para correr la app tal cual).

**Buenas prácticas (.env y dependencias)**
- `.env`:
  - No lo subas al repositorio. Mantén solo `./.env.example` con valores de ejemplo.
  - Si `.env` ya quedó versionado alguna vez, considera rotar los tokens/contraseñas y eliminarlo del historial.
- PHP (Composer):
  - Este proyecto incluye `config/composer.json` y actualmente tiene `config/vendor/` versionado para portabilidad.
  - Recomendado en entornos formales: no versionar `vendor/` y ejecutar `cd config && composer install` en despliegue/CI.
- Node (npm):
  - No versionar `node_modules/`. Instalar siempre con `npm install` en la raíz del proyecto.

**Rutas y archivos relevantes**
- App PHP: `index.php`, `controller/`, `models/`, `view/`, `config/`
- Entorno: `.env` (plantilla en `./.env.example`)
- Composer PHP: `config/composer.json`, `config/vendor/`
- Node: `package.json`, `node_modules/`, `server/sync-server.js`

**Solución de problemas**
- PHP Dotenv no carga:
  - Verifica `config/vendor/` o ejecuta `cd config && composer install`.
- No compila Tailwind:
  - Confirma Node 18+, ejecuta `npm install` y luego `npm run build`.
- Node no encuentra `php`:
  - En Windows, agrega el `php.exe` de XAMPP a la variable de entorno PATH.

**Archivos ignorados y cómo obtenerlos**
- `node_modules/` (ignorado): ejecutar `npm install` en la raíz para restaurar dependencias de Node.
- `config/vendor/` (idealmente ignorado): si no está presente, ejecutar `cd config && composer install` para restaurar dependencias PHP.
- `.env` (ignorado): copiar desde `./.env.example` y completar credenciales.
- `server/last_sync_time.json` (ignorado): se genera automáticamente al ejecutar `node server/sync-server.js`.
- Logs (`**/error_log`, `npm-debug.log*`, etc.): se ignoran automáticamente; no subir.
